/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.data.EntitiesDataStorage;
import fi.dy.masa.minihud.event.RenderHandler;
import fi.dy.masa.minihud.mixin.IMixinAbstractHorseEntity;
import fi.dy.masa.minihud.mixin.IMixinPiglinEntity;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4836;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class RayTraceUtils {
    @Nonnull
    public static class_239 getRayTraceFromEntity(class_1937 worldIn, class_1297 entityIn, boolean useLiquids) {
        double reach = 5.0;
        return RayTraceUtils.getRayTraceFromEntity(worldIn, entityIn, useLiquids, reach);
    }

    @Nonnull
    public static class_239 getRayTraceFromEntity(class_1937 worldIn, class_1297 entityIn, boolean useLiquids, double range) {
        class_3959.class_242 fluidMode;
        class_243 rangedLookRot;
        class_243 lookVec;
        class_243 eyesVec = new class_243(entityIn.method_23317(), entityIn.method_23318() + (double)entityIn.method_5751(), entityIn.method_23321());
        class_3959 context = new class_3959(eyesVec, lookVec = eyesVec.method_1019(rangedLookRot = entityIn.method_5828(1.0f).method_1021(range)), class_3959.class_3960.field_17558, fluidMode = useLiquids ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348, entityIn);
        class_3965 result = worldIn.method_17742(context);
        if (result == null) {
            result = class_3965.method_17778((class_243)class_243.field_1353, (class_2350)class_2350.field_11036, (class_2338)class_2338.field_10980);
        }
        class_238 bb = entityIn.method_5829().method_1009(rangedLookRot.field_1352, rangedLookRot.field_1351, rangedLookRot.field_1350).method_1009(1.0, 1.0, 1.0);
        List list = worldIn.method_8335(entityIn, bb);
        double closest = result.method_17783() == class_239.class_240.field_1332 ? eyesVec.method_1022(result.method_17784()) : Double.MAX_VALUE;
        Optional entityTrace = Optional.empty();
        class_1297 targetEntity = null;
        for (int i = 0; i < list.size(); ++i) {
            double distance;
            class_1297 entity = (class_1297)list.get(i);
            bb = entity.method_5829();
            Optional traceTmp = bb.method_992(lookVec, eyesVec);
            if (!traceTmp.isPresent() || !((distance = eyesVec.method_1022((class_243)traceTmp.get())) <= closest)) continue;
            targetEntity = entity;
            entityTrace = traceTmp;
            closest = distance;
        }
        if (targetEntity != null) {
            result = new class_3966(targetEntity, (class_243)entityTrace.get());
        }
        return result;
    }

    @Nullable
    public static InventoryPreviewData getTargetInventory(class_310 mc) {
        class_638 world = mc.field_1687;
        class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        if (mc.field_1724 == null || world == null) {
            return null;
        }
        class_239 trace = RayTraceUtils.getRayTraceFromEntity((class_1937)world, cameraEntity, false);
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)trace).method_17777();
            RenderHandler.getInstance().requestBlockEntityAt((class_1937)world, pos);
            assert (bestWorld != null);
            class_1263 inv = InventoryUtils.getInventory((class_1937)bestWorld, (class_2338)pos);
            if (inv == null) {
                return null;
            }
            return new InventoryPreviewData(inv, bestWorld.method_8321(pos), null);
        }
        if (trace.method_17783() == class_239.class_240.field_1331) {
            assert (bestWorld != null);
            class_1297 entity = ((class_3966)trace).method_17782();
            EntitiesDataStorage.getInstance().requestEntity(entity.method_5628());
            return RayTraceUtils.getTargetInventoryFromEntity(bestWorld.method_8469(entity.method_5628()));
        }
        return null;
    }

    public static InventoryPreviewData getTargetInventoryFromEntity(class_1297 entity) {
        class_1263 inv = null;
        class_1309 entityLivingBase = null;
        if (entity instanceof class_1309) {
            entityLivingBase = (class_1309)entity;
        }
        if (entity instanceof class_1263) {
            inv = (class_1263)entity;
        } else if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            inv = new class_1277((class_1799[])player.method_31548().field_7547.toArray((Object[])new class_1799[36]));
        } else if (entity instanceof class_1646) {
            inv = ((class_1646)entity).method_35199();
        } else if (entity instanceof class_1496) {
            inv = ((IMixinAbstractHorseEntity)entity).minihud_getHorseInventory();
        } else if (entity instanceof class_4836) {
            inv = ((IMixinPiglinEntity)entity).inventory();
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        return new InventoryPreviewData(inv, null, entityLivingBase);
    }

    public record InventoryPreviewData(class_1263 inv, @Nullable class_2586 te, @Nullable class_1309 entity) {
    }
}

