/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui;

import com.google.common.collect.Queues;
import java.util.List;
import java.util.Queue;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8001;
import org.jetbrains.annotations.ApiStatus;
import org.thinkingstudio.obsidianui.SprucePositioned;
import org.thinkingstudio.obsidianui.Tooltipable;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;

public class Tooltip
implements SprucePositioned {
    private static final Queue<Tooltip> TOOLTIPS = Queues.newConcurrentLinkedQueue();
    private static boolean delayed = false;
    private final int x;
    private final int y;
    private final List<class_5481> tooltip;

    public Tooltip(int x, int y, String tooltip, int parentWidth) {
        this(x, y, class_5348.method_29430((String)tooltip), parentWidth);
    }

    public Tooltip(int x, int y, class_5348 tooltip, int parentWidth) {
        this(x, y, class_310.method_1551().field_1772.method_1728(tooltip, Math.max(parentWidth * 2 / 3, 200)));
    }

    public Tooltip(int x, int y, List<class_5481> tooltip) {
        this.x = x;
        this.y = y;
        this.tooltip = tooltip;
    }

    public static Tooltip create(int x, int y, String tooltip, int parentWidth) {
        return new Tooltip(x, y, tooltip, parentWidth);
    }

    public static Tooltip create(int x, int y, class_5348 tooltip, int parentWidth) {
        return new Tooltip(x, y, tooltip, parentWidth);
    }

    public static Tooltip create(int x, int y, List<class_5481> tooltip) {
        return new Tooltip(x, y, tooltip);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public boolean shouldRender() {
        return !this.tooltip.isEmpty();
    }

    public void render(class_332 drawContext) {
        drawContext.method_51436(class_310.method_1551().field_1772, this.tooltip, class_8001.field_41687, this.x, this.y);
    }

    public void queue() {
        TOOLTIPS.add(this);
    }

    public static <T extends Tooltipable & SpruceWidget> void queueFor(T widget, int mouseX, int mouseY, int tooltipTicks, IntConsumer tooltipTicksSetter, long lastTick, LongConsumer lastTickSetter) {
        if (((SpruceWidget)widget).isVisible()) {
            widget.getTooltip().ifPresent(tooltip -> {
                long currentRender = System.currentTimeMillis();
                if (lastTick != 0L) {
                    if (currentRender - lastTick >= 20L) {
                        tooltipTicksSetter.accept(tooltipTicks + 1);
                        lastTickSetter.accept(currentRender);
                    }
                } else {
                    lastTickSetter.accept(currentRender);
                }
                if (!((SpruceWidget)((Object)widget)).method_25370() && !((SpruceWidget)((Object)widget)).isMouseHovered()) {
                    tooltipTicksSetter.accept(0);
                }
                if (!tooltip.getString().isEmpty() && tooltipTicks >= 45) {
                    List wrappedTooltipText = class_310.method_1551().field_1772.method_1728((class_5348)tooltip, Math.max(((SpruceWidget)((Object)widget)).getWidth() * 2 / 3, 200));
                    if (((SpruceWidget)((Object)widget)).isMouseHovered()) {
                        Tooltip.create(mouseX, mouseY, wrappedTooltipText).queue();
                    } else if (((SpruceWidget)((Object)widget)).method_25370()) {
                        Tooltip.create(((SpruceWidget)((Object)widget)).getX() - 12, ((SpruceWidget)((Object)widget)).getY() + ((SpruceWidget)((Object)widget)).getHeight() + 16, wrappedTooltipText).queue();
                    }
                }
            });
        }
    }

    @ApiStatus.Internal
    static void setDelayedRender(boolean delayed) {
        Tooltip.delayed = delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderAll(class_332 drawContext) {
        if (delayed) {
            return;
        }
        Queue<Tooltip> queue = TOOLTIPS;
        synchronized (queue) {
            Tooltip tooltip;
            while ((tooltip = TOOLTIPS.poll()) != null) {
                tooltip.render(drawContext);
            }
        }
    }
}

