/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights.config;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.option.SpruceOption;
import org.thinkingstudio.ryoamiclights.shadow.nightconfig.core.Config;

public abstract class SettingEntry<T> {
    private final String key;
    private final SpruceOption option;
    @Nullable
    protected Config config;
    private T value;
    @Nullable
    protected Consumer<T> onSet;

    protected SettingEntry(String key, T defaultValue, @Nullable Config config, @Nullable class_2561 tooltip) {
        this.key = key;
        this.config = config;
        this.option = this.buildOption(tooltip);
        this.value = defaultValue;
    }

    protected SettingEntry(String key, T defaultValue, @Nullable Config config) {
        this(key, defaultValue, config, null);
    }

    public String key() {
        return this.key;
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
        if (this.onSet != null) {
            this.onSet.accept(value);
        }
        this.save();
    }

    protected abstract void deserialize(Object var1);

    protected abstract Object serialize();

    public void load(Config config) {
        this.config = config;
        this.deserialize(this.config.getOrElse(this.key(), this.serialize()));
    }

    public void save() {
        if (this.config != null) {
            this.config.set(this.key(), this.serialize());
        }
    }

    public SettingEntry<T> withOnSet(@Nullable Consumer<T> onSet) {
        this.onSet = onSet;
        return this;
    }

    public SpruceOption getOption() {
        return this.option;
    }

    protected String getOptionKey() {
        return "ryoamiclights.option." + this.key();
    }

    protected abstract SpruceOption buildOption(@Nullable class_2561 var1);
}

