/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry;

import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRendererRegistry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.util.TextRepresentable;
import me.shedaniel.rei.impl.Internals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_6862;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface EntryStack<T>
extends TextRepresentable,
Renderer {
    public static EntryStack<class_3902> empty() {
        return Internals.getEntryStackProvider().empty();
    }

    public static <T> EntryStack<T> of(EntryDefinition<T> definition, T value) {
        return Internals.getEntryStackProvider().of(definition, value);
    }

    public static <T> EntryStack<T> of(EntryType<T> type, T value) {
        return EntryStack.of(type.getDefinition(), value);
    }

    public static EntryStack<?> read(class_2487 tag) {
        class_2960 type = class_2960.method_60654((String)tag.method_10558("type"));
        EntryDefinition<?> definition = EntryTypeRegistry.getInstance().get(type);
        if (definition == null) {
            throw new NullPointerException("Read missing entry type: " + String.valueOf(type));
        }
        EntrySerializer<?> serializer = definition.getSerializer();
        if (serializer != null && serializer.supportReading()) {
            return EntryStack.of(definition, serializer.read(tag));
        }
        throw new UnsupportedOperationException(String.valueOf(definition.getType().getId()) + " does not support deserialization!");
    }

    @Nullable
    default public class_2487 saveStack() {
        return this.save();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    default public class_2487 save() {
        if (this.supportSaving()) {
            class_2487 tag = this.getDefinition().getSerializer().save(this, this.getValue());
            tag.method_10582("type", this.getType().getId().toString());
            return tag;
        }
        throw new UnsupportedOperationException(String.valueOf(this.getType().getId()) + " does not support serialization!");
    }

    default public boolean supportSaving() {
        EntrySerializer<T> serializer = this.getDefinition().getSerializer();
        return serializer != null && serializer.supportSaving();
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public Tooltip getTooltip(TooltipContext var1, boolean var2);

    @Override
    @Nullable
    default public Tooltip getTooltip(TooltipContext context) {
        return this.getTooltip(context, ConfigObject.getInstance().shouldAppendModNames());
    }

    public EntryDefinition<T> getDefinition();

    default public EntryType<T> getType() {
        return this.getDefinition().getType();
    }

    default public Class<T> getValueType() {
        return this.getDefinition().getValueType();
    }

    @Environment(value=EnvType.CLIENT)
    default public EntryRenderer<T> getRenderer() {
        EntryRenderer<?> renderer = this.get(Settings.RENDERER).apply(this);
        return renderer == null ? EntryRenderer.empty() : renderer.cast();
    }

    @Nullable
    public class_2960 getIdentifier();

    @Nullable
    public String getContainingNamespace();

    public boolean isEmpty();

    public EntryStack<T> copy();

    default public EntryStack<T> rewrap() {
        return this.copy();
    }

    public EntryStack<T> normalize();

    public EntryStack<T> wildcard();

    public Stream<class_6862<?>> getTagsFor();

    @Deprecated
    public int hashCode();

    @Deprecated
    public boolean equals(Object var1);

    public T getValue();

    default public <R> R castValue() {
        return (R)this.getValue();
    }

    public <R> EntryStack<T> setting(Settings<R> var1, R var2);

    public <R> EntryStack<T> removeSetting(Settings<R> var1);

    public EntryStack<T> clearSettings();

    public <R> R get(Settings<R> var1);

    @Nullable
    public <R> R getNullable(Settings<R> var1);

    @Environment(value=EnvType.CLIENT)
    default public EntryStack<T> tooltip(class_2561 ... tooltips) {
        return this.tooltip(Arrays.asList(tooltips));
    }

    @Environment(value=EnvType.CLIENT)
    default public EntryStack<T> tooltip(List<class_2561> tooltips) {
        return this.tooltip((EntryStack<?> stack) -> tooltips);
    }

    @Environment(value=EnvType.CLIENT)
    default public EntryStack<T> tooltip(Function<EntryStack<?>, List<class_2561>> tooltipProvider) {
        return this.setting(Settings.TOOLTIP_APPEND_EXTRA, tooltipProvider);
    }

    @Environment(value=EnvType.CLIENT)
    default public EntryStack<T> tooltipProcessor(BiFunction<EntryStack<T>, Tooltip, Tooltip> tooltipProcessor) {
        return this.setting(Settings.TOOLTIP_PROCESSOR, tooltipProcessor).cast();
    }

    @Environment(value=EnvType.CLIENT)
    default public EntryStack<T> withRenderer(EntryRenderer<? super T> renderer) {
        return this.setting(Settings.RENDERER, $ -> renderer).cast();
    }

    @Environment(value=EnvType.CLIENT)
    default public EntryStack<T> withRenderer(Function<EntryStack<T>, EntryRenderer<? super T>> renderer) {
        return this.setting(Settings.RENDERER, renderer).cast();
    }

    public EntryStack<class_1799> cheatsAs();

    @ApiStatus.NonExtendable
    default public <O> EntryStack<O> cast() {
        return this;
    }

    @Deprecated
    public static class Settings<R> {
        @ApiStatus.Internal
        private static final List<Settings<?>> SETTINGS = new ArrayList();
        @Environment(value=EnvType.CLIENT)
        public static Settings<Function<EntryStack<?>, EntryRenderer<?>>> RENDERER;
        @Environment(value=EnvType.CLIENT)
        public static Settings<BiFunction<EntryStack<?>, Tooltip, Tooltip>> TOOLTIP_PROCESSOR;
        @Environment(value=EnvType.CLIENT)
        public static Settings<BiFunction<EntryStack<?>, String, String>> CONTAINING_NS;
        @Environment(value=EnvType.CLIENT)
        public static Settings<Function<EntryStack<?>, List<class_2561>>> TOOLTIP_APPEND_EXTRA;
        @Deprecated
        @Environment(value=EnvType.CLIENT)
        @ApiStatus.Internal
        public static Settings<Boolean> FLUID_AMOUNT_VISIBLE;
        @Environment(value=EnvType.CLIENT)
        public static Settings<Float> FLUID_RENDER_RATIO;
        private final R defaultValue;
        private final short id;

        @ApiStatus.Internal
        public Settings(R defaultValue) {
            this.defaultValue = defaultValue;
            SETTINGS.add(this);
            this.id = (short)SETTINGS.indexOf(this);
        }

        @ApiStatus.Internal
        public static <R> Settings<R> getById(short id) {
            return SETTINGS.get(id);
        }

        public R getDefaultValue() {
            return this.defaultValue;
        }

        @ApiStatus.Internal
        public short getId() {
            return this.id;
        }

        static {
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
                RENDERER = new Settings<Function<EntryStack, EntryRenderer>>(stack -> EntryRendererRegistry.getInstance().get(stack));
                TOOLTIP_PROCESSOR = new Settings<BiFunction<EntryStack, Tooltip, Tooltip>>((stack, tooltip) -> tooltip);
                CONTAINING_NS = new Settings<BiFunction<EntryStack, String, String>>((stack, ns) -> ns);
                TOOLTIP_APPEND_EXTRA = new Settings<Function<EntryStack, List>>(stack -> Collections.emptyList());
                FLUID_RENDER_RATIO = new Settings<Float>(Float.valueOf(1.0f));
                FLUID_AMOUNT_VISIBLE = new Settings<Boolean>(true);
            });
        }
    }
}

