/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pathways;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.mixin.GameRendererAccessor;
import net.irisshaders.iris.pipeline.WorldRenderingPhase;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.class_10209;
import net.minecraft.class_10366;
import net.minecraft.class_11286;
import net.minecraft.class_11515;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1934;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_4696;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class HandRenderer {
    public static final HandRenderer INSTANCE = new HandRenderer();
    public static final float DEPTH = 0.125f;
    private final class_4599 bufferSource = new class_4599(Runtime.getRuntime().availableProcessors());
    private final class_11286 cachedProjectionMatrixBuffer = new class_11286("hand (Iris)");
    private boolean ACTIVE;
    private boolean renderingSolid;
    private class_11661 submitNodeCollector = new class_11661();
    private class_11684 featureRenderDispatcher;

    public HandRenderer() {
        this.featureRenderDispatcher = new class_11684(this.submitNodeCollector, class_310.method_1551().method_1541(), this.bufferSource.method_23000(), class_310.method_1551().method_72703(), this.bufferSource.method_23003(), this.bufferSource.method_23001(), class_310.method_1551().field_1772);
    }

    private class_4587 setupGlState(class_757 gameRenderer, class_4184 camera, Matrix4fc modelMatrix, float tickDelta) {
        class_4587 poseStack = new class_4587();
        Matrix4f scaleMatrix = new Matrix4f().scale(1.0f, 1.0f, 0.125f);
        scaleMatrix.mul((Matrix4fc)gameRenderer.method_22973(((GameRendererAccessor)gameRenderer).invokeGetFov(camera, tickDelta, false)));
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.cachedProjectionMatrixBuffer.method_71123(scaleMatrix), (class_10366)class_10366.field_54953);
        poseStack.method_34426();
        ((GameRendererAccessor)gameRenderer).invokeBobHurt(poseStack, tickDelta);
        if (((Boolean)class_310.method_1551().field_1690.method_42448().method_41753()).booleanValue()) {
            ((GameRendererAccessor)gameRenderer).invokeBobView(poseStack, tickDelta);
        }
        return poseStack;
    }

    private boolean canRender(class_4184 camera, class_757 gameRenderer) {
        return !camera.method_19333() && camera.method_19331() instanceof class_1657 && !((GameRendererAccessor)gameRenderer).getPanoramicMode() && !class_310.method_1551().field_1690.field_1842 && (!(camera.method_19331() instanceof class_1309) || !((class_1309)camera.method_19331()).method_6113()) && class_310.method_1551().field_1761.method_2920() != class_1934.field_9219;
    }

    public boolean isHandTranslucent(class_1268 hand) {
        class_1792 item = class_310.method_1551().field_1724.method_6118(hand == class_1268.field_5810 ? class_1304.field_6171 : class_1304.field_6173).method_7909();
        if (item instanceof class_1747) {
            return class_4696.method_23679((class_2680)((class_1747)item).method_7711().method_9564()) == class_11515.field_60926;
        }
        return false;
    }

    public boolean isAnyHandTranslucent() {
        return this.isHandTranslucent(class_1268.field_5808) || this.isHandTranslucent(class_1268.field_5810);
    }

    public void renderSolid(Matrix4fc modelMatrix, float tickDelta, class_4184 camera, class_757 gameRenderer, WorldRenderingPipeline pipeline) {
        if (!this.canRender(camera, gameRenderer) || !Iris.isPackInUseQuick()) {
            return;
        }
        RenderSystem.backupProjectionMatrix();
        this.ACTIVE = true;
        class_4587 poseStack = this.setupGlState(gameRenderer, camera, modelMatrix, tickDelta);
        pipeline.setPhase(WorldRenderingPhase.HAND_SOLID);
        poseStack.method_22903();
        class_10209.method_64146().method_15396("iris_hand");
        this.renderingSolid = true;
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().set((Matrix4fc)poseStack.method_23760().method_23761());
        gameRenderer.field_4012.method_22976(tickDelta, new class_4587(), (class_11659)this.submitNodeCollector, class_310.method_1551().field_1724, class_310.method_1551().method_1561().method_23839(camera.method_19331(), tickDelta));
        class_10209.method_64146().method_15407();
        this.featureRenderDispatcher.method_73002();
        this.bufferSource.method_23000().method_22993();
        RenderSystem.restoreProjectionMatrix();
        poseStack.method_22909();
        RenderSystem.getModelViewStack().popMatrix();
        this.renderingSolid = false;
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public void renderTranslucent(Matrix4fc modelMatrix, float tickDelta, class_4184 camera, class_757 gameRenderer, WorldRenderingPipeline pipeline) {
        if (!(this.canRender(camera, gameRenderer) && this.isAnyHandTranslucent() && Iris.isPackInUseQuick())) {
            return;
        }
        RenderSystem.backupProjectionMatrix();
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_TRANSLUCENT);
        class_4587 poseStack = this.setupGlState(gameRenderer, camera, modelMatrix, tickDelta);
        poseStack.method_22903();
        class_10209.method_64146().method_15396("iris_hand_translucent");
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().set((Matrix4fc)poseStack.method_23760().method_23761());
        gameRenderer.field_4012.method_22976(tickDelta, new class_4587(), (class_11659)this.submitNodeCollector, class_310.method_1551().field_1724, class_310.method_1551().method_1561().method_23839(camera.method_19331(), tickDelta));
        poseStack.method_22909();
        class_10209.method_64146().method_15407();
        this.featureRenderDispatcher.method_73002();
        this.bufferSource.method_23000().method_22993();
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.getModelViewStack().popMatrix();
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public boolean isActive() {
        return this.ACTIVE;
    }

    public boolean isRenderingSolid() {
        return this.renderingSolid;
    }

    public void destroy() {
    }
}

