/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultFuelDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DefaultFuelCategory
implements DisplayCategory<DefaultFuelDisplay> {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    @Override
    public CategoryIdentifier<? extends DefaultFuelDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.FUEL;
    }

    @Override
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"category.rei.fuel");
    }

    @Override
    public int getDisplayHeight() {
        return 49;
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((class_1935)class_1802.field_8713);
    }

    @Override
    public List<Widget> setupDisplay(DefaultFuelDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 17);
        String burnItems = DECIMAL_FORMAT.format((double)display.getFuelTime() / 200.0);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createLabel(new Point(bounds.x + 26, bounds.getMaxY() - 15), (class_2561)class_2561.method_43469((String)"category.rei.fuel.time.items", (Object[])new Object[]{burnItems})).color(-12566464, -4473925).noShadow().leftAligned());
        widgets.add(Widgets.createBurningFire(new Point(bounds.x + 6, startPoint.y + 1)).animationDurationTicks(display.getFuelTime()));
        widgets.add(Widgets.createSlot(new Point(bounds.x + 6, startPoint.y + 18)).entries(display.getInputEntries().get(0)).markInput());
        return widgets;
    }

    @Override
    public DisplayRenderer getDisplayRenderer(DefaultFuelDisplay display) {
        final Slot slot = Widgets.createSlot(new Point(0, 0)).entries(display.getInputEntries().get(0)).disableBackground().disableHighlight();
        final String burnItems = DECIMAL_FORMAT.format((double)display.getFuelTime() / 200.0);
        return new DisplayRenderer(this){
            private class_2561 text;
            {
                this.text = class_2561.method_43469((String)"category.rei.fuel.time_short.items", (Object[])new Object[]{burnItems});
            }

            @Override
            public int getHeight() {
                return 22;
            }

            @Override
            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                if (slot.containsMouse(context.getPoint())) {
                    return slot.getCurrentTooltip(context);
                }
                return null;
            }

            @Override
            public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                slot.getBounds().setLocation(bounds.x + 4, bounds.y + 2);
                slot.method_25394(graphics, mouseX, mouseY, delta);
                graphics.method_35720(class_310.method_1551().field_1772, this.text.method_30937(), bounds.x + 25, bounds.y + 8, -1);
            }
        };
    }
}

