/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiDialogBase;
import fi.dy.masa.malilib.gui.button.ConfigButtonBoolean;
import fi.dy.masa.malilib.gui.button.ConfigButtonOptionList;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.widgets.WidgetHoverInfo;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_11908;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class GuiKeybindSettings
extends GuiDialogBase {
    protected final IKeybind keybind;
    protected final String keybindName;
    protected final ConfigOptionList cfgActivateOn = new ConfigOptionList("malilib.gui.label.keybind_settings.activate_on", KeyAction.PRESS, "malilib.config.comment.keybind_settings.activate_on");
    protected final ConfigOptionList cfgContext = new ConfigOptionList("malilib.gui.label.keybind_settings.context", KeybindSettings.Context.INGAME, "malilib.config.comment.keybind_settings.context");
    protected final ConfigBoolean cfgAllowEmpty = new ConfigBoolean("malilib.gui.label.keybind_settings.allow_empty_keybind", false, "malilib.config.comment.keybind_settings.allow_empty_keybind");
    protected final ConfigBoolean cfgAllowExtra = new ConfigBoolean("malilib.gui.label.keybind_settings.allow_extra_keys", false, "malilib.config.comment.keybind_settings.allow_extra_keys");
    protected final ConfigBoolean cfgOrderSensitive = new ConfigBoolean("malilib.gui.label.keybind_settings.order_sensitive", false, "malilib.config.comment.keybind_settings.order_sensitive");
    protected final ConfigBoolean cfgExclusive = new ConfigBoolean("malilib.gui.label.keybind_settings.exclusive", false, "malilib.config.comment.keybind_settings.exclusive");
    protected final ConfigBoolean cfgCancel = new ConfigBoolean("malilib.gui.label.keybind_settings.cancel_further", false, "malilib.config.comment.keybind_settings.cancel_further");
    protected final List<ConfigBase<?>> configList;
    @Nullable
    protected final IDialogHandler dialogHandler;
    protected int labelWidth;
    protected int configWidth;

    public GuiKeybindSettings(IKeybind keybind, String name, @Nullable IDialogHandler dialogHandler, class_437 parent) {
        this.keybind = keybind;
        this.keybindName = name;
        this.dialogHandler = dialogHandler;
        if (this.dialogHandler == null) {
            this.setParent(parent);
        }
        this.title = GuiBase.TXT_BOLD + StringUtils.translate("malilib.gui.title.keybind_settings.advanced", this.keybindName) + GuiBase.TXT_RST;
        KeybindSettings settings = this.keybind.getSettings();
        this.cfgActivateOn.setOptionListValue(settings.getActivateOn());
        this.cfgContext.setOptionListValue(settings.getContext());
        this.cfgAllowEmpty.setBooleanValue(settings.getAllowEmpty());
        this.cfgAllowExtra.setBooleanValue(settings.getAllowExtraKeys());
        this.cfgOrderSensitive.setBooleanValue(settings.isOrderSensitive());
        this.cfgExclusive.setBooleanValue(settings.isExclusive());
        this.cfgCancel.setBooleanValue(settings.shouldCancel());
        this.configList = ImmutableList.of((Object)this.cfgActivateOn, (Object)this.cfgContext, (Object)this.cfgAllowEmpty, (Object)this.cfgAllowExtra, (Object)this.cfgOrderSensitive, (Object)this.cfgExclusive, (Object)this.cfgCancel);
        this.labelWidth = this.getMaxPrettyNameLength(this.configList);
        this.configWidth = 100;
        int totalWidth = this.labelWidth + this.configWidth + 30;
        totalWidth = Math.max(totalWidth, this.getStringWidth(this.title) + 20);
        this.setWidthAndHeight(totalWidth, this.configList.size() * 22 + 30);
        this.centerOnScreen();
        this.method_25423(this.mc, this.dialogWidth, this.dialogHeight);
    }

    @Override
    public void initGui() {
        this.clearElements();
        int x = this.dialogLeft + 10;
        int y = this.dialogTop + 24;
        for (ConfigBase<?> config : this.configList) {
            this.addConfig(x, y, this.labelWidth, this.configWidth, config);
            y += 22;
        }
    }

    protected void addConfig(int x, int y, int labelWidth, int configWidth, ConfigBase<?> config) {
        this.addLabel(x, y + 4, labelWidth, 10, -1, StringUtils.translate(config.getConfigGuiDisplayName(), new Object[0]));
        this.addWidget(new WidgetHoverInfo(x, y + 2, labelWidth, 12, config.getComment(), new Object[0]));
        x += labelWidth + 10;
        if (config instanceof ConfigBoolean) {
            this.addWidget(new ConfigButtonBoolean(x, y, configWidth, 20, (ConfigBoolean)config));
        } else if (config instanceof ConfigOptionList) {
            this.addWidget(new ConfigButtonOptionList(x, y, configWidth, 20, (ConfigOptionList)config));
        }
    }

    public void method_25432() {
        KeyAction activateOn = (KeyAction)this.cfgActivateOn.getOptionListValue();
        KeybindSettings.Context context = (KeybindSettings.Context)this.cfgContext.getOptionListValue();
        boolean allowEmpty = this.cfgAllowEmpty.getBooleanValue();
        boolean allowExtraKeys = this.cfgAllowExtra.getBooleanValue();
        boolean orderSensitive = this.cfgOrderSensitive.getBooleanValue();
        boolean exclusive = this.cfgExclusive.getBooleanValue();
        boolean cancel = this.cfgCancel.getBooleanValue();
        KeybindSettings settingsNew = KeybindSettings.create(context, activateOn, allowExtraKeys, orderSensitive, exclusive, cancel, allowEmpty);
        this.keybind.setSettings(settingsNew);
        super.method_25432();
    }

    @Override
    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().method_25394(drawContext, mouseX, mouseY, partialTicks);
        }
        super.method_25394(drawContext, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void drawScreenBackground(class_332 drawContext, int mouseX, int mouseY) {
        RenderUtils.drawOutlinedBox(drawContext, this.dialogLeft, this.dialogTop, this.dialogWidth, this.dialogHeight, -16777216, -6710887);
    }

    @Override
    protected void drawTitle(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        this.drawStringWithShadow(drawContext, this.title, this.dialogLeft + 10, this.dialogTop + 6, -1);
    }

    @Override
    public boolean method_25404(class_11908 input) {
        return this.onKeyTyped(input);
    }

    @Override
    public boolean onKeyTyped(class_11908 input) {
        if (input.comp_4795() == 256 && this.dialogHandler != null) {
            this.dialogHandler.closeDialog();
            return true;
        }
        return super.onKeyTyped(input);
    }
}

