/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation;

import java.util.Map;

public abstract class Estimator<TCategory, TPoint extends DataPoint<TCategory>, TBatch extends DataBatch<TPoint>, TInput, TOutput, TModel extends Model<TInput, TOutput, TBatch>> {
    protected final Map<TCategory, TModel> models = this.createMap();
    protected final Map<TCategory, TBatch> batches = this.createMap();

    protected abstract TBatch createNewDataBatch();

    protected abstract TModel createNewModel();

    protected abstract <T> Map<TCategory, T> createMap();

    public void addData(TPoint data) {
        Object category = data.category();
        DataBatch<Object> batch = (DataBatch)this.batches.get(category);
        if (batch == null) {
            batch = this.createNewDataBatch();
            this.batches.put(category, batch);
        }
        batch.addDataPoint(data);
    }

    private TModel ensureModel(TCategory category) {
        Model model = (Model)this.models.get(category);
        if (model == null) {
            model = this.createNewModel();
            this.models.put(category, model);
        }
        return (TModel)model;
    }

    public void updateModels() {
        this.batches.forEach((category, aggregator) -> {
            this.ensureModel(category).update((DataBatch)aggregator);
            aggregator.reset();
        });
    }

    public TOutput predict(TCategory category, TInput input) {
        return (TOutput)this.ensureModel(category).predict(input);
    }

    public String toString(TCategory category) {
        Model model = (Model)this.models.get(category);
        if (model == null) {
            return "-";
        }
        return model.toString();
    }

    protected static interface DataPoint<TPointCategory> {
        public TPointCategory category();
    }

    protected static interface DataBatch<TBatchPoint> {
        public void addDataPoint(TBatchPoint var1);

        public void reset();
    }

    protected static interface Model<TModelInput, TModelOutput, TModelBatch> {
        public void update(TModelBatch var1);

        public TModelOutput predict(TModelInput var1);
    }
}

