/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.data.MobCapDataHandler;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1311;
import net.minecraft.class_3542;

public class MobCapData {
    protected static final int CAP_COUNT = MobCapDataHandler.ENTITY_CATEGORIES.length;
    protected static final int MAX_DATA_AGE_TICKS = 100;
    public static final Codec<MobCapData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("cap_count").forGetter(get -> CAP_COUNT), (App)Codec.list(Cap.CODEC).fieldOf("cap_data").forGetter(get -> get.toList(get.data))).apply((Applicative)inst, MobCapData::new));
    protected final Cap[] data;
    protected final Cap[] stagingData;
    protected final boolean[] dataValid;
    protected final long[] worldTicks;
    protected boolean hasValidData;
    protected long completionWorldTick;

    public MobCapData() {
        this.data = MobCapData.createCapArray();
        this.stagingData = MobCapData.createCapArray();
        this.dataValid = new boolean[CAP_COUNT];
        this.worldTicks = new long[CAP_COUNT];
    }

    private MobCapData(int capCount, List<Cap> capData) {
        this.data = this.createCapArrayFromList(capCount, capData);
        this.stagingData = this.createCapArray(capCount);
        this.dataValid = new boolean[capCount];
        this.worldTicks = new long[capCount];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = capData.get(i);
        }
    }

    public static Cap[] createCapArray() {
        Cap[] data = new Cap[CAP_COUNT];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new Cap();
        }
        return data;
    }

    private Cap[] createCapArrayFromList(int size, List<Cap> list) {
        Cap[] data = new Cap[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = list.get(i);
        }
        return data;
    }

    private Cap[] createCapArray(int size) {
        Cap[] data = new Cap[size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new Cap();
        }
        return data;
    }

    private List<Cap> toList(Cap[] caps) {
        return Arrays.stream(caps).toList();
    }

    public boolean getHasValidData() {
        return this.hasValidData;
    }

    public boolean getHasRecentValidData(long worldTick) {
        return this.hasValidData && worldTick - this.completionWorldTick <= 100L;
    }

    public void clear() {
        this.clearStaging();
        this.hasValidData = false;
        this.completionWorldTick = -1L;
    }

    public Cap getCap(EntityCategory type) {
        return this.data[type.ordinal()];
    }

    public void setCurrentValue(EntityCategory type, int currentValue, long worldTick) {
        int index = type.ordinal();
        Cap cap = this.stagingData[index];
        cap.setCurrent(currentValue);
        this.checkCapComplete(index, cap, worldTick);
    }

    public void setCapValue(EntityCategory type, int capValue, long worldTick) {
        int index = type.ordinal();
        Cap cap = this.stagingData[index];
        cap.setCap(capValue);
        this.checkCapComplete(index, cap, worldTick);
    }

    public void setFromServuxMobCapData(MobCapData otherData, long worldTick) {
        int size = otherData.data.length;
        if (size != this.data.length) {
            MiniHUD.LOGGER.error("setFromServuxMobCapData: Mismatching Entity Categories!");
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.stagingData[i] = otherData.data[i];
            this.dataValid[i] = true;
            this.worldTicks[i] = worldTick;
        }
        this.checkStagingComplete(worldTick);
    }

    public void setCurrentAndCapValues(EntityCategory type, int currentValue, int capValue, long worldTick) {
        int index = type.ordinal();
        this.stagingData[index].setCurrentAndCap(currentValue, capValue);
        this.dataValid[index] = true;
        this.worldTicks[index] = worldTick;
        this.checkStagingComplete(worldTick);
    }

    protected void clearStaging() {
        for (Cap data : this.stagingData) {
            data.setCurrentAndCap(-1, -1);
        }
        Arrays.fill(this.dataValid, false);
        Arrays.fill(this.worldTicks, -1L);
    }

    protected void checkCapComplete(int index, Cap cap, long worldTick) {
        if (cap.getCurrent() >= 0 && cap.getCap() >= 0) {
            this.dataValid[index] = true;
            this.worldTicks[index] = worldTick;
            this.checkStagingComplete(worldTick);
        }
    }

    protected void checkStagingComplete(long worldTick) {
        for (boolean b : this.dataValid) {
            if (b) continue;
            return;
        }
        long min = MobCapData.getMinValue(this.worldTicks);
        long max = MobCapData.getMaxValue(this.worldTicks);
        if (max - min <= 60L) {
            for (int i = 0; i < this.stagingData.length; ++i) {
                this.data[i].setFrom(this.stagingData[i]);
            }
            this.clearStaging();
        }
        this.hasValidData = true;
        this.completionWorldTick = worldTick;
    }

    public static long getMinValue(long[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        long minValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] >= minValue) continue;
            minValue = arr[i];
        }
        return minValue;
    }

    public static long getMaxValue(long[] arr) {
        if (arr.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        int size = arr.length;
        long maxValue = arr[0];
        for (int i = 1; i < size; ++i) {
            if (arr[i] <= maxValue) continue;
            maxValue = arr[i];
        }
        return maxValue;
    }

    public static class Cap {
        public static Codec<Cap> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.INT.fieldOf("current").forGetter(Cap::getCurrent), (App)PrimitiveCodec.INT.fieldOf("cap").forGetter(Cap::getCap)).apply((Applicative)inst, Cap::new));
        protected int current;
        protected int cap;

        public Cap() {
        }

        private Cap(int current, int cap) {
            this.current = current;
            this.cap = cap;
        }

        public int getCurrent() {
            return this.current;
        }

        public int getCap() {
            return this.cap;
        }

        public boolean isFull() {
            return this.current >= this.cap && this.cap >= 0;
        }

        public void setCurrent(int current) {
            this.current = current;
        }

        public void setCap(int cap) {
            this.cap = cap;
        }

        public void setCurrentAndCap(int current, int cap) {
            this.current = current;
            this.cap = cap;
        }

        public void setFrom(Cap other) {
            this.current = other.current;
            this.cap = other.cap;
        }
    }

    public static enum EntityCategory implements class_3542
    {
        MONSTER("monster", class_1311.field_6302),
        CREATURE("creature", class_1311.field_6294),
        AMBIENT("ambient", class_1311.field_6303),
        AXOLOTLS("axolotls", class_1311.field_34447),
        UNDERGROUND_WATER_CREATURE("underground_water_creature", class_1311.field_30092),
        WATER_CREATURE("water_creature", class_1311.field_6300),
        WATER_AMBIENT("water_ambient", class_1311.field_24460),
        MISC("misc", class_1311.field_17715);

        public static final class_3542.class_7292<EntityCategory> CODEC;
        public static final ImmutableList<EntityCategory> VALUES;
        private final class_1311 vanillaCategory;
        private final String name;

        private EntityCategory(String name, class_1311 vanillaCategory) {
            this.name = name;
            this.vanillaCategory = vanillaCategory;
        }

        public String getName() {
            return this.name;
        }

        @Nonnull
        public String method_15434() {
            return this.name;
        }

        public class_1311 getVanillaCategory() {
            return this.vanillaCategory;
        }

        public static EntityCategory fromVanillaCategory(class_1311 type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case class_1311.field_6302 -> MONSTER;
                case class_1311.field_6294 -> CREATURE;
                case class_1311.field_6303 -> AMBIENT;
                case class_1311.field_34447 -> AXOLOTLS;
                case class_1311.field_30092 -> UNDERGROUND_WATER_CREATURE;
                case class_1311.field_6300 -> WATER_CREATURE;
                case class_1311.field_24460 -> WATER_AMBIENT;
                case class_1311.field_17715 -> MISC;
            };
        }

        @Nullable
        public static EntityCategory fromVanillaCategoryName(String name) {
            return switch (name) {
                case "monster" -> MONSTER;
                case "creature" -> CREATURE;
                case "ambient" -> AMBIENT;
                case "axolotls" -> AXOLOTLS;
                case "underground_water_creature" -> UNDERGROUND_WATER_CREATURE;
                case "water_creature" -> WATER_CREATURE;
                case "water_ambient" -> WATER_AMBIENT;
                case "misc" -> MISC;
                default -> null;
            };
        }

        static {
            CODEC = class_3542.method_28140(EntityCategory::values);
            VALUES = ImmutableList.copyOf((Object[])EntityCategory.values());
        }
    }
}

