/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.mixin.entity.IMixinMerchantEntity;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.mixin.entity.IMixinZombieVillagerEntity;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.util.EntityUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRendererVillagerInfo
extends OverlayRendererBase
implements IClientTickHandler {
    public static final OverlayRendererVillagerInfo INSTANCE = new OverlayRendererVillagerInfo();
    private final ConcurrentHashMap<Integer, Pair<Long, Pair<class_1297, class_2487>>> recentEntityData = new ConcurrentHashMap();
    private long lastTick = System.currentTimeMillis();

    protected OverlayRendererVillagerInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(boolean isLogout) {
        if (!isLogout) {
            MiniHUD.debugLog("OverlayRendererVillagerInfo#reset() - dimension change or log-in", new Object[0]);
            long now = System.currentTimeMillis();
            this.lastTick = -(this.getCacheTimeout() + 5000L);
            this.tickCache(now);
            this.lastTick = now;
        } else {
            MiniHUD.debugLog("OverlayRendererVillagerInfo#reset() - log-out", new Object[0]);
        }
        ConcurrentHashMap<Integer, Pair<Long, Pair<class_1297, class_2487>>> concurrentHashMap = this.recentEntityData;
        synchronized (concurrentHashMap) {
            this.recentEntityData.clear();
        }
    }

    public void onClientTick(class_310 mc) {
        long now = System.currentTimeMillis();
        if (now - this.lastTick > 50L) {
            this.lastTick = now;
            if (RendererToggle.OVERLAY_VILLAGER_INFO.getBooleanValue()) {
                this.tickCache(now);
            } else if (!this.recentEntityData.isEmpty()) {
                this.recentEntityData.clear();
            }
        }
    }

    private long getCacheTimeout() {
        return EntitiesDataManager.getInstance().getCacheTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickCache(long now) {
        long timeout = this.getCacheTimeout();
        ConcurrentHashMap<Integer, Pair<Long, Pair<class_1297, class_2487>>> concurrentHashMap = this.recentEntityData;
        synchronized (concurrentHashMap) {
            this.recentEntityData.forEach((integer, longPair) -> {
                if (now - (Long)longPair.getLeft() > timeout || (Long)longPair.getLeft() > now) {
                    this.recentEntityData.remove(integer);
                }
            });
        }
    }

    private boolean isNbtValid(class_2487 nbt) {
        if (nbt.method_10545("Offers")) {
            return true;
        }
        return nbt.method_10545("ConversionTime") && nbt.method_68083("ConversionTime", -1) > 0 || nbt.method_10545("ConversionPlayer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Pair<class_1297, class_2487> getVillagerData(class_1937 world, int entityId) {
        Pair<class_1297, class_2487> pair = EntitiesDataManager.getInstance().requestEntity(world, entityId);
        if (pair != null && pair.getRight() != null && !((class_2487)pair.getRight()).method_33133() && this.isNbtValid((class_2487)pair.getRight())) {
            long now = System.currentTimeMillis();
            ConcurrentHashMap<Integer, Pair<Long, Pair<class_1297, class_2487>>> concurrentHashMap = this.recentEntityData;
            synchronized (concurrentHashMap) {
                this.recentEntityData.put(entityId, (Pair<Long, Pair<class_1297, class_2487>>)Pair.of((Object)now, pair));
            }
            return pair;
        }
        if (this.recentEntityData.containsKey(entityId)) {
            return (Pair)this.recentEntityData.get(entityId).getRight();
        }
        return null;
    }

    @Nullable
    private class_1916 getTrades(class_1937 world, class_1646 villager) {
        if (world == null || villager == null) {
            return null;
        }
        Pair<class_1297, class_2487> pair = this.getVillagerData(world, villager.method_5628());
        class_1916 list = null;
        if (pair != null) {
            Object object;
            if (pair.getRight() != null && !((class_2487)pair.getRight()).method_33133()) {
                list = NbtEntityUtils.getTradeOffersFromNbt((class_2487)((class_2487)pair.getRight()), (class_5455)world.method_30349());
            } else if (pair.getLeft() != null && (object = pair.getLeft()) instanceof class_1646) {
                class_1646 entity = (class_1646)object;
                list = ((IMixinMerchantEntity)entity).malilib_offers();
            }
        }
        return list;
    }

    private int getConversionTime(class_1937 world, class_1641 villager) {
        if (world == null || villager == null) {
            return -1;
        }
        Pair<class_1297, class_2487> pair = this.getVillagerData(world, villager.method_5628());
        int conversionTime = -1;
        if (pair != null) {
            Object object;
            if (pair.getRight() != null && !((class_2487)pair.getRight()).method_33133()) {
                Pair zombiePair = NbtEntityUtils.getZombieConversionTimerFromNbt((class_2487)((class_2487)pair.getRight()));
                if (zombiePair != null && (Integer)zombiePair.getLeft() > -1) {
                    conversionTime = (Integer)zombiePair.getLeft();
                }
            } else if (pair.getLeft() != null && (object = pair.getLeft()) instanceof class_1641) {
                class_1641 zombert = (class_1641)object;
                conversionTime = ((IMixinZombieVillagerEntity)zombert).minihud_conversionTimer();
            }
        }
        return conversionTime;
    }

    @Override
    public String getName() {
        return "VillagerInfo";
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_VILLAGER_INFO.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        return true;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        class_238 box = entity.method_5829().method_1009(30.0, 10.0, 30.0);
        class_1937 world = WorldUtils.getBestWorld((class_310)mc);
        if (world == null) {
            return;
        }
        if (Configs.Generic.VILLAGER_OFFER_ENCHANTMENT_BOOKS.getBooleanValue()) {
            class_1916 offers;
            List<class_1646> librarians = EntityUtils.getEntitiesByClass(mc, class_1646.class, box, villager -> villager.method_7231().comp_3521().method_40225(class_3852.field_17060));
            HashMap<Object2IntMap.Entry, Integer> lowestPrices = new HashMap<Object2IntMap.Entry, Integer>();
            if (Configs.Generic.VILLAGER_OFFER_LOWEST_PRICE_NEARBY.getBooleanValue()) {
                for (class_1646 librarian : librarians) {
                    offers = this.getTrades(world, librarian);
                    if (offers == null || offers.isEmpty()) continue;
                    for (class_1914 tradeOffer : offers) {
                        if (tradeOffer.method_8250().method_7909() != class_1802.field_8598 || tradeOffer.method_57556().comp_2424().comp_349() != class_1802.field_8687) continue;
                        for (Object2IntMap.Entry entry : ((class_9304)tradeOffer.method_8250().method_58695(class_9334.field_49643, (Object)class_9304.field_49385)).method_57539()) {
                            int emeraldCost = tradeOffer.method_57556().comp_2425();
                            if (lowestPrices.containsKey(entry)) {
                                if (emeraldCost >= (Integer)lowestPrices.get(entry)) continue;
                                lowestPrices.put(entry, emeraldCost);
                                continue;
                            }
                            lowestPrices.put(entry, emeraldCost);
                        }
                    }
                }
            }
            for (class_1646 librarian : librarians) {
                offers = this.getTrades(world, librarian);
                if (offers == null || offers.isEmpty()) continue;
                ArrayList<String> overlay = new ArrayList<String>();
                for (class_1914 tradeOffer : offers) {
                    if (tradeOffer.method_8250().method_7909() != class_1802.field_8598) continue;
                    for (Object2IntMap.Entry entry : ((class_9304)tradeOffer.method_8250().method_58695(class_9334.field_49643, (Object)class_9304.field_49385)).method_57539()) {
                        StringBuilder sb = new StringBuilder();
                        if (((class_1887)((class_6880)entry.getKey()).comp_349()).method_8183() == entry.getIntValue()) {
                            sb.append(GuiBase.TXT_GOLD);
                        } else if (Configs.Generic.VILLAGER_OFFER_HIGHEST_LEVEL_ONLY.getBooleanValue()) continue;
                        sb.append(class_1887.method_8179((class_6880)((class_6880)entry.getKey()), (int)entry.getIntValue()).getString());
                        sb.append(GuiBase.TXT_RST);
                        if (tradeOffer.method_57556().comp_2424().comp_349() == class_1802.field_8687) {
                            sb.append(" ");
                            int emeraldCost = tradeOffer.method_57556().comp_2425();
                            if (Configs.Generic.VILLAGER_OFFER_LOWEST_PRICE_NEARBY.getBooleanValue() && emeraldCost > lowestPrices.getOrDefault(entry, Integer.MAX_VALUE)) continue;
                            int lowest = 2 + 3 * entry.getIntValue();
                            int highest = 6 + 13 * entry.getIntValue();
                            if (((class_6880)entry.getKey()).method_40220(class_9636.field_51546)) {
                                lowest *= 2;
                                highest *= 2;
                            }
                            if ((double)emeraldCost > class_3532.method_16436((double)Configs.Generic.VILLAGER_OFFER_PRICE_THRESHOLD.getDoubleValue(), (double)lowest, (double)highest)) continue;
                            if ((double)emeraldCost < class_3532.method_16436((double)0.3333333333333333, (double)lowest, (double)highest)) {
                                sb.append(GuiBase.TXT_GREEN);
                            }
                            if ((double)emeraldCost > class_3532.method_16436((double)0.6666666666666666, (double)lowest, (double)highest)) {
                                sb.append(GuiBase.TXT_RED);
                            }
                            sb.append(emeraldCost);
                            if (Configs.Generic.VILLAGER_OFFER_PRICE_RANGE.getBooleanValue()) {
                                sb.append(' ').append('(').append(lowest).append('-').append(highest).append(')');
                            }
                            sb.append(GuiBase.TXT_RST);
                        }
                        overlay.add(sb.toString());
                    }
                }
                this.renderAtEntity(overlay, entity, (class_1297)librarian);
            }
        }
        if (Configs.Generic.VILLAGER_CONVERSION_TICKS.getBooleanValue()) {
            List<class_1641> zombieVillagers = EntityUtils.getEntitiesByClass(mc, class_1641.class, box, e -> true);
            for (class_1641 villager2 : zombieVillagers) {
                int conversionTimer = this.getConversionTime(world, villager2);
                if (conversionTimer <= 0) continue;
                this.renderAtEntity(List.of(String.format("%ds", Math.round((float)conversionTimer / 20.0f))), entity, (class_1297)villager2);
            }
        }
    }

    @Override
    public boolean hasData() {
        return false;
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
    }

    @Override
    public void reset() {
        super.reset();
    }

    private void renderAtEntity(List<String> texts, class_1297 entity, class_1297 targetEntity) {
        class_2338 pos;
        class_1309 living;
        Optional jobSite;
        float delta = class_310.method_1551().method_61966().method_60637(true);
        class_243 cameraPos = entity.method_30950(delta);
        class_243 targetPos = targetEntity.method_30950(delta);
        double hypot = class_3532.method_39241((double)(cameraPos.method_10216() - targetPos.method_10216()), (double)(cameraPos.method_10215() - targetPos.method_10215()));
        double distance = 0.8;
        double x = targetPos.method_10216() + (cameraPos.method_10216() - targetPos.method_10216()) / hypot * distance;
        double z = targetPos.method_10215() + (cameraPos.method_10215() - targetPos.method_10215()) / hypot * distance;
        double y = targetPos.method_10214() + 1.5 + 0.1 * (double)texts.size();
        if (targetEntity instanceof class_1309 && (jobSite = (living = (class_1309)targetEntity).method_18868().method_46873(class_4140.field_18439)) != null && jobSite.isPresent() && targetPos.method_1022((pos = ((class_4208)jobSite.get()).comp_2208()).method_46558()) < 1.7) {
            x = (double)pos.method_10263() + 0.5;
            z = (double)pos.method_10260() + 0.5;
        }
        for (String line : texts) {
            RenderUtils.drawTextPlate(List.of(line), (double)x, (double)y, (double)z, (float)0.02f);
            y -= 0.2;
        }
    }
}

