/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.impl.client.util.AbstractIndexedCyclingList;
import me.shedaniel.rei.impl.client.util.ConcatenatedListIterator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface CyclingList<T>
extends Supplier<List<T>> {
    default public T peek() {
        this.next();
        return this.previous();
    }

    default public boolean hasNext() {
        int nextIndex = this.nextIndex();
        return this.currentIndex() < nextIndex && nextIndex < this.size();
    }

    default public boolean hasPrevious() {
        int previousIndex = this.previousIndex();
        return previousIndex >= 0 && this.currentIndex() > previousIndex;
    }

    public T next();

    public T previous();

    public int nextIndex();

    public int previousIndex();

    public void resetToStart();

    public int size();

    public int currentIndex();

    public static <T> CyclingList<T> of(final List<T> list, final Supplier<T> empty) {
        return new AbstractIndexedCyclingList<T>(){

            @Override
            public List<T> get() {
                return list;
            }

            @Override
            protected T get(int index) {
                return list.get(index);
            }

            @Override
            protected T empty() {
                return empty.get();
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static <T> Mutable<T> ofMutable(final List<T> list, final Supplier<T> empty) {
        return new AbstractIndexedCyclingList.Mutable<T>(){

            @Override
            public List<T> get() {
                return list;
            }

            @Override
            protected T get(int index) {
                return list.get(index);
            }

            @Override
            protected T empty() {
                return empty.get();
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public void add(T entry) {
                list.add(entry);
            }

            @Override
            public void addAll(Collection<? extends T> entries) {
                list.addAll(entries);
            }

            @Override
            public void clear() {
                list.clear();
            }
        };
    }

    public static <T> CyclingList<T> of(final Supplier<T> empty) {
        return new CyclingList<T>(){

            @Override
            public List<T> get() {
                return List.of();
            }

            @Override
            public T peek() {
                return empty.get();
            }

            @Override
            public void resetToStart() {
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public int currentIndex() {
                return 0;
            }

            @Override
            public T next() {
                return empty.get();
            }

            @Override
            public T previous() {
                return empty.get();
            }

            @Override
            public int nextIndex() {
                return 1;
            }

            @Override
            public int previousIndex() {
                return -1;
            }
        };
    }

    public static <T> Mutable<T> ofMutable(final Supplier<T> empty) {
        return new Mutable<T>(){
            private List<T> list;
            private CyclingList<T> provider;

            @Override
            public List<T> get() {
                return this.list == null ? List.of() : this.list;
            }

            @Override
            public T peek() {
                if (this.provider == null) {
                    return empty.get();
                }
                return this.provider.peek();
            }

            @Override
            public T previous() {
                if (this.provider == null) {
                    return empty.get();
                }
                return this.provider.previous();
            }

            @Override
            public int nextIndex() {
                return this.provider == null ? 1 : this.provider.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.provider == null ? -1 : this.provider.previousIndex();
            }

            @Override
            public T next() {
                if (this.provider == null) {
                    return empty.get();
                }
                return this.provider.next();
            }

            @Override
            public void add(T entry) {
                if (this.list == null || this.list.isEmpty()) {
                    this.list = Collections.singletonList(entry);
                    this.provider = CyclingList.ofMutable(this.list, empty);
                } else {
                    if (!(this.list instanceof ArrayList)) {
                        this.list = new ArrayList(this.list);
                        this.provider = CyclingList.ofMutable(this.list, empty);
                    }
                    this.list.add(entry);
                }
            }

            @Override
            public void resetToStart() {
                if (this.provider != null) {
                    this.provider.resetToStart();
                }
            }

            @Override
            public int size() {
                return this.list == null ? 0 : this.list.size();
            }

            @Override
            public int currentIndex() {
                return this.provider == null ? 0 : this.provider.currentIndex();
            }

            @Override
            public void addAll(Collection<? extends T> entries) {
                if (this.list == null) {
                    this.list = new ArrayList(entries);
                    this.provider = CyclingList.ofMutable(this.list, empty);
                } else {
                    if (!(this.list instanceof ArrayList)) {
                        this.list = new ArrayList(this.list);
                        this.provider = CyclingList.ofMutable(this.list, empty);
                    }
                    this.list.addAll(entries);
                }
            }

            @Override
            public void clear() {
                this.list = null;
                this.provider = null;
            }
        };
    }

    public static <T> Mutable<T> ofMutable(final CyclingList<T> provider, final Supplier<T> empty) {
        return new Mutable<T>(){
            private final Mutable<T> mutable;
            private CyclingList<T> concat;
            {
                this.mutable = CyclingList.ofMutable(empty);
                this.concat = CyclingList.concat(List.of(provider, this.mutable), empty);
            }

            @Override
            public List<T> get() {
                return (List)this.concat.get();
            }

            @Override
            public T peek() {
                return this.concat.peek();
            }

            @Override
            public T previous() {
                return this.concat.previous();
            }

            @Override
            public int nextIndex() {
                return this.concat.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.concat.previousIndex();
            }

            @Override
            public T next() {
                return this.concat.next();
            }

            @Override
            public void add(T entry) {
                this.mutable.add(entry);
            }

            @Override
            public void resetToStart() {
                this.concat.resetToStart();
            }

            @Override
            public int size() {
                return this.concat.size();
            }

            @Override
            public int currentIndex() {
                return this.concat.currentIndex();
            }

            @Override
            public void addAll(Collection<? extends T> entries) {
                this.mutable.addAll(entries);
            }

            @Override
            public void clear() {
                this.concat = this.mutable;
                this.mutable.clear();
            }
        };
    }

    public static <T> CyclingList<T> concat(Collection<CyclingList<T>> providers, final Supplier<T> empty) {
        return providers.stream().reduce((a, b) -> new ConcatenatedListIterator<T>((CyclingList)a, (CyclingList)b){

            @Override
            protected T empty() {
                return empty.get();
            }
        }).orElse(CyclingList.of(empty));
    }

    @ApiStatus.Experimental
    public static interface Mutable<T>
    extends CyclingList<T> {
        public void add(T var1);

        public void addAll(Collection<? extends T> var1);

        public void clear();
    }
}

