/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;

public class MaLiLibConfigs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "malilib.json";
    private static final String GENERIC_KEY = "malilib.config";
    private static final String DEBUG_KEY = "malilib.config";

    public static void loadFromFile() {
        JsonElement element;
        File configFile = new File(FileUtils.getConfigDirectory(), CONFIG_FILE_NAME);
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile(configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase(root, "Generic", Generic.OPTIONS);
            ConfigUtils.readConfigBase(root, "Debug", Debug.OPTIONS);
        }
    }

    public static void saveToFile() {
        File dir = FileUtils.getConfigDirectory();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase(root, "Generic", Generic.OPTIONS);
            ConfigUtils.writeConfigBase(root, "Debug", Debug.OPTIONS);
            JsonUtils.writeJsonToFile(root, new File(dir, CONFIG_FILE_NAME));
        }
    }

    @Override
    public void onConfigsChanged() {
        MaLiLibConfigs.saveToFile();
        MaLiLibConfigs.loadFromFile();
    }

    @Override
    public void load() {
        MaLiLibConfigs.loadFromFile();
    }

    @Override
    public void save() {
        MaLiLibConfigs.saveToFile();
    }

    public static class Generic {
        public static final ConfigHotkey IGNORED_KEYS = (ConfigHotkey)new ConfigHotkey("ignoredKeys", "").apply("malilib.config");
        public static final ConfigHotkey OPEN_GUI_CONFIGS = (ConfigHotkey)new ConfigHotkey("openGuiConfigs", "A,C").apply("malilib.config");
        public static final ConfigBoolean REALMS_COMMON_CONFIG = (ConfigBoolean)new ConfigBoolean("realmsCommonConfig", true).apply("malilib.config");
        public static final ConfigBoolean ENABLE_ACTIONBAR_MESSAGES = (ConfigBoolean)new ConfigBoolean("enableActionbarMessages", true).apply("malilib.config");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)IGNORED_KEYS, (Object)OPEN_GUI_CONFIGS, (Object)REALMS_COMMON_CONFIG, (Object)ENABLE_ACTIONBAR_MESSAGES);
    }

    public static class Debug {
        public static final ConfigBoolean DEBUG_MESSAGES = (ConfigBoolean)new ConfigBoolean("debugMessages", false).apply("malilib.config");
        public static final ConfigBoolean INPUT_CANCELLATION_DEBUG = (ConfigBoolean)new ConfigBoolean("inputCancellationDebugging", false).apply("malilib.config");
        public static final ConfigBoolean KEYBIND_DEBUG = (ConfigBoolean)new ConfigBoolean("keybindDebugging", false).apply("malilib.config");
        public static final ConfigBoolean KEYBIND_DEBUG_ACTIONBAR = (ConfigBoolean)new ConfigBoolean("keybindDebuggingIngame", false).apply("malilib.config");
        public static final ConfigBoolean MOUSE_SCROLL_DEBUG = (ConfigBoolean)new ConfigBoolean("mouseScrollDebug", false).apply("malilib.config");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)DEBUG_MESSAGES, (Object)INPUT_CANCELLATION_DEBUG, (Object)KEYBIND_DEBUG, (Object)KEYBIND_DEBUG_ACTIONBAR, (Object)MOUSE_SCROLL_DEBUG);
    }
}

