/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.interfaces.IRenderDispatcher;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10209;
import net.minecraft.class_1799;
import net.minecraft.class_276;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_5944;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9925;
import net.minecraft.class_9958;
import net.minecraft.class_9960;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

public class RenderEventHandler
implements IRenderDispatcher {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final List<IRenderer> overlayRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> tooltipLastRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldPreWeatherRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldLastRenderers = new ArrayList<IRenderer>();

    public static IRenderDispatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerGameOverlayRenderer(IRenderer renderer) {
        if (!this.overlayRenderers.contains(renderer)) {
            this.overlayRenderers.add(renderer);
        }
    }

    @Override
    public void registerTooltipLastRenderer(IRenderer renderer) {
        if (!this.tooltipLastRenderers.contains(renderer)) {
            this.tooltipLastRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldPreWeatherRenderer(IRenderer renderer) {
        if (!this.worldPreWeatherRenderers.contains(renderer)) {
            this.worldPreWeatherRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldLastRenderer(IRenderer renderer) {
        if (!this.worldLastRenderers.contains(renderer)) {
            this.worldLastRenderers.add(renderer);
        }
    }

    @ApiStatus.Internal
    public void onRenderGameOverlayLastDrawer(class_332 drawContext, class_310 mc, float partialTicks) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("malilib_rendergameoverlaydrawer");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                profiler.method_15400(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayLastDrawer(drawContext, partialTicks, profiler, mc);
                profiler.method_15407();
            }
        }
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void onRenderGameOverlayPost(class_332 drawContext, class_310 mc, float partialTicks) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("malilib_rendergameoverlaypost");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                profiler.method_15400(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayPostAdvanced(drawContext, partialTicks, profiler, mc);
                renderer.onRenderGameOverlayPost(drawContext);
                profiler.method_15407();
            }
        }
        profiler.method_15396("malilib_ingamemessages");
        InfoUtils.renderInGameMessages(drawContext);
        profiler.method_15407();
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void onRenderTooltipLast(class_332 drawContext, class_1799 stack, int x, int y) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipLast(drawContext, stack, x, y);
            }
        }
    }

    @ApiStatus.Internal
    public void runRenderWorldPreWeather(Matrix4f posMatrix, Matrix4f projMatrix, class_310 mc, class_9909 frameGraphBuilder, class_9960 fbSet, class_4604 frustum, class_4184 camera, class_3695 profiler) {
        if (!this.worldPreWeatherRenderers.isEmpty()) {
            class_9916 renderPass = frameGraphBuilder.method_61911("malilib");
            profiler.method_15396("malilib_render_pre_weather");
            class_9925 handleMain = fbSet.field_53091 = renderPass.method_61933(fbSet.field_53091);
            renderPass.method_61929(() -> {
                class_9958 fog = RenderSystem.getShaderFog();
                class_5944 shaders = RenderSystem.getShader();
                if (shaders != null) {
                    shaders.method_60897(class_293.class_5596.field_27382, posMatrix, projMatrix, mc.method_22683());
                    shaders.method_34586();
                }
                ((class_276)handleMain.get()).method_1235(false);
                for (IRenderer renderer : this.worldPreWeatherRenderers) {
                    profiler.method_15400(renderer.getProfilerSectionSupplier());
                    renderer.onRenderWorldPreWeather(posMatrix, projMatrix, frustum, camera, fog, profiler);
                    profiler.method_15407();
                }
                if (shaders != null) {
                    shaders.method_34585();
                }
            });
        }
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void runRenderWorldLast(Matrix4f posMatrix, Matrix4f projMatrix, class_310 mc, class_9909 frameGraphBuilder, class_9960 fbSet, class_4604 frustum, class_4184 camera, class_3695 profiler) {
        if (!this.worldLastRenderers.isEmpty()) {
            class_9916 renderPass = frameGraphBuilder.method_61911("malilib");
            profiler.method_15396("malilib_render_post");
            class_9925 handleMain = fbSet.field_53091 = renderPass.method_61933(fbSet.field_53091);
            renderPass.method_61929(() -> {
                class_9958 fog = RenderSystem.getShaderFog();
                class_5944 shaders = RenderSystem.getShader();
                if (shaders != null) {
                    shaders.method_60897(class_293.class_5596.field_27382, posMatrix, projMatrix, mc.method_22683());
                    shaders.method_34586();
                }
                ((class_276)handleMain.get()).method_1235(false);
                for (IRenderer renderer : this.worldLastRenderers) {
                    profiler.method_15400(renderer.getProfilerSectionSupplier());
                    renderer.onRenderWorldLastAdvanced(posMatrix, projMatrix, frustum, camera, fog, profiler);
                    renderer.onRenderWorldLast(posMatrix, projMatrix);
                    profiler.method_15407();
                }
                if (shaders != null) {
                    shaders.method_34585();
                }
            });
        }
        profiler.method_15407();
    }
}

