/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.llamalad7.mixinextras.lib.apache.commons.tuple.Pair;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.NBTUtils;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1291;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3612;
import net.minecraft.class_4482;
import net.minecraft.class_5000;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8242;
import net.minecraft.class_8514;
import net.minecraft.class_8887;
import net.minecraft.class_9296;
import org.apache.http.annotation.Experimental;

public class BlockUtils {
    @Experimental
    public static Optional<class_2350> PRW_getFirstPropertyFacingValue(class_2680 state) {
        Optional<class_2754<class_2350>> propOptional = BlockUtils.PRW_getFirstDirectionProperty(state);
        return propOptional.map(directionProperty -> class_2350.method_10143((int)((class_2350)state.method_11654((class_2769)directionProperty)).method_10146()));
    }

    @Experimental
    public static Optional<class_2754<class_2350>> PRW_getFirstDirectionProperty(class_2680 state) {
        for (class_2769 prop : state.method_28501()) {
            class_2754 ep;
            if (!(prop instanceof class_2754) || !(ep = (class_2754)prop).method_11902().equals(class_2350.class)) continue;
            return Optional.of(ep);
        }
        return Optional.empty();
    }

    @Experimental
    public static boolean PRW_isFluidBlock(class_2680 state) {
        return !state.method_26227().equals(class_3612.field_15906.method_15785());
    }

    @Experimental
    public static boolean PRW_isFluidSourceBlock(class_2680 state) {
        return state.method_26204() instanceof class_2404 && state.method_26227().method_15761() == 8;
    }

    @Nullable
    public static class_2754<class_2350> getFirstDirectionProperty(class_2680 state) {
        for (class_2769 prop : state.method_28501()) {
            class_2754 enumProperty;
            if (!(prop instanceof class_2754) || !(enumProperty = (class_2754)prop).method_11902().equals(class_2350.class)) continue;
            return enumProperty;
        }
        return null;
    }

    @Nullable
    public static class_2350 getFirstPropertyFacingValue(class_2680 state) {
        return BlockUtils.getPropertyFacingValue(state);
    }

    @Nullable
    public static class_2350 getPropertyFacingValue(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12525) ? (class_2350)state.method_11654((class_2769)class_2741.field_12525) : null;
    }

    @Nullable
    public static class_2350 getPropertyHopperFacingValue(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12545) ? (class_2350)state.method_11654((class_2769)class_2741.field_12545) : null;
    }

    @Nullable
    public static class_2350 getPropertyHorizontalFacingValue(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12481) ? (class_2350)state.method_11654((class_2769)class_2741.field_12481) : null;
    }

    @Nullable
    public static class_5000 getPropertyOrientationValue(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_23333) ? (class_5000)state.method_11654((class_2769)class_2741.field_23333) : null;
    }

    @Nullable
    public static class_2350 getPropertyOrientationFacing(class_2680 state) {
        class_5000 o = BlockUtils.getPropertyOrientationValue(state);
        return o != null ? o.method_26426() : null;
    }

    @Nullable
    public static class_2350 getPropertyOrientationRotation(class_2680 state) {
        class_5000 o = BlockUtils.getPropertyOrientationValue(state);
        return o != null ? o.method_26428() : null;
    }

    public static boolean isFacingValidForDirection(class_1799 stack, class_2350 facing) {
        class_1792 item = stack.method_7909();
        if (!stack.method_7960() && item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            class_2680 state = block.method_9564();
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                return true;
            }
            if (state.method_28498((class_2769)class_2741.field_12545) && !facing.equals((Object)class_2350.field_11036)) {
                return true;
            }
            if (state.method_28498((class_2769)class_2741.field_12481) && !facing.equals((Object)class_2350.field_11036) && !facing.equals((Object)class_2350.field_11033)) {
                return true;
            }
        }
        return false;
    }

    public static int getDirectionFacingIndex(class_1799 stack, class_2350 facing) {
        if (BlockUtils.isFacingValidForDirection(stack, facing)) {
            return facing.method_10146();
        }
        return -1;
    }

    public static boolean isFacingValidForOrientation(class_1799 stack, class_2350 facing) {
        class_1792 item = stack.method_7909();
        if (!stack.method_7960() && item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            class_2680 state = block.method_9564();
            return state.method_28498((class_2769)class_2741.field_23333);
        }
        return false;
    }

    public static int getOrientationFacingIndex(class_1799 stack, class_2350 facing) {
        class_1747 blockItem;
        class_2680 defaultState;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (defaultState = (blockItem = (class_1747)class_17922).method_7711().method_9564()).method_28498((class_2769)class_2741.field_23333)) {
            List<class_5000> list = Arrays.stream(class_5000.values()).toList();
            for (int i = 0; i < list.size(); ++i) {
                class_5000 o = list.get(i);
                if (!o.method_26426().equals((Object)facing)) continue;
                return i;
            }
        }
        return -1;
    }

    public static List<String> getFormattedBlockStateProperties(class_2680 state) {
        return BlockUtils.getFormattedBlockStateProperties(state, ": ");
    }

    public static List<String> getFormattedBlockStateProperties(class_2680 state, String separator) {
        Collection properties = state.method_28501();
        if (properties.size() > 0) {
            ArrayList<String> lines = new ArrayList<String>();
            for (class_2769 prop : properties) {
                Comparable val = state.method_11654(prop);
                if (prop instanceof class_2746) {
                    String pre = val.equals(Boolean.TRUE) ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                    lines.add(prop.method_11899() + separator + pre + val.toString());
                    continue;
                }
                if (prop instanceof class_2754) {
                    class_2754 enumProperty = (class_2754)prop;
                    if (enumProperty.method_11902().equals(class_2350.class)) {
                        lines.add(prop.method_11899() + separator + GuiBase.TXT_GOLD + val.toString());
                        continue;
                    }
                    if (!enumProperty.method_11902().equals(class_5000.class)) continue;
                    lines.add(prop.method_11899() + separator + GuiBase.TXT_LIGHT_PURPLE + val.toString());
                    continue;
                }
                if (prop instanceof class_2758) {
                    lines.add(prop.method_11899() + separator + GuiBase.TXT_AQUA + val.toString());
                    continue;
                }
                lines.add(prop.method_11899() + separator + val.toString());
            }
            return lines;
        }
        return Collections.emptyList();
    }

    public static Set<Integer> getDisabledSlots(class_8887 ce) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (ce != null) {
            for (int i = 0; i < 9; ++i) {
                if (!ce.method_54483(i)) continue;
                list.add(i);
            }
        }
        return list;
    }

    @Nullable
    public static class_2591<?> getBlockEntityTypeFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("id", 8)) {
            return class_7923.field_41181.method_17966(class_2960.method_12829((String)nbt.method_10558("id"))).orElse(null);
        }
        return null;
    }

    public static class_2487 setBlockEntityTypeToNbt(class_2591<?> type, @Nullable class_2487 nbtIn) {
        class_2487 nbt = new class_2487();
        class_2960 id = class_2591.method_11033(type);
        if (id != null) {
            if (nbtIn != null) {
                nbtIn.method_10582("id", id.toString());
                return nbtIn;
            }
            nbt.method_10582("id", id.toString());
        }
        return nbt;
    }

    public static Set<Integer> getDisabledSlotsFromNbt(@Nonnull class_2487 nbt) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (nbt.method_10573("disabled_slots", 11)) {
            int[] is;
            for (int j : is = nbt.method_10561("disabled_slots")) {
                list.add(j);
            }
        }
        return list;
    }

    public static Pair<class_6880<class_1291>, class_6880<class_1291>> getBeaconEffectsFromNbt(@Nonnull class_2487 nbt) {
        class_2960 id;
        class_6880 primary = null;
        class_6880 secondary = null;
        if (nbt.method_10573("primary_effect", 8) && (id = class_2960.method_12829((String)nbt.method_10558("primary_effect"))) != null) {
            primary = class_7923.field_41174.method_10223(id).orElse(null);
        }
        if (nbt.method_10573("secondary_effect", 8) && (id = class_2960.method_12829((String)nbt.method_10558("secondary_effect"))) != null) {
            secondary = class_7923.field_41174.method_10223(id).orElse(null);
        }
        return Pair.of(primary, secondary);
    }

    public static Pair<List<class_4482.class_9309>, class_2338> getBeesDataFromNbt(@Nonnull class_2487 nbt) {
        ArrayList bees = new ArrayList();
        class_2338 flower = class_2338.field_10980;
        if (nbt.method_10545("flower_pos")) {
            flower = NBTUtils.readBlockPosFromIntArray(nbt, "flower_pos");
        }
        if (nbt.method_10573("bees", 9)) {
            class_4482.class_9309.field_49412.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("bees")).resultOrPartial().ifPresent(bees::addAll);
        }
        return Pair.of(bees, (Object)flower);
    }

    public static Pair<Integer, class_8514.class_8515> getSkulkSensorVibrationsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        AtomicReference<Object> data = new AtomicReference<Object>(null);
        int lastFreq = -1;
        if (nbt.method_10573("last_vibration_frequency", 3)) {
            lastFreq = nbt.method_10550("last_vibration_frequency");
        }
        if (nbt.method_10573("listener", 10)) {
            class_8514.class_8515.field_44640.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10562("listener")).resultOrPartial().ifPresent(data::set);
        }
        return Pair.of((Object)lastFreq, (Object)data.get());
    }

    public static Pair<Long, class_2338> getExitPortalFromNbt(@Nonnull class_2487 nbt) {
        long age = -1L;
        class_2338 pos = class_2338.field_10980;
        if (nbt.method_10573("Age", 4)) {
            age = nbt.method_10537("Age");
        }
        if (nbt.method_10573("exit_portal", 11)) {
            pos = NBTUtils.readBlockPosFromIntArray(nbt, "exit_portal");
        }
        return Pair.of((Object)age, (Object)pos);
    }

    public static Pair<Pair<class_8242, class_8242>, Boolean> getSignTextFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        AtomicReference<Object> front = new AtomicReference<Object>(null);
        AtomicReference<Object> back = new AtomicReference<Object>(null);
        boolean waxed = false;
        if (nbt.method_10545("front_text")) {
            class_8242.field_43298.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10562("front_text")).resultOrPartial().ifPresent(front::set);
        }
        if (nbt.method_10545("back_text")) {
            class_8242.field_43298.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10562("back_text")).resultOrPartial().ifPresent(back::set);
        }
        if (nbt.method_10545("is_waxed")) {
            waxed = nbt.method_10577("is_waxed");
        }
        return Pair.of((Object)Pair.of((Object)front.get(), (Object)back.get()), (Object)waxed);
    }

    public static Pair<class_1799, Integer> getBookFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_1799 book = class_1799.field_8037;
        int current = -1;
        if (nbt.method_10573("Book", 10)) {
            book = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("Book"));
        }
        if (nbt.method_10573("Page", 3)) {
            current = nbt.method_10550("Page");
        }
        return Pair.of((Object)book, (Object)current);
    }

    public static Pair<class_9296, Pair<class_2960, class_2561>> getSkullDataFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        AtomicReference<Object> profile = new AtomicReference<Object>(null);
        class_2960 note = null;
        class_5250 name = class_2561.method_43473();
        if (nbt.method_10573("note_block_sound", 8)) {
            note = class_2960.method_12829((String)nbt.method_10558("note_block_sound"));
        }
        if (nbt.method_10573("custom_name", 8)) {
            String str = nbt.method_10558("custom_name");
            try {
                name = class_2561.class_2562.method_10877((String)str, (class_7225.class_7874)registry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nbt.method_10545("profile")) {
            class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580("profile")).resultOrPartial().ifPresent(profile::set);
        }
        return Pair.of((Object)profile.get(), (Object)Pair.of((Object)note, (Object)name));
    }

    public static Reference2IntOpenHashMap<class_5321<class_1860<?>>> getRecipesUsedFromNbt(@Nonnull class_2487 nbt) {
        Reference2IntOpenHashMap list = new Reference2IntOpenHashMap();
        if (nbt.method_10573("RecipesUsed", 10)) {
            class_2487 compound = nbt.method_10562("RecipesUsed");
            for (String key : compound.method_10541()) {
                list.put((Object)class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)class_2960.method_60654((String)key)), compound.method_10550(key));
            }
        }
        return list;
    }

    public static class_6880<class_2248> getBlockEntry(class_2960 id, @Nonnull class_5455 registry) {
        try {
            return (class_6880)registry.method_30530(class_7923.field_41175.method_46765()).method_10223(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setStackNbt(@Nonnull class_1799 stack, @Nonnull class_2586 be, @Nonnull class_5455 registry) {
        class_2487 nbt = be.method_58692((class_7225.class_7874)registry);
        class_1747.method_57338((class_1799)stack, (class_2591)be.method_11017(), (class_2487)nbt);
        stack.method_57365(be.method_57590());
    }
}

