/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IClientRegistrar;
import mcp.mobius.waila.api.ICommonRegistrar;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.SpriteBarComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.api.data.FluidData;
import mcp.mobius.waila.plugin.extra.config.ExtraBlacklistConfig;
import mcp.mobius.waila.plugin.extra.data.FluidDataImpl;
import mcp.mobius.waila.plugin.extra.provider.DataProvider;
import net.minecraft.class_1058;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class FluidProvider
extends DataProvider<FluidData, FluidDataImpl> {
    public static final FluidProvider INSTANCE = new FluidProvider();
    private static final String INFINITE = "\u221e";

    private FluidProvider() {
        super(FluidData.TYPE, FluidDataImpl.CODEC);
    }

    @Override
    protected void registerAdditions(ICommonRegistrar registrar, int priority) {
        registrar.localConfig(FluidData.CONFIG_DISPLAY_UNIT, FluidData.Unit.MILLIBUCKETS);
    }

    @Override
    protected void registerAdditions(IClientRegistrar registrar, int priority) {
        registrar.body(new CauldronProvider(), class_2248.class, priority);
    }

    @Override
    protected void appendBody(ITooltip tooltip, FluidDataImpl data, IPluginConfig config, class_2960 objectId) {
        this.addFluidTooltip(tooltip, data, config);
    }

    private void addFluidTooltip(ITooltip tooltip, FluidDataImpl data, IPluginConfig config) {
        FluidData.Unit displayUnit = (FluidData.Unit)((Object)config.getEnum(FluidData.CONFIG_DISPLAY_UNIT));
        FluidData.Unit storedUnit = data.unit();
        for (FluidDataImpl.Entry<?> entry : data.entries()) {
            Object text;
            float ratio;
            if (entry.isEmpty()) continue;
            FluidDataImpl.FluidDescription desc = FluidDataImpl.FluidDescription.getFluidDesc(entry);
            double stored = entry.stored();
            double capacity = entry.capacity();
            float f = ratio = Double.isInfinite(capacity) ? 1.0f : (float)(stored / capacity);
            if (Double.isInfinite(stored)) {
                text = INFINITE;
            } else {
                text = WailaHelper.suffix((long)FluidData.Unit.convert(storedUnit, displayUnit, stored));
                if (Double.isFinite(capacity)) {
                    text = (String)text + "/" + WailaHelper.suffix((long)FluidData.Unit.convert(storedUnit, displayUnit, capacity));
                }
            }
            text = (String)text + " " + displayUnit.symbol;
            class_1058 sprite = desc.sprite();
            tooltip.addLine(new PairComponent(new WrappedComponent(desc.name().getString()), new SpriteBarComponent(ratio, sprite, 16, 16, desc.tint(), (class_2561)class_2561.method_43470((String)text))));
        }
    }

    private class CauldronProvider
    implements IBlockComponentProvider {
        private CauldronProvider() {
        }

        @Override
        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            if (accessor.getData().get(FluidData.TYPE) != null) {
                return;
            }
            if (!config.getBoolean(FluidProvider.this.enabledBlockOption)) {
                return;
            }
            if (((ExtraBlacklistConfig)FluidProvider.this.blacklistConfig.get()).getView().blockFilter.matches(accessor.getBlock())) {
                return;
            }
            FluidData fluidData = FluidDataImpl.FluidDescription.getCauldronFluidData(accessor.getBlockState());
            if (fluidData != null) {
                FluidProvider.this.addFluidTooltip(tooltip, (FluidDataImpl)fluidData, config);
            }
        }
    }
}

