/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.IllegalFormatException;
import java.util.Random;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaHelper;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public final class DisplayUtil {
    private static final Random RANDOM = new Random();
    private static final class_310 CLIENT = class_310.method_1551();

    public static void enable3DRender() {
        class_308.method_24211();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        class_308.method_24210();
        RenderSystem.disableDepthTest();
    }

    public static void renderRectBorder(Matrix4f matrix, class_287 buf, int x, int y, int w, int h, int s, int gradStart, int gradEnd) {
        if (s <= 0) {
            return;
        }
        DisplayUtil.fillGradient(matrix, buf, x, y, w, s, gradStart, gradStart);
        DisplayUtil.fillGradient(matrix, buf, x, y + h - s, w, s, gradEnd, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x, y + s, s, h - s * 2, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + w - s, y + s, s, h - s * 2, gradStart, gradEnd);
    }

    public static void renderComponent(class_332 ctx, ITooltipComponent component, int x, int y, int cw, class_9779 delta) {
        component.render(ctx, x, y, delta);
        if (WailaClient.showComponentBounds) {
            ctx.method_51448().method_22903();
            float scale = (float)class_310.method_1551().method_22683().method_4495();
            ctx.method_51448().method_22905(1.0f / scale, 1.0f / scale, 1.0f);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            class_287 buf = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            int bx = class_3532.method_15357((double)((double)((float)x * scale) + 0.5));
            int by = class_3532.method_15357((double)((double)((float)y * scale) + 0.5));
            int bw = class_3532.method_15357((double)((double)((float)(cw == 0 ? component.getWidth() : cw) * scale) + 0.5));
            int bh = class_3532.method_15357((double)((double)((float)component.getHeight() * scale) + 0.5));
            int color = -16777216 + class_3532.method_15369((float)RANDOM.nextFloat(), (float)RANDOM.nextFloat(), (float)1.0f);
            DisplayUtil.renderRectBorder(ctx.method_51448().method_23760().method_23761(), buf, bx, by, bw, bh, 1, color, color);
            class_286.method_43433((class_9801)buf.method_60800());
            ctx.method_51448().method_22909();
        }
    }

    public static void fillGradient(Matrix4f matrix, class_287 buf, int x, int y, int w, int h, int start, int end) {
        float sa = (float)WailaHelper.getAlpha(start) / 255.0f;
        float sr = (float)WailaHelper.getRed(start) / 255.0f;
        float sg = (float)WailaHelper.getGreen(start) / 255.0f;
        float sb = (float)WailaHelper.getBlue(start) / 255.0f;
        float ea = (float)WailaHelper.getAlpha(end) / 255.0f;
        float er = (float)WailaHelper.getRed(end) / 255.0f;
        float eg = (float)WailaHelper.getGreen(end) / 255.0f;
        float eb = (float)WailaHelper.getBlue(end) / 255.0f;
        buf.method_22918(matrix, (float)x, (float)y, 0.0f).method_22915(sr, sg, sb, sa);
        buf.method_22918(matrix, (float)x, (float)(y + h), 0.0f).method_22915(er, eg, eb, ea);
        buf.method_22918(matrix, (float)(x + w), (float)(y + h), 0.0f).method_22915(er, eg, eb, ea);
        buf.method_22918(matrix, (float)(x + w), (float)y, 0.0f).method_22915(sr, sg, sb, sa);
    }

    public static int getAlphaFromPercentage(int percentage) {
        return percentage == 100 ? -16777216 : (percentage == 0 ? 0x1000000 : (int)((float)percentage / 100.0f * 256.0f) << 24);
    }

    public static String tryFormat(String format, Object ... args) {
        try {
            return format.formatted(args);
        }
        catch (IllegalFormatException e) {
            return "FORMATTING ERROR";
        }
    }

    public static class_4185 createButton(int x, int y, int width, int height, class_2561 label, class_4185.class_4241 pressAction) {
        return class_4185.method_46430((class_2561)label, (class_4185.class_4241)pressAction).method_46434(x, y, width, height).method_46431();
    }
}

