/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.data;

import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.lib.apache.commons.tuple.Pair;
import com.mojang.datafixers.util.Either;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.Reference;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.mixin.IMixinAbstractHorseEntity;
import fi.dy.masa.minihud.mixin.IMixinDataQueryHandler;
import fi.dy.masa.minihud.mixin.IMixinPiglinEntity;
import fi.dy.masa.minihud.network.ServuxEntitiesHandler;
import fi.dy.masa.minihud.network.ServuxEntitiesPacket;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.EntityUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4836;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class EntitiesDataManager
implements IClientTickHandler {
    private static final EntitiesDataManager INSTANCE = new EntitiesDataManager();
    private static final ServuxEntitiesHandler<ServuxEntitiesPacket.Payload> HANDLER = ServuxEntitiesHandler.getInstance();
    private static final class_310 mc = class_310.method_1551();
    private int uptimeTicks = 0;
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private String servuxVersion;
    private final ConcurrentHashMap<class_2338, Pair<Long, Pair<class_2586, class_2487>>> blockEntityCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Pair<Long, Pair<class_1297, class_2487>>> entityCache = new ConcurrentHashMap();
    private long serverTickTime = 0L;
    private final Set<class_2338> pendingBlockEntitiesQueue = new LinkedHashSet<class_2338>();
    private final Set<Integer> pendingEntitiesQueue = new LinkedHashSet<Integer>();
    private final Map<Integer, Either<class_2338, Integer>> transactionToBlockPosOrEntityId = new HashMap<Integer, Either<class_2338, Integer>>();
    private class_638 clientWorld;

    public static EntitiesDataManager getInstance() {
        return INSTANCE;
    }

    @Nullable
    public class_1937 getWorld() {
        return WorldUtils.getBestWorld((class_310)mc);
    }

    private class_638 getClientWorld() {
        if (this.clientWorld == null) {
            this.clientWorld = EntitiesDataManager.mc.field_1687;
        }
        return this.clientWorld;
    }

    private EntitiesDataManager() {
    }

    public void onClientTick(class_310 mc) {
        ++this.uptimeTicks;
        if (System.currentTimeMillis() - this.serverTickTime > 50L) {
            if (!Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                this.serverTickTime = System.currentTimeMillis();
                if (!DataStorage.getInstance().hasIntegratedServer() && this.hasServuxServer()) {
                    this.servuxServer = false;
                    HANDLER.unregisterPlayReceiver();
                }
                return;
            }
            if (!(DataStorage.getInstance().hasIntegratedServer() || this.hasServuxServer() || this.hasInValidServux || this.getWorld() == null)) {
                HANDLER.registerPlayReceiver(ServuxEntitiesPacket.Payload.ID, HANDLER::receivePlayPayload);
                this.requestMetadata();
            }
            this.tickCache();
            for (int i = 0; i < Configs.Generic.SERVER_NBT_REQUEST_RATE.getIntegerValue(); ++i) {
                Iterator<Object> iter;
                if (!this.pendingBlockEntitiesQueue.isEmpty()) {
                    iter = this.pendingBlockEntitiesQueue.iterator();
                    class_2338 pos = iter.next();
                    iter.remove();
                    if (this.hasServuxServer()) {
                        this.requestServuxBlockEntityData(pos);
                    } else {
                        this.requestQueryBlockEntity(pos);
                    }
                }
                if (this.pendingEntitiesQueue.isEmpty()) continue;
                iter = this.pendingEntitiesQueue.iterator();
                int entityId = (Integer)iter.next();
                iter.remove();
                if (this.hasServuxServer()) {
                    this.requestServuxEntityData(entityId);
                    continue;
                }
                this.requestQueryEntityData(entityId);
            }
            this.serverTickTime = System.currentTimeMillis();
        }
    }

    public class_2960 getNetworkChannel() {
        return ServuxEntitiesHandler.CHANNEL_ID;
    }

    private static class_634 getVanillaHandler() {
        if (EntitiesDataManager.mc.field_1724 != null) {
            return EntitiesDataManager.mc.field_1724.field_3944;
        }
        return null;
    }

    public IPluginClientPlayHandler<ServuxEntitiesPacket.Payload> getNetworkHandler() {
        return HANDLER;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.printDebug("EntitiesDataStorage#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
        } else {
            MiniHUD.printDebug("EntitiesDataStorage#reset() - dimension change or log-in", new Object[0]);
            this.serverTickTime = System.currentTimeMillis() - (this.getCacheTimeout() + 5000L);
            this.tickCache();
            this.serverTickTime = System.currentTimeMillis();
            this.clientWorld = EntitiesDataManager.mc.field_1687;
        }
        this.blockEntityCache.clear();
        this.entityCache.clear();
        this.pendingBlockEntitiesQueue.clear();
        this.pendingEntitiesQueue.clear();
    }

    private long getCacheTimeout() {
        return (long)(class_3532.method_15363((float)Configs.Generic.ENTITY_DATA_SYNC_CACHE_TIMEOUT.getFloatValue(), (float)0.25f, (float)25.0f) * 1000.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickCache() {
        Pair<Long, Pair<class_2586, class_2487>> pair;
        long nowTime = System.currentTimeMillis();
        long blockTimeout = this.getCacheTimeout();
        long entityTimeout = this.getCacheTimeout() * 2L;
        ConcurrentHashMap<Object, Object> concurrentHashMap = this.blockEntityCache;
        synchronized (concurrentHashMap) {
            for (class_2338 pos : this.blockEntityCache.keySet()) {
                pair = this.blockEntityCache.get(pos);
                if (nowTime - (Long)pair.getLeft() <= blockTimeout && (Long)pair.getLeft() - nowTime <= 0L) continue;
                MiniHUD.printDebug("entityCache: be at pos [{}] has timed out by [{}] ms", pos.method_23854(), blockTimeout);
                this.blockEntityCache.remove(pos);
            }
        }
        concurrentHashMap = this.entityCache;
        synchronized (concurrentHashMap) {
            for (Integer entityId : this.entityCache.keySet()) {
                pair = this.entityCache.get(entityId);
                if (nowTime - (Long)pair.getLeft() <= entityTimeout && (Long)pair.getLeft() - nowTime <= 0L) continue;
                MiniHUD.printDebug("entityCache: enity Id [{}] has timed out by [{}] ms", entityId, entityTimeout);
                this.entityCache.remove(entityId);
            }
        }
    }

    @Nullable
    public class_2487 getFromBlockEntityCacheNbt(class_2338 pos) {
        if (this.blockEntityCache.containsKey(pos)) {
            return (class_2487)((Pair)this.blockEntityCache.get(pos).getRight()).getRight();
        }
        return null;
    }

    @Nullable
    public class_2586 getFromBlockEntityCache(class_2338 pos) {
        if (this.blockEntityCache.containsKey(pos)) {
            return (class_2586)((Pair)this.blockEntityCache.get(pos).getRight()).getLeft();
        }
        return null;
    }

    @Nullable
    public class_2487 getFromEntityCacheNbt(int entityId) {
        if (this.entityCache.containsKey(entityId)) {
            return (class_2487)((Pair)this.entityCache.get(entityId).getRight()).getRight();
        }
        return null;
    }

    @Nullable
    public class_1297 getFromEntityCache(int entityId) {
        if (this.entityCache.containsKey(entityId)) {
            return (class_1297)((Pair)this.entityCache.get(entityId).getRight()).getLeft();
        }
        return null;
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        this.hasInValidServux = false;
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public void setServuxVersion(String ver) {
        if (ver != null && !ver.isEmpty()) {
            this.servuxVersion = ver;
            MiniHUD.printDebug("entityDataChannel: joining Servux version {}", ver);
        } else {
            this.servuxVersion = "unknown";
        }
    }

    public String getServuxVersion() {
        return this.servuxVersion;
    }

    public int getPendingBlockEntitiesCount() {
        return this.pendingBlockEntitiesQueue.size();
    }

    public int getPendingEntitiesCount() {
        return this.pendingEntitiesQueue.size();
    }

    public int getBlockEntityCacheCount() {
        return this.blockEntityCache.size();
    }

    public int getEntityCacheCount() {
        return this.entityCache.size();
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxEntitiesPacket.Payload.ID, ServuxEntitiesPacket.Payload.CODEC, 6);
    }

    public void onWorldPre() {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            HANDLER.registerPlayReceiver(ServuxEntitiesPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
    }

    public void requestMetadata() {
        if (!DataStorage.getInstance().hasIntegratedServer() && Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxEntitiesPacket.MetadataRequest(nbt));
        }
    }

    public boolean receiveServuxMetadata(class_2487 data) {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            MiniHUD.printDebug("EntitiesDataStorage#receiveServuxMetadata(): received METADATA from Servux", new Object[0]);
            if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                if (data.method_10550("version") != 1) {
                    MiniHUD.logger.warn("entityDataChannel: Mis-matched protocol version!");
                }
                this.setServuxVersion(data.method_10558("servux"));
                this.setIsServuxServer();
                return true;
            }
        }
        return false;
    }

    public void onPacketFailure() {
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Pair<class_2586, class_2487> requestBlockEntity(class_1937 world, class_2338 pos) {
        if (this.blockEntityCache.containsKey(pos)) {
            return (Pair)this.blockEntityCache.get(pos).getRight();
        }
        if (world.method_8320(pos).method_26204() instanceof class_2343) {
            class_2586 be;
            if (!DataStorage.getInstance().hasIntegratedServer() && Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                this.pendingBlockEntitiesQueue.add(pos);
            }
            if ((be = world.method_8500(pos).method_8321(pos)) != null) {
                class_2487 nbt = be.method_38242((class_7225.class_7874)world.method_30349());
                Pair pair = Pair.of((Object)be, (Object)nbt);
                ConcurrentHashMap<class_2338, Pair<Long, Pair<class_2586, class_2487>>> concurrentHashMap = this.blockEntityCache;
                synchronized (concurrentHashMap) {
                    this.blockEntityCache.put(pos, (Pair<Long, Pair<class_2586, class_2487>>)Pair.of((Object)System.currentTimeMillis(), (Object)pair));
                }
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Pair<class_1297, class_2487> requestEntity(int entityId) {
        if (this.entityCache.containsKey(entityId)) {
            return (Pair)this.entityCache.get(entityId).getRight();
        }
        if (!DataStorage.getInstance().hasIntegratedServer() && Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            this.pendingEntitiesQueue.add(entityId);
        }
        if (this.getWorld() != null) {
            class_1297 entity = this.getWorld().method_8469(entityId);
            class_2487 nbt = new class_2487();
            if (entity != null && entity.method_5786(nbt)) {
                Pair pair = Pair.of((Object)entity, (Object)nbt);
                ConcurrentHashMap<Integer, Pair<Long, Pair<class_1297, class_2487>>> concurrentHashMap = this.entityCache;
                synchronized (concurrentHashMap) {
                    this.entityCache.put(entityId, (Pair<Long, Pair<class_1297, class_2487>>)Pair.of((Object)System.currentTimeMillis(), (Object)pair));
                }
                return pair;
            }
        }
        return null;
    }

    @Nullable
    public class_1263 getBlockInventory(class_1937 world, class_2338 pos, boolean useNbt) {
        if (this.blockEntityCache.containsKey(pos)) {
            class_1263 inv = null;
            if (useNbt) {
                inv = InventoryUtils.getNbtInventory((class_2487)((class_2487)((Pair)this.blockEntityCache.get(pos).getRight()).getRight()), (int)-1, (class_7225.class_7874)world.method_30349());
            } else {
                class_2586 be = (class_2586)((Pair)this.blockEntityCache.get(pos).getRight()).getLeft();
                if (be instanceof class_1263) {
                    class_1263 inv1 = (class_1263)be;
                    if (be instanceof class_2595) {
                        class_2680 state = world.method_8320(pos);
                        class_2745 type = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
                        if (type != class_2745.field_12569) {
                            class_2338 posAdj = pos.method_10093(class_2281.method_9758((class_2680)state));
                            if (!world.method_22340(posAdj)) {
                                return null;
                            }
                            class_2680 stateAdj = world.method_8320(posAdj);
                            class_2586 dataAdj = this.getFromBlockEntityCache(posAdj);
                            if (dataAdj == null) {
                                this.requestBlockEntity(world, posAdj);
                            }
                            if (stateAdj.method_26204() == state.method_26204() && dataAdj instanceof class_2595) {
                                class_2595 inv2 = (class_2595)dataAdj;
                                if (stateAdj.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && stateAdj.method_11654((class_2769)class_2281.field_10768) == state.method_11654((class_2769)class_2281.field_10768)) {
                                    class_1263 invRight = type == class_2745.field_12571 ? inv1 : inv2;
                                    class_2595 invLeft = type == class_2745.field_12571 ? inv2 : inv1;
                                    inv = new class_1258(invRight, (class_1263)invLeft);
                                }
                            }
                        } else {
                            inv = inv1;
                        }
                    } else {
                        inv = inv1;
                    }
                }
            }
            if (inv != null) {
                return inv;
            }
        }
        if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            this.requestBlockEntity(world, pos);
        }
        return null;
    }

    @Nullable
    public class_1263 getEntityInventory(int entityId, boolean useNbt) {
        if (this.entityCache.containsKey(entityId) && this.getWorld() != null) {
            class_1263 inv = null;
            if (useNbt) {
                inv = InventoryUtils.getNbtInventory((class_2487)((class_2487)((Pair)this.entityCache.get(entityId).getRight()).getRight()), (int)-1, (class_7225.class_7874)this.getWorld().method_30349());
            } else {
                class_1297 entity = (class_1297)((Pair)this.entityCache.get(entityId).getRight()).getLeft();
                if (entity instanceof class_1263) {
                    inv = (class_1263)entity;
                } else if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    inv = new class_1277((class_1799[])player.method_31548().field_7547.toArray((Object[])new class_1799[36]));
                } else if (entity instanceof class_1646) {
                    inv = ((class_1646)entity).method_35199();
                } else if (entity instanceof class_1496) {
                    inv = ((IMixinAbstractHorseEntity)entity).minihud_getHorseInventory();
                } else if (entity instanceof class_4836) {
                    inv = ((IMixinPiglinEntity)entity).minihud_inventory();
                }
            }
            if (inv != null) {
                return inv;
            }
        }
        if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            this.requestEntity(entityId);
        }
        return null;
    }

    private void requestQueryBlockEntity(class_2338 pos) {
        if (!Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        class_634 handler = EntitiesDataManager.getVanillaHandler();
        if (handler != null) {
            handler.method_2876().method_1403(pos, nbtCompound -> this.handleBlockEntityData(pos, (class_2487)nbtCompound, null));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.method_2876()).minihud_currentTransactionId(), (Either<class_2338, Integer>)Either.left((Object)pos));
        }
    }

    private void requestQueryEntityData(int entityId) {
        if (!Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            return;
        }
        class_634 handler = EntitiesDataManager.getVanillaHandler();
        if (handler != null) {
            handler.method_2876().method_1405(entityId, nbtCompound -> this.handleEntityData(entityId, (class_2487)nbtCompound));
            this.transactionToBlockPosOrEntityId.put(((IMixinDataQueryHandler)handler.method_2876()).minihud_currentTransactionId(), (Either<class_2338, Integer>)Either.right((Object)entityId));
        }
    }

    private void requestServuxBlockEntityData(class_2338 pos) {
        if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            HANDLER.encodeClientData(ServuxEntitiesPacket.BlockEntityRequest(pos));
        }
    }

    private void requestServuxEntityData(int entityId) {
        if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
            HANDLER.encodeClientData(ServuxEntitiesPacket.EntityRequest(entityId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public class_2586 handleBlockEntityData(class_2338 pos, class_2487 nbt, @Nullable class_2960 type) {
        class_2586 blockEntity2;
        class_2591 beType;
        this.pendingBlockEntitiesQueue.remove(pos);
        if (nbt == null || this.getClientWorld() == null) {
            return null;
        }
        class_2586 blockEntity = this.getClientWorld().method_8321(pos);
        if (blockEntity != null && (type == null || type.equals((Object)class_2591.method_11033((class_2591)blockEntity.method_11017())))) {
            Object id;
            if (!nbt.method_10573("id", 8) && (id = class_2591.method_11033((class_2591)blockEntity.method_11017())) != null) {
                nbt.method_10582("id", id.toString());
            }
            id = this.blockEntityCache;
            synchronized (id) {
                if (this.blockEntityCache.containsKey(pos)) {
                    this.blockEntityCache.replace(pos, (Pair<Long, Pair<class_2586, class_2487>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)blockEntity, (Object)nbt)));
                } else {
                    this.blockEntityCache.put(pos, (Pair<Long, Pair<class_2586, class_2487>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)blockEntity, (Object)nbt)));
                }
            }
            blockEntity.method_58690(nbt, (class_7225.class_7874)this.getClientWorld().method_30349());
            return blockEntity;
        }
        Optional opt = class_7923.field_41181.method_10223(type);
        if (opt.isPresent() && (beType = (class_2591)((class_6880.class_6883)opt.get()).comp_349()).method_20526(this.getClientWorld().method_8320(pos)) && (blockEntity2 = beType.method_11032(pos, this.getClientWorld().method_8320(pos))) != null) {
            class_2960 id;
            if (!nbt.method_10573("id", 8) && (id = class_2591.method_11033((class_2591)beType)) != null) {
                nbt.method_10582("id", id.toString());
            }
            ConcurrentHashMap<class_2338, Pair<Long, Pair<class_2586, class_2487>>> concurrentHashMap = this.blockEntityCache;
            synchronized (concurrentHashMap) {
                if (this.blockEntityCache.containsKey(pos)) {
                    this.blockEntityCache.replace(pos, (Pair<Long, Pair<class_2586, class_2487>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)blockEntity2, (Object)nbt)));
                } else {
                    this.blockEntityCache.put(pos, (Pair<Long, Pair<class_2586, class_2487>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)blockEntity2, (Object)nbt)));
                }
            }
            if (Configs.Generic.ENTITY_DATA_LOAD_NBT.getBooleanValue()) {
                blockEntity2.method_58690(nbt, (class_7225.class_7874)this.getClientWorld().method_30349());
                this.getClientWorld().method_8438(blockEntity2);
            }
            return blockEntity2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public class_1297 handleEntityData(int entityId, class_2487 nbt) {
        this.pendingEntitiesQueue.remove(entityId);
        if (nbt == null || this.getClientWorld() == null) {
            return null;
        }
        class_1297 entity = this.getClientWorld().method_8469(entityId);
        if (entity != null) {
            class_2960 id;
            if (!nbt.method_10573("id", 8) && (id = class_1299.method_5890((class_1299)entity.method_5864())) != null) {
                nbt.method_10582("id", id.toString());
            }
            ConcurrentHashMap<Integer, Pair<Long, Pair<class_1297, class_2487>>> concurrentHashMap = this.entityCache;
            synchronized (concurrentHashMap) {
                if (this.entityCache.containsKey(entityId)) {
                    this.entityCache.replace(entityId, (Pair<Long, Pair<class_1297, class_2487>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)entity, (Object)nbt)));
                } else {
                    this.entityCache.put(entityId, (Pair<Long, Pair<class_1297, class_2487>>)Pair.of((Object)System.currentTimeMillis(), (Object)Pair.of((Object)entity, (Object)nbt)));
                }
            }
            if (Configs.Generic.ENTITY_DATA_LOAD_NBT.getBooleanValue()) {
                EntityUtils.loadNbtIntoEntity(entity, nbt);
            }
        }
        return entity;
    }

    public void handleBulkEntityData(int transactionId, class_2487 nbt) {
    }

    public void handleVanillaQueryNbt(int transactionId, class_2487 nbt) {
        Either<class_2338, Integer> either = this.transactionToBlockPosOrEntityId.remove(transactionId);
        if (either != null) {
            either.ifLeft(pos -> this.handleBlockEntityData((class_2338)pos, nbt, null)).ifRight(entityId -> this.handleEntityData((int)entityId, nbt));
        }
    }

    public JsonObject toJson() {
        return new JsonObject();
    }

    public void fromJson(JsonObject obj) {
    }
}

