/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.Reference;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinServerRecipeManager;
import fi.dy.masa.minihud.network.ServuxHudHandler;
import fi.dy.masa.minihud.network.ServuxHudPacket;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.util.DataStorage;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.class_10286;
import net.minecraft.class_10289;
import net.minecraft.class_1132;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;

public class HudDataManager {
    private static final HudDataManager INSTANCE = new HudDataManager();
    private static final ServuxHudHandler<ServuxHudPacket.Payload> HANDLER = ServuxHudHandler.getInstance();
    private final class_310 mc = class_310.method_1551();
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private String servuxVersion = "";
    private long worldSeed = -1L;
    private int spawnChunkRadius = -1;
    private class_2338 worldSpawn = class_2338.field_10980;
    private boolean worldSeedValid = false;
    private boolean spawnChunkRadiusValid = false;
    private boolean worldSpawnValid = false;
    private boolean isRaining = false;
    private boolean isThundering = false;
    private int clearWeatherTimer = -1;
    private int rainWeatherTimer = -1;
    private int thunderWeatherTimer = -1;
    private class_10289 preparedRecipes = class_10289.field_54643;
    private int recipeCount = 0;

    public static HudDataManager getInstance() {
        return INSTANCE;
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxHudPacket.Payload.ID, ServuxHudPacket.Payload.CODEC, 6);
    }

    public class_2960 getNetworkChannel() {
        return ServuxHudHandler.CHANNEL_ID;
    }

    public IPluginClientPlayHandler<ServuxHudPacket.Payload> getNetworkHandler() {
        return HANDLER;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.printDebug("HudDataStorage#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
            this.servuxVersion = "";
            this.spawnChunkRadius = -1;
            this.worldSpawn = class_2338.field_10980;
            this.worldSpawnValid = false;
            this.spawnChunkRadiusValid = false;
            this.preparedRecipes = class_10289.field_54643;
            this.recipeCount = 0;
        }
        this.isRaining = false;
        this.isThundering = false;
        this.clearWeatherTimer = -1;
        this.rainWeatherTimer = -1;
        this.thunderWeatherTimer = -1;
        if (isLogout || !Configs.Generic.DONT_RESET_SEED_ON_DIMENSION_CHANGE.getBooleanValue()) {
            this.worldSeedValid = false;
            this.worldSeed = 0L;
        }
    }

    public void onWorldPre() {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            HANDLER.registerPlayReceiver(ServuxHudPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
        MiniHUD.printDebug("HudDataStorage#onWorldJoin()", new Object[0]);
    }

    public void onPacketFailure() {
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        if (this.hasInValidServux) {
            this.hasInValidServux = false;
        }
    }

    public void setServuxVersion(String ver) {
        this.servuxVersion = ver != null && !ver.isEmpty() ? ver : "unknown";
    }

    public String getServuxVersion() {
        if (this.hasServuxServer()) {
            return this.servuxVersion;
        }
        return "not_connected";
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public void setWorldSeed(long seed) {
        if (this.worldSeed != seed) {
            MiniHUD.printDebug("HudDataStorage#setWorldSeed(): set world seed [{}] -> [{}]", this.worldSeed, seed);
        }
        this.worldSeed = seed;
        this.worldSeedValid = true;
    }

    public void setWorldSpawn(class_2338 spawn) {
        if (!this.worldSpawn.equals((Object)spawn)) {
            OverlayRendererSpawnChunks.setNeedsUpdate();
            MiniHUD.printDebug("HudDataStorage#setWorldSpawn(): set world spawn [{}] -> [{}]", this.worldSpawn.method_23854(), spawn.method_23854());
        }
        this.worldSpawn = spawn;
        this.worldSpawnValid = true;
    }

    public void setSpawnChunkRadius(int radius, boolean message) {
        if (radius >= 0 && radius <= 32) {
            if (this.spawnChunkRadius != radius) {
                if (message) {
                    String strRadius = radius > 0 ? GuiBase.TXT_GREEN + String.format("%d", radius) + GuiBase.TXT_RST : GuiBase.TXT_RED + String.format("%d", radius) + GuiBase.TXT_RST;
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"minihud.message.spawn_chunk_radius_set", (Object[])new Object[]{strRadius}), (Object[])new Object[0]);
                }
                OverlayRendererSpawnChunks.setNeedsUpdate();
                MiniHUD.printDebug("HudDataStorage#setSpawnChunkRadius(): set spawn chunk radius [{}] -> [{}]", this.spawnChunkRadius, radius);
            }
            this.spawnChunkRadius = radius;
            this.spawnChunkRadiusValid = true;
        } else {
            this.spawnChunkRadius = -1;
            this.spawnChunkRadiusValid = false;
        }
    }

    public void setWorldSpawnIfUnknown(class_2338 spawn) {
        if (!this.worldSpawnValid) {
            this.setWorldSpawn(spawn);
            OverlayRendererSpawnChunks.setNeedsUpdate();
        }
    }

    public void setSpawnChunkRadiusIfUnknown(int radius) {
        if (!this.spawnChunkRadiusValid) {
            this.setSpawnChunkRadius(radius, true);
            OverlayRendererSpawnChunks.setNeedsUpdate();
        }
    }

    public boolean isWorldSeedKnown(class_1937 world) {
        if (this.worldSeedValid) {
            return true;
        }
        if (this.mc.method_1496()) {
            class_1132 server = this.mc.method_1576();
            assert (server != null);
            class_3218 worldTmp = server.method_3847(world.method_27983());
            return worldTmp != null;
        }
        return false;
    }

    public boolean hasStoredWorldSeed() {
        return this.worldSeedValid;
    }

    public long worldSeed() {
        return this.worldSeed;
    }

    public long getWorldSeed(class_1937 world) {
        if (!this.worldSeedValid && this.mc.method_1496()) {
            class_1132 server = this.mc.method_1576();
            assert (server != null);
            class_3218 worldTmp = server.method_3847(world.method_27983());
            if (worldTmp != null) {
                this.setWorldSeed(worldTmp.method_8412());
            }
        }
        return this.worldSeed;
    }

    public void checkWorldSeed(MinecraftServer server) {
        long seedTmp;
        class_3218 worldTmp;
        if (this.mc.method_1496() && (worldTmp = server.method_30002()) != null && (seedTmp = worldTmp.method_8412()) != this.worldSeed) {
            this.setWorldSeed(seedTmp);
        }
    }

    public boolean isWorldSpawnKnown() {
        return this.worldSpawnValid;
    }

    public class_2338 getWorldSpawn() {
        return this.worldSpawn;
    }

    public boolean isSpawnChunkRadiusKnown() {
        return this.spawnChunkRadiusValid;
    }

    public int getSpawnChunkRadius() {
        if (this.spawnChunkRadius > -1) {
            return this.spawnChunkRadius;
        }
        return 2;
    }

    public boolean isWeatherClear() {
        return !this.isWeatherRain() && !this.isWeatherThunder();
    }

    public int getClearTime() {
        if (this.isWeatherClear()) {
            return this.clearWeatherTimer;
        }
        return -1;
    }

    public boolean isWeatherRain() {
        return this.isRaining;
    }

    public int getRainTime() {
        if (this.isWeatherRain()) {
            return this.rainWeatherTimer;
        }
        return -1;
    }

    public boolean isWeatherThunder() {
        return this.isThundering;
    }

    public int getThunderTime() {
        if (this.isWeatherThunder()) {
            return this.thunderWeatherTimer;
        }
        return -1;
    }

    public boolean hasRecipes() {
        return !this.preparedRecipes.equals(class_10289.field_54643);
    }

    @Nullable
    public class_10289 getPreparedRecipes() {
        if (DataStorage.getInstance().hasIntegratedServer() && this.getRecipeManager() != null) {
            return ((IMixinServerRecipeManager)this.getRecipeManager()).minihud_getPreparedRecipes();
        }
        if (this.hasRecipes()) {
            return this.preparedRecipes;
        }
        return null;
    }

    public int getRecipeCount() {
        return this.recipeCount;
    }

    @Nullable
    public class_10286 getRecipeManager() {
        if (DataStorage.getInstance().hasIntegratedServer() && this.mc.method_1576() != null) {
            return this.mc.method_1576().method_3772();
        }
        if (this.mc.field_1687 != null) {
            return this.mc.field_1687.method_8433();
        }
        return null;
    }

    public void onClientTickPost(class_310 mc) {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            if (this.clearWeatherTimer > 0) {
                --this.clearWeatherTimer;
            }
            if (this.rainWeatherTimer > 0) {
                --this.rainWeatherTimer;
            }
            if (this.thunderWeatherTimer > 0) {
                --this.thunderWeatherTimer;
            }
        }
    }

    public void onServerWeatherTick(int clearTime, int rainTime, int thunderTime, boolean isRaining, boolean isThunder) {
        this.clearWeatherTimer = clearTime;
        this.rainWeatherTimer = rainTime;
        this.thunderWeatherTimer = thunderTime;
        this.isRaining = isRaining;
        this.isThundering = isThunder;
    }

    public boolean receiveMetadata(class_2487 data) {
        if (!this.servuxServer && !DataStorage.getInstance().hasIntegratedServer()) {
            MiniHUD.printDebug("HudDataStorage#receiveMetadata(): received METADATA from Servux", new Object[0]);
            if (data.method_10550("version") != 2) {
                MiniHUD.logger.warn("hudDataChannel: Mis-matched protocol version!");
            }
            this.setServuxVersion(data.method_10558("servux"));
            this.setWorldSpawn(new class_2338(data.method_10550("spawnPosX"), data.method_10550("spawnPosY"), data.method_10550("spawnPosZ")));
            this.setSpawnChunkRadius(data.method_10550("spawnChunkRadius"), true);
            if (data.method_10573("worldSeed", 4)) {
                this.setWorldSeed(data.method_10537("worldSeed"));
            }
            this.setIsServuxServer();
            this.requestRecipeManager();
            return true;
        }
        return false;
    }

    public void requestSpawnMetadata() {
        if (!DataStorage.getInstance().hasIntegratedServer() && this.hasServuxServer()) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxHudPacket.SpawnRequest(nbt));
        }
    }

    public void receiveSpawnMetadata(class_2487 data) {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            MiniHUD.printDebug("HudDataStorage#receiveSpawnMetadata(): from Servux", new Object[0]);
            this.setServuxVersion(data.method_10558("servux"));
            this.setWorldSpawn(new class_2338(data.method_10550("spawnPosX"), data.method_10550("spawnPosY"), data.method_10550("spawnPosZ")));
            this.setSpawnChunkRadius(data.method_10550("spawnChunkRadius"), true);
            if (data.method_10573("worldSeed", 4)) {
                this.setWorldSeed(data.method_10537("worldSeed"));
            }
        }
    }

    public void receiveWeatherData(class_2487 data) {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            if (data.method_10573("SetRaining", 3)) {
                this.rainWeatherTimer = data.method_10550("SetRaining");
            }
            if (data.method_10545("isRaining")) {
                this.isRaining = data.method_10577("isRaining");
            }
            if (data.method_10573("SetThundering", 3)) {
                this.thunderWeatherTimer = data.method_10550("SetThundering");
            }
            if (data.method_10545("isThundering")) {
                this.isThundering = data.method_10577("isThundering");
            }
            if (data.method_10573("SetClear", 3)) {
                this.clearWeatherTimer = data.method_10550("SetClear");
            }
            if (!this.hasServuxServer() && DataStorage.getInstance().hasServuxServer()) {
                this.isThundering = this.thunderWeatherTimer > 0 && !this.isThundering;
                this.isRaining = this.rainWeatherTimer > 0 && !this.isRaining;
            }
        }
    }

    public void requestRecipeManager() {
        if (!DataStorage.getInstance().hasIntegratedServer() && this.hasServuxServer()) {
            class_2487 nbt = new class_2487();
            nbt.method_10582("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxHudPacket.RecipeManagerRequest(nbt));
        }
    }

    public void receiveRecipeManager(class_2487 data) {
        if (!DataStorage.getInstance().hasIntegratedServer() && data.method_10545("RecipeManager")) {
            ArrayList<class_8786> recipes = new ArrayList<class_8786>();
            class_2499 list = data.method_10554("RecipeManager", 10);
            int count = 0;
            this.preparedRecipes = class_10289.field_54643;
            this.recipeCount = 0;
            for (int i = 0; i < list.size(); ++i) {
                class_2487 item = list.method_10602(i);
                class_2960 idReg = class_2960.method_12829((String)item.method_10558("id_reg"));
                class_2960 idValue = class_2960.method_12829((String)item.method_10558("id_value"));
                if (idReg == null || idValue == null) continue;
                try {
                    class_5321 key = class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)idReg), (class_2960)idValue);
                    Pair pair = (Pair)class_1860.field_47319.decode((DynamicOps)DataStorage.getInstance().getWorldRegistryManager().method_57093((DynamicOps)class_2509.field_11560), (Object)item.method_10562("recipe")).getOrThrow();
                    class_8786 entry = new class_8786(key, (class_1860)pair.getFirst());
                    recipes.add(entry);
                    ++count;
                    continue;
                }
                catch (Exception e) {
                    MiniHUD.logger.error("receiveRecipeManager: index [{}], Exception reading packet, {}", (Object)i, (Object)e.getMessage());
                }
            }
            if (!recipes.isEmpty()) {
                this.preparedRecipes = class_10289.method_64700(recipes);
                this.recipeCount = count;
                MiniHUD.printDebug("HudDataStorage#receiveRecipeManager(): finished loading Recipe Manager: Read [{}] Recipes from Servux", count);
            } else {
                MiniHUD.logger.warn("receiveRecipeManager: failed to read Recipe Manager from Servux (Collection was empty!)");
            }
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        if (this.worldSeedValid) {
            obj.add("seed", (JsonElement)new JsonPrimitive((Number)this.worldSeed));
        }
        if (this.isSpawnChunkRadiusKnown()) {
            obj.add("spawn_chunk_radius", (JsonElement)new JsonPrimitive((Number)this.spawnChunkRadius));
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        if (JsonUtils.hasLong((JsonObject)obj, (String)"seed")) {
            long seedTmp = JsonUtils.getLong((JsonObject)obj, (String)"seed");
            if (DataStorage.getInstance().hasIntegratedServer() && this.hasStoredWorldSeed() && this.worldSeed != seedTmp) {
                MiniHUD.printDebug("HudDataStorage#fromJson(): ignoring stale WorldSeed [{}], keeping [{}] as valid from the integrated server", seedTmp, this.worldSeed);
            } else {
                this.setWorldSeed(seedTmp);
            }
        }
        if (JsonUtils.hasInteger((JsonObject)obj, (String)"spawn_chunk_radius")) {
            int spawnRadiusTmp = JsonUtils.getIntegerOrDefault((JsonObject)obj, (String)"spawn_chunk_radius", (int)2);
            if (DataStorage.getInstance().hasIntegratedServer() && this.isSpawnChunkRadiusKnown() && this.spawnChunkRadius != spawnRadiusTmp) {
                MiniHUD.printDebug("HudDataStorage#fromJson(): ignoring stale Spawn Chunk Radius [{}], keeping [{}] as valid from the integrated server", spawnRadiusTmp, this.spawnChunkRadius);
            } else {
                this.setSpawnChunkRadius(spawnRadiusTmp, false);
            }
            if (this.getSpawnChunkRadius() == 0 && RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL.getBooleanValue()) {
                MiniHUD.logger.warn("HudDataStorage#fromJson(): toggling feature OFF since SPAWN_CHUNK_RADIUS is set to 0");
                RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL.setBooleanValue(false);
                OverlayRendererSpawnChunks.setNeedsUpdate();
            }
        }
    }
}

