/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.gui;

import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.event.RenderHandler;
import fi.dy.masa.minihud.util.RayTraceUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import net.minecraft.class_8887;

public class InventoryOverlayScreen
extends class_437
implements class_4068 {
    private InventoryOverlay.Context previewData;
    private int ticks;

    public InventoryOverlayScreen(InventoryOverlay.Context previewData) {
        super((class_2561)class_2561.method_43470((String)"Inventory Overlay"));
        this.previewData = previewData;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        ++this.ticks;
        class_310 mc = class_310.method_1551();
        class_1937 world = WorldUtils.getBestWorld((class_310)mc);
        if (this.previewData != null && world != null) {
            class_2586 class_25862;
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            int x = xCenter - 26;
            int y = yCenter - 92;
            int startSlot = 0;
            int totalSlots = this.previewData.inv() == null ? 0 : this.previewData.inv().method_5439();
            ArrayList<class_1799> armourItems = new ArrayList<class_1799>();
            if (this.previewData.entity() instanceof class_1496) {
                if (this.previewData.inv() == null) {
                    MiniHUD.logger.error("InventoryOverlayScreen(): Horse inv() = null");
                    return;
                }
                armourItems.add(this.previewData.entity().method_6118(class_1304.field_48824));
                armourItems.add(this.previewData.inv().method_5438(0));
                startSlot = 1;
                totalSlots = this.previewData.inv().method_5439() - 1;
            } else if (this.previewData.entity() instanceof class_1493) {
                armourItems.add(this.previewData.entity().method_6118(class_1304.field_48824));
            }
            InventoryOverlay.InventoryRenderType type = this.previewData.entity() instanceof class_1646 ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType((class_1263)this.previewData.inv(), (class_2487)(this.previewData.nbt() != null ? this.previewData.nbt() : new class_2487()), (InventoryOverlay.Context)this.previewData);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            Set lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (this.previewData.entity() != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if ((class_25862 = this.previewData.be()) instanceof class_8887) {
                class_8887 cbe = (class_8887)class_25862;
                lockedSlots = BlockUtils.getDisabledSlots((class_8887)cbe);
            } else if (this.previewData.nbt() != null && this.previewData.nbt().method_10545("disabled_slots")) {
                lockedSlots = BlockUtils.getDisabledSlotsFromNbt((class_2487)this.previewData.nbt());
            }
            if (!armourItems.isEmpty()) {
                class_1277 horseInv = new class_1277(armourItems.toArray(new class_1799[0]));
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)horseInv.method_5439(), (class_310)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)horseInv.method_5439(), (class_310)mc, (class_332)drawContext, (double)mouseX, (double)mouseY);
                xInv += 36;
            }
            if (this.previewData.be() != null && (class_25862 = this.previewData.be().method_11010().method_26204()) instanceof class_2480) {
                class_2480 sbb = (class_2480)class_25862;
                RenderUtils.setShulkerboxBackgroundTintColor((class_2480)sbb, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            }
            if (totalSlots > 0 && this.previewData.inv() != null) {
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)totalSlots, (class_310)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)this.previewData.inv(), (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)startSlot, (int)totalSlots, lockedSlots, (class_310)mc, (class_332)drawContext, (double)mouseX, (double)mouseY);
            }
            if (this.previewData.type() == InventoryOverlay.InventoryRenderType.PLAYER && this.previewData.nbt() != null && this.previewData.nbt().method_10545("EnderItems")) {
                class_1730 enderItems = InventoryUtils.getPlayerEnderItemsFromNbt((class_2487)this.previewData.nbt(), (class_7225.class_7874)world.method_30349());
                if (enderItems == null) {
                    enderItems = new class_1730();
                }
                yInv = yCenter + 6;
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)InventoryOverlay.InventoryRenderType.GENERIC, (int)xInv, (int)yInv, (int)9, (int)27, (class_310)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)InventoryOverlay.InventoryRenderType.GENERIC, (class_1263)enderItems, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)9, (int)0, (int)27, (class_310)mc, (class_332)drawContext, (double)mouseX, (double)mouseY);
            } else {
                class_25862 = this.previewData.entity();
                if (class_25862 instanceof class_1657) {
                    class_1657 player = (class_1657)class_25862;
                    yInv = yCenter + 6;
                    InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)InventoryOverlay.InventoryRenderType.GENERIC, (int)xInv, (int)yInv, (int)9, (int)27, (class_310)mc);
                    InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)InventoryOverlay.InventoryRenderType.GENERIC, (class_1263)player.method_7274(), (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)9, (int)0, (int)27, (class_310)mc, (class_332)drawContext, (double)mouseX, (double)mouseY);
                }
            }
            if (this.previewData.entity() != null) {
                InventoryOverlay.renderEquipmentOverlayBackground((int)x, (int)y, (class_1309)this.previewData.entity(), (class_332)drawContext);
                InventoryOverlay.renderEquipmentStacks((class_1309)this.previewData.entity(), (int)x, (int)y, (class_310)mc, (class_332)drawContext, (double)mouseX, (double)mouseY);
            }
            if (this.ticks % 4 == 0) {
                if (this.previewData.be() != null) {
                    RenderHandler.getInstance().requestBlockEntityAt(world, this.previewData.be().method_11016());
                    this.previewData = RayTraceUtils.getTargetInventoryFromBlock(this.previewData.be().method_10997(), this.previewData.be().method_11016(), this.previewData.be(), this.previewData.nbt());
                } else if (this.previewData.entity() != null) {
                    EntitiesDataManager.getInstance().requestEntity(this.previewData.entity().method_5628());
                    this.previewData = RayTraceUtils.getTargetInventoryFromEntity((class_1297)this.previewData.entity(), this.previewData.nbt());
                }
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    public static void dumpInvStacks(class_1263 inv, class_1937 world) {
        System.out.print("dumpInvStacks() -->\n");
        if (inv == null || inv.method_5439() <= 0 || world == null) {
            System.out.print("EMPTY / NULL\n");
            return;
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) {
                System.out.printf("slot[%d]: [%s]\n", i, "minecraft:air [EMPTY]");
                continue;
            }
            System.out.printf("slot[%d]: [%s]\n", i, inv.method_5438(i).method_57358((class_7225.class_7874)world.method_30349()));
        }
        System.out.print("END\n");
    }
}

