/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.gui.InventoryOverlayScreen;
import fi.dy.masa.minihud.mixin.IMixinAbstractHorseEntity;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.InventoryUtils;
import fi.dy.masa.minihud.util.RayTraceUtils;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_8886;
import net.minecraft.class_8887;

public class RenderUtils {
    public static void renderWallsWithLines(class_2338 posStart, class_2338 posEnd, class_243 cameraPos, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        double minZ;
        double maxZ;
        double maxX;
        double minX;
        class_1297 entity = EntityUtils.getCameraEntity();
        int boxMinX = Math.min(posStart.method_10263(), posEnd.method_10263());
        int boxMinZ = Math.min(posStart.method_10260(), posEnd.method_10260());
        int boxMaxX = Math.max(posStart.method_10263(), posEnd.method_10263());
        int boxMaxZ = Math.max(posStart.method_10260(), posEnd.method_10260());
        int centerX = (int)Math.floor(entity.method_23317());
        int centerZ = (int)Math.floor(entity.method_23321());
        int maxDist = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 32;
        int rangeMinX = centerX - maxDist;
        int rangeMinZ = centerZ - maxDist;
        int rangeMaxX = centerX + maxDist;
        int rangeMaxZ = centerZ + maxDist;
        double minY = Math.min(posStart.method_10264(), posEnd.method_10264());
        double maxY = Math.max(posStart.method_10264(), posEnd.method_10264()) + 1;
        if (rangeMinX <= boxMaxX && rangeMaxX >= boxMinX) {
            minX = Math.max(boxMinX, rangeMinX);
            maxX = Math.min(boxMaxX, rangeMaxX) + 1;
            if (rangeMinZ <= boxMinZ && rangeMaxZ >= boxMinZ) {
                minZ = maxZ = (double)boxMinZ;
                RenderUtils.renderWallWithLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
            if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMaxZ) {
                minZ = maxZ = (double)(boxMaxZ + 1);
                RenderUtils.renderWallWithLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
        }
        if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMinZ) {
            minZ = Math.max(boxMinZ, rangeMinZ);
            maxZ = Math.min(boxMaxZ, rangeMaxZ) + 1;
            if (rangeMinX <= boxMinX && rangeMaxX >= boxMinX) {
                minX = maxX = (double)boxMinX;
                RenderUtils.renderWallWithLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
            if (rangeMinX <= boxMaxX && rangeMaxX >= boxMaxX) {
                minX = maxX = (double)(boxMaxX + 1);
                RenderUtils.renderWallWithLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
        }
    }

    public static void renderWallWithLines(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, class_243 cameraPos, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        block4: {
            double lineX;
            float cz;
            float cy;
            float cx;
            block5: {
                double lineZ;
                cx = (float)cameraPos.field_1352;
                cy = (float)cameraPos.field_1351;
                cz = (float)cameraPos.field_1350;
                bufferQuads.method_22912(minX - cx, maxY - cy, minZ - cz).method_22915(color.r, color.g, color.b, color.a);
                bufferQuads.method_22912(minX - cx, minY - cy, minZ - cz).method_22915(color.r, color.g, color.b, color.a);
                bufferQuads.method_22912(maxX - cx, minY - cy, maxZ - cz).method_22915(color.r, color.g, color.b, color.a);
                bufferQuads.method_22912(maxX - cx, maxY - cy, maxZ - cz).method_22915(color.r, color.g, color.b, color.a);
                if (lineIntervalV > 0.0) {
                    double lineY;
                    double d = lineY = alignLinesToModulo ? RenderUtils.roundUp(minY, lineIntervalV) : (double)minY;
                    while (lineY <= (double)maxY) {
                        bufferLines.method_22912(minX - cx, (float)(lineY - (double)cy), minZ - cz).method_22915(color.r, color.g, color.b, 1.0f);
                        bufferLines.method_22912(maxX - cx, (float)(lineY - (double)cy), maxZ - cz).method_22915(color.r, color.g, color.b, 1.0f);
                        lineY += lineIntervalV;
                    }
                }
                if (!(lineIntervalH > 0.0)) break block4;
                if (minX != maxX) break block5;
                double d = lineZ = alignLinesToModulo ? RenderUtils.roundUp(minZ, lineIntervalH) : (double)minZ;
                while (lineZ <= (double)maxZ) {
                    bufferLines.method_22912(minX - cx, minY - cy, (float)(lineZ - (double)cz)).method_22915(color.r, color.g, color.b, 1.0f);
                    bufferLines.method_22912(minX - cx, maxY - cy, (float)(lineZ - (double)cz)).method_22915(color.r, color.g, color.b, 1.0f);
                    lineZ += lineIntervalH;
                }
                break block4;
            }
            if (minZ != maxZ) break block4;
            double d = lineX = alignLinesToModulo ? RenderUtils.roundUp(minX, lineIntervalH) : (double)minX;
            while (lineX <= (double)maxX) {
                bufferLines.method_22912((float)(lineX - (double)cx), minY - cy, minZ - cz).method_22915(color.r, color.g, color.b, 1.0f);
                bufferLines.method_22912((float)(lineX - (double)cx), maxY - cy, minZ - cz).method_22915(color.r, color.g, color.b, 1.0f);
                lineX += lineIntervalH;
            }
        }
    }

    public static void drawBlockSpaceSideBatchedQuads(long posLong, class_2350 side, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        int x = class_2338.method_10061((long)posLong);
        int y = class_2338.method_10071((long)posLong);
        int z = class_2338.method_10083((long)posLong);
        float offsetX = (float)((double)x - cameraPos.field_1352);
        float offsetY = (float)((double)y - cameraPos.field_1351);
        float offsetZ = (float)((double)z - cameraPos.field_1350);
        float minX = (float)((double)offsetX - expand);
        float minY = (float)((double)offsetY - expand);
        float minZ = (float)((double)offsetZ - expand);
        float maxX = (float)((double)offsetX + expand + 1.0);
        float maxY = (float)((double)offsetY + expand + 1.0);
        float maxZ = (float)((double)offsetZ + expand + 1.0);
        switch (side) {
            case field_11033: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11043: {
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11039: {
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void renderCircleBlockPositions(LongOpenHashSet positions, class_2350[] sides, SphereUtils.RingPositionTest test, ShapeRenderType renderType, LayerRange range, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        boolean full = renderType == ShapeRenderType.FULL_BLOCK;
        boolean outer = renderType == ShapeRenderType.OUTER_EDGE;
        boolean inner = renderType == ShapeRenderType.INNER_EDGE;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (class_2350 side : sides) {
                long adjPosLong = class_2338.method_10060((long)posLong, (class_2350)side);
                if (positions.contains(adjPosLong)) continue;
                boolean render = full;
                if (!full) {
                    int adjX = class_2338.method_10061((long)adjPosLong);
                    int adjY = class_2338.method_10071((long)adjPosLong);
                    int adjZ = class_2338.method_10083((long)adjPosLong);
                    boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
                    boolean bl = render = outer && !onOrIn || inner && onOrIn;
                }
                if (!render) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderBlockPositions(LongOpenHashSet positions, LayerRange range, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
                long adjPosLong = class_2338.method_10060((long)posLong, (class_2350)side);
                if (positions.contains(adjPosLong)) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderQuads(Collection<SideQuad> quads, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        for (SideQuad quad : quads) {
            RenderUtils.renderInsetQuad(quad.startPos(), quad.width(), quad.height(), quad.side(), -expand, color, cameraPos, buffer);
        }
    }

    public static void renderInsetQuad(class_2382 minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        RenderUtils.renderInsetQuad(minPos.method_10263(), minPos.method_10264(), minPos.method_10260(), width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(long minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        int x = class_2338.method_10061((long)minPos);
        int y = class_2338.method_10071((long)minPos);
        int z = class_2338.method_10083((long)minPos);
        RenderUtils.renderInsetQuad(x, y, z, width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(int x, int y, int z, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        float minX = (float)((double)x - cameraPos.field_1352);
        float minY = (float)((double)y - cameraPos.field_1351);
        float minZ = (float)((double)z - cameraPos.field_1350);
        float maxX = minX;
        float maxY = minY;
        float maxZ = minZ;
        if (side.method_10166() == class_2350.class_2351.field_11051) {
            maxX += (float)width;
            maxY += (float)height;
        } else if (side.method_10166() == class_2350.class_2351.field_11048) {
            maxY += (float)height;
            maxZ += (float)width;
        } else if (side.method_10166() == class_2350.class_2351.field_11052) {
            maxX += (float)width;
            maxZ += (float)height;
        }
        switch (side) {
            case field_11039: {
                buffer.method_22912(minX += (float)inset, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX += (float)(1.0 - inset), minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11043: {
                buffer.method_22912(minX, minY, minZ += (float)inset).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ += (float)(1.0 - inset)).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11033: {
                buffer.method_22912(minX, minY += (float)inset, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY += (float)(1.0 - inset), minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void renderBiomeBorderLines(class_2382 minPos, int width, int height, class_2350 side, double inset, Color4f color, class_243 cameraPos, class_287 buffer) {
        float minX = (float)((double)minPos.method_10263() - cameraPos.field_1352);
        float minY = (float)((double)minPos.method_10264() - cameraPos.field_1351);
        float minZ = (float)((double)minPos.method_10260() - cameraPos.field_1350);
        switch (side) {
            case field_11039: {
                minX += (float)inset;
                break;
            }
            case field_11034: {
                minX += (float)(1.0 - inset);
                break;
            }
            case field_11043: {
                minZ += (float)inset;
                break;
            }
            case field_11035: {
                minZ += (float)(1.0 - inset);
                break;
            }
            case field_11033: {
                minY += (float)inset;
                break;
            }
            case field_11036: {
                minY += (float)(1.0 - inset);
            }
        }
        float maxX = minX;
        float maxY = minY;
        float maxZ = minZ;
        if (side.method_10166() == class_2350.class_2351.field_11051) {
            maxX += (float)width;
            maxY += (float)height;
        } else if (side.method_10166() == class_2350.class_2351.field_11048) {
            maxY += (float)height;
            maxZ += (float)width;
        } else if (side.method_10166() == class_2350.class_2351.field_11052) {
            maxX += (float)width;
            maxZ += (float)height;
        }
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, 1.0f);
            buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, 1.0f);
            float z = minZ;
            while ((double)z < (double)maxZ + 0.5) {
                buffer.method_22912(minX, minY, z).method_22915(color.r, color.g, color.b, 1.0f);
                buffer.method_22912(maxX, maxY, z).method_22915(color.r, color.g, color.b, 1.0f);
                z += 1.0f;
            }
        } else {
            buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, 1.0f);
            buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, 1.0f);
            float y = minY;
            while ((double)y < (double)maxY + 0.5) {
                buffer.method_22912(minX, y, minZ).method_22915(color.r, color.g, color.b, 1.0f);
                buffer.method_22912(maxX, y, maxZ).method_22915(color.r, color.g, color.b, 1.0f);
                y += 1.0f;
            }
        }
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }

    public static void renderInventoryOverlay(InventoryOverlay.Context inventory, class_332 drawContext) {
        InventoryOverlayScreen screen = new InventoryOverlayScreen(inventory);
        screen.method_25423(class_310.method_1551(), 0, 0);
        screen.method_25394(drawContext, 0, 0, 0.0f);
    }

    public static void renderInventoryOverlay(class_310 mc, class_332 drawContext) {
        class_1657 serverPlayer;
        class_1937 world = WorldUtils.getBestWorld((class_310)mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        if (mc.field_1724 == null) {
            return;
        }
        if (cameraEntity == mc.field_1724 && world instanceof class_3218 && (serverPlayer = world.method_18470(mc.field_1724.method_5667())) != null) {
            cameraEntity = serverPlayer;
        }
        class_239 trace = RayTraceUtils.getRayTraceFromEntity(world, cameraEntity, false);
        class_2338 pos = null;
        class_1263 inv = null;
        class_2480 shulkerBoxBlock = null;
        class_8886 crafterBlock = null;
        class_1309 entityLivingBase = null;
        if (trace.method_17783() == class_239.class_240.field_1332) {
            pos = ((class_3965)trace).method_17777();
            class_2248 blockTmp = world.method_8320(pos).method_26204();
            if (blockTmp instanceof class_2480) {
                shulkerBoxBlock = (class_2480)blockTmp;
            } else if (blockTmp instanceof class_8886) {
                crafterBlock = (class_8886)blockTmp;
            }
            inv = InventoryUtils.getInventory(world, pos);
        } else if (trace.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)trace).method_17782();
            if (entity.method_37908().field_9236 && Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                EntitiesDataManager.getInstance().requestEntity(entity.method_5628());
            }
            if (entity instanceof class_1309) {
                entityLivingBase = (class_1309)entity;
            }
            if (entity instanceof class_1263) {
                inv = (class_1263)entity;
            } else if (entity instanceof class_1646) {
                inv = ((class_1646)entity).method_35199();
            } else if (entity instanceof class_1496) {
                inv = ((IMixinAbstractHorseEntity)entity).minihud_getHorseInventory();
            }
        }
        boolean isWolf = entityLivingBase instanceof class_1493;
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        if (inv != null && inv.method_5439() > 0) {
            class_8887 cbe;
            boolean isHorse = entityLivingBase instanceof class_1496;
            int totalSlots = isHorse ? inv.method_5439() - 1 : inv.method_5439();
            int firstSlot = isHorse ? 1 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof class_1646 ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getInventoryType((class_1263)inv);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            Set lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if (crafterBlock != null && pos != null && (cbe = (class_8887)world.method_8500(pos).method_8321(pos)) != null) {
                lockedSlots = BlockUtils.getDisabledSlots((class_8887)cbe);
            }
            fi.dy.masa.malilib.render.RenderUtils.setShulkerboxBackgroundTintColor((class_2480)shulkerBoxBlock, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            if (isHorse) {
                class_1277 horseInv = new class_1277(2);
                class_1799 horseArmor = ((class_1496)entityLivingBase).method_56676();
                horseInv.method_5447(0, horseArmor != null && !horseArmor.method_7960() ? horseArmor : class_1799.field_8037);
                horseInv.method_5447(1, inv.method_5438(0));
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (class_310)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (class_310)mc, (class_332)drawContext);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)totalSlots, (class_310)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)firstSlot, (int)totalSlots, lockedSlots, (class_310)mc, (class_332)drawContext);
            }
        }
        if (isWolf) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.HORSE;
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)2);
            int rows = (int)Math.ceil(2.0 / (double)props.slotsPerRow);
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            x = xCenter - 55;
            int xInv = xCenter + 2;
            yInv = Math.min(yInv, yCenter - 92);
            class_1277 wolfInv = new class_1277(2);
            class_1799 wolfArmor = ((class_1493)entityLivingBase).method_56676();
            wolfInv.method_5447(0, wolfArmor != null && !wolfArmor.method_7960() ? wolfArmor : class_1799.field_8037);
            InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (class_310)mc);
            InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)wolfInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (class_310)mc, (class_332)drawContext);
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground((int)x, (int)y, (class_1309)entityLivingBase, (class_332)drawContext);
            InventoryOverlay.renderEquipmentStacks((class_1309)entityLivingBase, (int)x, (int)y, (class_310)mc, (class_332)drawContext);
        }
    }
}

