/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.llamalad7.mixinextras.lib.apache.commons.tuple.Pair;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.event.RenderHandler;
import fi.dy.masa.minihud.mixin.IMixinAbstractHorseEntity;
import fi.dy.masa.minihud.mixin.IMixinPiglinEntity;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2611;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3715;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4836;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class RayTraceUtils {
    private static Pair<class_2338, InventoryOverlay.Context> lastBlockEntityContext = null;
    private static Pair<Integer, InventoryOverlay.Context> lastEntityContext = null;

    @Nonnull
    public static class_239 getRayTraceFromEntity(class_1937 worldIn, class_1297 entityIn, boolean useLiquids) {
        double d;
        if (entityIn instanceof class_1657) {
            class_1657 pe = (class_1657)entityIn;
            d = pe.method_55754() + 1.0;
        } else {
            d = 5.0;
        }
        double reach = d;
        return RayTraceUtils.getRayTraceFromEntity(worldIn, entityIn, useLiquids, reach);
    }

    @Nonnull
    public static class_239 getRayTraceFromEntity(class_1937 worldIn, class_1297 entityIn, boolean useLiquids, double range) {
        class_3959.class_242 fluidMode;
        class_243 rangedLookRot;
        class_243 lookVec;
        class_243 eyesVec = new class_243(entityIn.method_23317(), entityIn.method_23318() + (double)entityIn.method_5751(), entityIn.method_23321());
        class_3959 context = new class_3959(eyesVec, lookVec = eyesVec.method_1019(rangedLookRot = entityIn.method_5828(1.0f).method_1021(range)), class_3959.class_3960.field_17558, fluidMode = useLiquids ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348, entityIn);
        class_3965 result = worldIn.method_17742(context);
        if (result == null) {
            result = class_3965.method_17778((class_243)class_243.field_1353, (class_2350)class_2350.field_11036, (class_2338)class_2338.field_10980);
        }
        class_238 bb = entityIn.method_5829().method_1009(rangedLookRot.field_1352, rangedLookRot.field_1351, rangedLookRot.field_1350).method_1009(1.0, 1.0, 1.0);
        List list = worldIn.method_8335(entityIn, bb);
        double closest = result.method_17783() == class_239.class_240.field_1332 ? eyesVec.method_1022(result.method_17784()) : Double.MAX_VALUE;
        Optional entityTrace = Optional.empty();
        class_1297 targetEntity = null;
        for (class_1297 entity : list) {
            double distance;
            bb = entity.method_5829();
            Optional traceTmp = bb.method_992(lookVec, eyesVec);
            if (!traceTmp.isPresent() || !((distance = eyesVec.method_1022((class_243)traceTmp.get())) <= closest)) continue;
            targetEntity = entity;
            entityTrace = traceTmp;
            closest = distance;
        }
        if (targetEntity != null) {
            result = new class_3966(targetEntity, (class_243)entityTrace.get());
        }
        return result;
    }

    @Nullable
    public static InventoryOverlay.Context getTargetInventory(class_310 mc, boolean newScreen) {
        class_1657 serverPlayer;
        class_1937 world = WorldUtils.getBestWorld((class_310)mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        if (mc.field_1724 == null || world == null) {
            return null;
        }
        if (cameraEntity == mc.field_1724 && world instanceof class_3218 && (serverPlayer = world.method_18470(mc.field_1724.method_5667())) != null) {
            cameraEntity = serverPlayer;
        }
        class_239 trace = RayTraceUtils.getRayTraceFromEntity(world, cameraEntity, false);
        class_2487 nbt = new class_2487();
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)trace).method_17777();
            class_2680 state = world.method_8320(pos);
            class_2248 blockTmp = state.method_26204();
            class_2586 be = null;
            if (blockTmp instanceof class_3715 && !newScreen) {
                return null;
            }
            if (blockTmp instanceof class_2343) {
                if (world instanceof class_3218) {
                    be = world.method_8500(pos).method_8321(pos);
                    if (be != null) {
                        nbt = be.method_38242((class_7225.class_7874)world.method_30349());
                    }
                } else {
                    Pair<class_2586, class_2487> pair = RenderHandler.getInstance().requestBlockEntityAt(world, pos);
                    if (pair != null) {
                        nbt = (class_2487)pair.getRight();
                        if (Configs.Generic.ENTITY_DATA_LOAD_NBT.getBooleanValue()) {
                            be = (class_2586)pair.getLeft();
                        }
                    }
                }
                InventoryOverlay.Context ctx = RayTraceUtils.getTargetInventoryFromBlock(world, pos, be, nbt);
                if (lastBlockEntityContext != null && !((class_2338)lastBlockEntityContext.getLeft()).equals((Object)pos)) {
                    lastBlockEntityContext = null;
                }
                if (ctx != null && ctx.inv() != null && !ctx.inv().method_5442()) {
                    lastBlockEntityContext = Pair.of((Object)pos, (Object)ctx);
                    return ctx;
                }
                if (lastBlockEntityContext != null && ((class_2338)lastBlockEntityContext.getLeft()).equals((Object)pos)) {
                    return (InventoryOverlay.Context)lastBlockEntityContext.getRight();
                }
            }
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)trace).method_17782();
            if (world instanceof class_3218) {
                entity.method_5786(nbt);
            } else {
                Pair<class_1297, class_2487> pair = EntitiesDataManager.getInstance().requestEntity(entity.method_5628());
                if (pair != null) {
                    nbt = (class_2487)pair.getRight();
                    if (Configs.Generic.ENTITY_DATA_LOAD_NBT.getBooleanValue()) {
                        entity = (class_1297)pair.getLeft();
                    }
                }
            }
            InventoryOverlay.Context ctx = RayTraceUtils.getTargetInventoryFromEntity(world.method_8469(entity.method_5628()), nbt);
            if (lastEntityContext != null && !((Integer)lastEntityContext.getLeft()).equals(entity.method_5628())) {
                lastEntityContext = null;
            }
            if (ctx != null && ctx.inv() != null && !ctx.inv().method_5442()) {
                lastEntityContext = Pair.of((Object)entity.method_5628(), (Object)ctx);
                return ctx;
            }
            if (ctx != null && (ctx.type() == InventoryOverlay.InventoryRenderType.WOLF || ctx.type() == InventoryOverlay.InventoryRenderType.VILLAGER || ctx.type() == InventoryOverlay.InventoryRenderType.HORSE || ctx.type() == InventoryOverlay.InventoryRenderType.PLAYER)) {
                lastEntityContext = Pair.of((Object)entity.method_5628(), (Object)ctx);
                return ctx;
            }
            if (lastEntityContext != null && ((Integer)lastEntityContext.getLeft()).equals(entity.method_5628())) {
                return (InventoryOverlay.Context)lastEntityContext.getRight();
            }
        }
        return null;
    }

    @Nullable
    public static InventoryOverlay.Context getTargetInventoryFromBlock(class_1937 world, class_2338 pos, @Nullable class_2586 be, class_2487 nbt) {
        Pair<class_1297, class_2487> enderPair;
        class_1730 enderItems;
        class_1657 player;
        class_2591 beType;
        class_1263 inv;
        if (be != null) {
            if (nbt.method_33133()) {
                nbt = be.method_38242((class_7225.class_7874)world.method_30349());
            }
            inv = InventoryUtils.getInventory((class_1937)world, (class_2338)pos);
        } else {
            Pair<class_2586, class_2487> pair;
            if (nbt.method_33133() && (pair = RenderHandler.getInstance().requestBlockEntityAt(world, pos)) != null) {
                nbt = (class_2487)pair.getRight();
                if (Configs.Generic.ENTITY_DATA_LOAD_NBT.getBooleanValue()) {
                    be = (class_2586)pair.getLeft();
                }
            }
            inv = EntitiesDataManager.getInstance().getBlockInventory(world, pos, false);
        }
        class_2591 class_25912 = beType = nbt != null ? BlockUtils.getBlockEntityTypeFromNbt((class_2487)nbt) : null;
        if ((beType != null && beType.equals(class_2591.field_11901) || be instanceof class_2611) && class_310.method_1551().field_1724 != null && (player = world.method_18470(class_310.method_1551().field_1724.method_5667())) != null && (enderItems = (enderPair = EntitiesDataManager.getInstance().requestEntity(player.method_5628())) != null && enderPair.getRight() != null && ((class_2487)enderPair.getRight()).method_10545("EnderItems") ? InventoryUtils.getPlayerEnderItemsFromNbt((class_2487)((class_2487)enderPair.getRight()), (class_7225.class_7874)world.method_30349()) : player.method_7274()) != null) {
            inv = enderItems;
        }
        if (nbt != null && !nbt.method_33133()) {
            class_1263 inv2 = InventoryUtils.getNbtInventory((class_2487)nbt, (int)(inv != null ? inv.method_5439() : -1), (class_7225.class_7874)world.method_30349());
            if (inv == null) {
                inv = inv2;
            }
        }
        if (inv == null || nbt == null) {
            return null;
        }
        return new InventoryOverlay.Context(InventoryOverlay.getBestInventoryType((class_1263)inv, (class_2487)nbt), inv, be != null ? be : world.method_8321(pos), null, nbt);
    }

    @Nullable
    public static InventoryOverlay.Context getTargetInventoryFromEntity(class_1297 entity, class_2487 nbt) {
        class_1263 inv = null;
        class_1309 entityLivingBase = null;
        if (entity instanceof class_1309) {
            entityLivingBase = (class_1309)entity;
        }
        if (entity instanceof class_1263) {
            inv = (class_1263)entity;
        } else if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            inv = new class_1277((class_1799[])player.method_31548().field_7547.toArray((Object[])new class_1799[36]));
        } else if (entity instanceof class_1646) {
            inv = ((class_1646)entity).method_35199();
        } else if (entity instanceof class_1496) {
            inv = ((IMixinAbstractHorseEntity)entity).minihud_getHorseInventory();
        } else if (entity instanceof class_4836) {
            inv = ((IMixinPiglinEntity)entity).minihud_inventory();
        }
        if (!nbt.method_33133()) {
            class_1263 inv2;
            if (inv != null && nbt.method_10545("Items") && nbt.method_10554("Items", 10).size() > 1) {
                inv2 = entity instanceof class_1496 ? InventoryUtils.getNbtInventoryHorseFix((class_2487)nbt, (int)-1, (class_7225.class_7874)entity.method_56673()) : InventoryUtils.getNbtInventory((class_2487)nbt, (int)-1, (class_7225.class_7874)entity.method_56673());
                inv = null;
            } else if (inv != null && inv.method_5439() == 1 && nbt.method_10545("SaddleItem")) {
                inv2 = InventoryUtils.getNbtInventoryHorseFix((class_2487)nbt, (int)-1, (class_7225.class_7874)entity.method_56673());
                inv = null;
            } else if (inv != null && inv.method_5439() == 8 && nbt.method_10545("Inventory") && !nbt.method_10554("Inventory", 10).isEmpty()) {
                inv2 = InventoryUtils.getNbtInventory((class_2487)nbt, (int)8, (class_7225.class_7874)entity.method_56673());
                inv = null;
            } else {
                inv2 = InventoryUtils.getNbtInventory((class_2487)nbt, (int)(inv != null ? inv.method_5439() : -1), (class_7225.class_7874)entity.method_56673());
                if (inv2 != null) {
                    inv = null;
                }
            }
            if (inv2 != null) {
                inv = inv2;
            }
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        return new InventoryOverlay.Context(inv != null ? InventoryOverlay.getBestInventoryType((class_1263)inv, (class_2487)nbt) : InventoryOverlay.getInventoryType((class_2487)nbt), inv, null, entityLivingBase, nbt);
    }
}

