/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.gammautils;

import io.github.sjouwer.gammautils.GammaUtils;
import io.github.sjouwer.gammautils.config.ModConfig;
import io.github.sjouwer.gammautils.statuseffect.StatusEffectManager;
import io.github.sjouwer.gammautils.util.InfoProvider;
import io.github.sjouwer.gammautils.util.LightLevelUtil;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7172;

public class GammaManager {
    private static final class_310 client = class_310.method_1551();
    private static final class_7172<Double> gamma = GammaManager.client.field_1690.method_42473();
    private static final ModConfig.GammaSettings config = GammaUtils.getConfig().gamma;
    private static Timer transitionTimer = null;
    private static double dynamicGammaTarget = Double.NaN;

    private GammaManager() {
    }

    public static double getGamma() {
        return (Double)gamma.method_41753();
    }

    public static int getGammaPercentage() {
        return (int)Math.round((Double)gamma.method_41753() * 100.0);
    }

    public static void toggleGamma() {
        double newValue = ((Double)gamma.method_41753()).doubleValue() == config.getDefaultStrength() ? config.getToggledStrength() : config.getDefaultStrength();
        dynamicGammaTarget = Double.NaN;
        GammaManager.setGamma(newValue, true, true);
    }

    public static void increaseGamma(double value) {
        double newValue = (Double)gamma.method_41753();
        GammaManager.setGamma(newValue += value == 0.0 ? config.getStepStrength() : value, false, true);
    }

    public static void decreaseGamma(double value) {
        double newValue = (Double)gamma.method_41753();
        GammaManager.setGamma(newValue -= value == 0.0 ? config.getStepStrength() : value, false, true);
    }

    public static void minGamma() {
        GammaManager.setGamma(config.getMinimumStrength(), true, true);
    }

    public static void maxGamma() {
        GammaManager.setGamma(config.getMaximumStrength(), true, true);
    }

    public static void setDimensionPreference() {
        if (GammaManager.client.field_1687 == null || !config.isDimensionPreferenceEnabled()) {
            return;
        }
        class_5321 dimension = GammaManager.client.field_1687.method_27983();
        if (dimension.equals(class_1937.field_25179)) {
            GammaManager.setGamma(config.getOverworldPreference(), false, false);
        } else if (dimension.equals(class_1937.field_25180)) {
            GammaManager.setGamma(config.getNetherPreference(), false, false);
        } else if (dimension.equals(class_1937.field_25181)) {
            GammaManager.setGamma(config.getEndPreference(), false, false);
        }
    }

    public static void setDynamicGamma() {
        if (!config.isDynamicGammaEnabled()) {
            return;
        }
        double lightLevel = LightLevelUtil.getAverageLightLevel(config.getDynamicAveragingLightRange());
        double step = (config.getMaxDynamicStrength() - config.getMinDynamicStrength()) / 15.0;
        double target = config.getMinDynamicStrength() + step * (15.0 - lightLevel);
        if (dynamicGammaTarget != target) {
            dynamicGammaTarget = target;
            GammaManager.setGamma(target, true, false, true);
        }
    }

    public static void setGamma(double newValue, boolean smoothTransition, boolean showMessage) {
        if (config.isDynamicGammaEnabled()) {
            if (showMessage) {
                class_5250 message = class_2561.method_43471((String)"text.gammautils.message.incompatibleWithDynamicGamma");
                InfoProvider.sendMessage((class_2561)message);
            }
            return;
        }
        GammaManager.setGamma(newValue, smoothTransition, showMessage, false);
    }

    private static void setGamma(double newValue, boolean smoothTransition, boolean showMessage, boolean dynamic) {
        if (transitionTimer != null) {
            transitionTimer.cancel();
        }
        if (config.isLimiterEnabled() && config.getMaximumStrength() > config.getMinimumStrength()) {
            newValue = Math.clamp(newValue, config.getMinimumStrength(), config.getMaximumStrength());
        }
        if (smoothTransition && (config.isSmoothTransitionEnabled() || dynamic)) {
            double valueChangePerTick = config.getTransitionSpeed(dynamic) / 100.0;
            if (newValue < (Double)gamma.method_41753()) {
                valueChangePerTick *= -1.0;
            }
            GammaManager.startTransitionTimer(newValue, valueChangePerTick, showMessage);
        } else {
            gamma.method_41748((Object)newValue);
            StatusEffectManager.updateGammaStatusEffect();
            if (showMessage) {
                InfoProvider.showGammaHudMessage();
            }
        }
        if (config.isToggleUpdateEnabled() && newValue != config.getDefaultStrength()) {
            config.setToggledStrength(newValue);
        }
    }

    protected static void toggleDynamicGamma() {
        boolean newStatus = !config.isDynamicGammaEnabled();
        config.setDynamicGammaStatus(newStatus);
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.dynamicGamma" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    protected static void toggleStatusEffect() {
        boolean newStatus = !config.isStatusEffectEnabled();
        config.setStatusEffectStatus(newStatus);
        StatusEffectManager.updateGammaStatusEffect();
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.statusEffectGamma" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    protected static void toggleSmoothTransition() {
        boolean newStatus = !config.isSmoothTransitionEnabled();
        config.setSmoothTransitionStatus(newStatus);
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.transitionGamma" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    private static void startTransitionTimer(final double newValue, final double valueChangePerTick, final boolean showMessage) {
        transitionTimer = new Timer();
        transitionTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                double nextValue = (Double)gamma.method_41753() + valueChangePerTick;
                if (valueChangePerTick > 0.0 && nextValue >= newValue || valueChangePerTick < 0.0 && nextValue <= newValue) {
                    transitionTimer.cancel();
                    gamma.method_41748((Object)newValue);
                    StatusEffectManager.updateGammaStatusEffect();
                } else {
                    gamma.method_41748((Object)nextValue);
                }
                if (showMessage) {
                    InfoProvider.showGammaHudMessage();
                }
            }
        }, 0L, 10L);
    }
}

