/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.gammautils;

import io.github.sjouwer.gammautils.GammaUtils;
import io.github.sjouwer.gammautils.config.ModConfig;
import io.github.sjouwer.gammautils.statuseffect.StatusEffectManager;
import io.github.sjouwer.gammautils.util.InfoProvider;
import io.github.sjouwer.gammautils.util.LightLevelUtil;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class NightVisionManager {
    private static final ModConfig.NightVisionSettings config = GammaUtils.getConfig().nightVision;
    private static final class_310 client = class_310.method_1551();
    private static Timer transitionTimer = null;
    private static double dynamicNightVisionTarget = Double.NaN;

    private NightVisionManager() {
    }

    public static int getNightVisionPercentage() {
        return (int)Math.round(config.getStrength());
    }

    public static void toggleNightVision() {
        if (config.isEnabled()) {
            NightVisionManager.disableNightVision();
        } else {
            NightVisionManager.enableNightVision();
        }
    }

    public static void enableAndOrSetNightVision(int newValue) {
        if (config.isEnabled()) {
            NightVisionManager.setNightVision(newValue, true, false, true);
        } else {
            NightVisionManager.enableNightVision(newValue);
        }
    }

    public static void enableNightVision() {
        NightVisionManager.enableNightVision(config.getToggledStrength());
    }

    private static void enableNightVision(int newValue) {
        NightVisionManager.setNightVision(0.0, false, false, false);
        NightVisionManager.setNightVisionStatus(true);
        if (config.isDynamicNightVisionEnabled()) {
            InfoProvider.showDynamicNightVisionHudMessage(true);
            dynamicNightVisionTarget = Double.NaN;
            NightVisionManager.setDynamicNightVision();
        } else {
            NightVisionManager.setNightVision(newValue, true, false, true);
        }
    }

    public static void disableNightVision() {
        if (config.isDynamicNightVisionEnabled()) {
            InfoProvider.showDynamicNightVisionHudMessage(false);
            NightVisionManager.setNightVision(0.0, true, true, false, true);
        } else {
            NightVisionManager.setNightVision(0.0, true, true, true);
        }
    }

    public static void increaseNightVision(int value) {
        double newValue = config.getStrength();
        NightVisionManager.setNightVision(newValue += value == 0 ? (double)config.getStepStrength() : (double)value, false, false, true);
    }

    public static void decreaseNightVision(int value) {
        double newValue = config.getStrength();
        NightVisionManager.setNightVision(newValue -= value == 0 ? (double)config.getStepStrength() : (double)value, false, false, true);
    }

    public static void setDimensionPreference() {
        if (NightVisionManager.client.field_1687 == null || !config.isDimensionPreferenceEnabled()) {
            return;
        }
        class_5321 dimension = NightVisionManager.client.field_1687.method_27983();
        if (dimension.equals(class_1937.field_25179)) {
            NightVisionManager.setNightVision(config.getOverworldPreference(), false, false, false);
        } else if (dimension.equals(class_1937.field_25180)) {
            NightVisionManager.setNightVision(config.getNetherPreference(), false, false, false);
        } else if (dimension.equals(class_1937.field_25181)) {
            NightVisionManager.setNightVision(config.getEndPreference(), false, false, false);
        }
    }

    public static void setDynamicNightVision() {
        if (!config.isDynamicNightVisionEnabled()) {
            return;
        }
        double lightLevel = LightLevelUtil.getAverageLightLevel(config.getDynamicAveragingLightRange());
        double step = (double)(config.getMaxDynamicStrength() - config.getMinDynamicStrength()) / 15.0;
        double target = (double)config.getMinDynamicStrength() + step * (15.0 - lightLevel);
        if (dynamicNightVisionTarget != target) {
            dynamicNightVisionTarget = target;
            NightVisionManager.setNightVision(target, true, false, false, true);
        }
    }

    public static void setNightVision(double newValue, boolean smoothTransition, boolean disable, boolean showMessage) {
        if (config.isDynamicNightVisionEnabled()) {
            if (showMessage) {
                class_5250 message = class_2561.method_43471((String)"text.gammautils.message.incompatibleWithDynamicNightVision");
                InfoProvider.sendMessage((class_2561)message);
            }
            return;
        }
        NightVisionManager.setNightVision(newValue, smoothTransition, disable, showMessage, false);
    }

    private static void setNightVision(double newValue, boolean smoothTransition, boolean disable, boolean showMessage, boolean dynamic) {
        if (transitionTimer != null) {
            transitionTimer.cancel();
        }
        if (config.isLimiterEnabled() && config.getMaximumStrength() > config.getMinimumStrength()) {
            newValue = Math.clamp(newValue, (double)config.getMinimumStrength(), (double)config.getMaximumStrength());
        }
        if (smoothTransition && (config.isSmoothTransitionEnabled() || dynamic)) {
            double valueChangePerTick = config.getTransitionSpeed(dynamic) / 100.0;
            if (newValue < config.getStrength()) {
                valueChangePerTick *= -1.0;
            }
            NightVisionManager.startTransitionTimer(newValue, valueChangePerTick, disable, showMessage);
        } else {
            config.setStrength(newValue);
            if (disable) {
                NightVisionManager.setNightVisionStatus(false);
            }
            if (showMessage) {
                InfoProvider.showNightVisionStatusHudMessage();
            }
        }
        if (config.isToggleUpdateEnabled() && newValue != 0.0) {
            config.setToggledStrength((int)Math.round(newValue));
        }
    }

    protected static void toggleDynamicNightVision() {
        boolean newStatus = !config.isDynamicNightVisionEnabled();
        config.setDynamicNightVisionStatus(newStatus);
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.dynamicNightVision" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    protected static void toggleStatusEffect() {
        boolean newStatus = !config.isStatusEffectEnabled();
        config.setStatusEffectStatus(newStatus);
        StatusEffectManager.updateNightVision();
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.statusEffectNightVision" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    protected static void toggleSmoothTransition() {
        boolean newStatus = !config.isSmoothTransitionEnabled();
        config.setSmoothTransitionStatus(newStatus);
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.transitionNightVision" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    private static void setNightVisionStatus(boolean status) {
        config.setStatus(status);
        StatusEffectManager.updateNightVision();
    }

    private static void startTransitionTimer(final double newValue, final double valueChangePerTick, final boolean disable, final boolean showMessage) {
        transitionTimer = new Timer();
        transitionTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                double nextValue = config.getStrength() + valueChangePerTick;
                if (valueChangePerTick > 0.0 && nextValue >= newValue || valueChangePerTick < 0.0 && nextValue <= newValue) {
                    transitionTimer.cancel();
                    config.setStrength(newValue);
                    if (disable) {
                        NightVisionManager.setNightVisionStatus(false);
                    }
                } else {
                    config.setStrength(nextValue);
                }
                if (showMessage) {
                    InfoProvider.showNightVisionStatusHudMessage();
                }
            }
        }, 0L, 10L);
    }
}

