import cv2
import numpy as np
import sys

for filename in sys.argv[1:]:
    if not filename.endswith(".png"):
        continue
    # filename = sys.argv[1]
    print("Processing",  filename)

    img = cv2.imread(filename, cv2.IMREAD_UNCHANGED)
    if len(np.shape(img)) == 2:
        img = cv2.cvtColor(img, cv2.COLOR_GRAY2RGBA)

    def col(hex, alpha):
        if hex[0] == '#':
            hex = hex[1:]

        r = int(hex[0:2], 16)
        g = int(hex[2:4], 16)
        b = int(hex[4:6], 16)

        if alpha:
            return [r, g, b, 255]
        else:
            return [r, g, b]

    def replace(img, fr, to):
        hasAlpha = np.shape(img)[-1] == 4
        img[np.where((np.all(img == col(fr, hasAlpha),axis = -1)))] = col(to, hasAlpha)


    # Background color
    replace(img, "#c6c6c6", "#3e3e3e")
    # Inner border LR
    replace(img, "#ffffff", "#505050")
    # Inner border color
    replace(img, "#8b8b8b", "#2c2c2c")
    replace(img, "#8c8c8c", "#2c2c2c")
    # Inv slots TL
    replace(img, "#adadad", "#111111")
    replace(img, "#373737", "#000000")
    replace(img, "#737373", "#505050")

    # Outer border
    replace(img, "#555555", "#1b1b1b")

    cv2.imwrite(filename, img)