/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.autcomplete;

import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.SearchablesConstants;
import com.blamejared.searchables.api.TokenRange;
import com.blamejared.searchables.api.autcomplete.AutoComplete;
import com.blamejared.searchables.api.autcomplete.CompletionVisitor;
import com.blamejared.searchables.api.formatter.FormattingVisitor;
import com.blamejared.searchables.mixin.AccessEditBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import org.jetbrains.annotations.Nullable;

public class AutoCompletingEditBox<T>
extends class_342 {
    private final FormattingVisitor formattingVisitor;
    private final CompletionVisitor completionVisitor;
    private final DelegatingConsumers<String> responders = new DelegatingConsumers();
    private final AutoComplete<T> autoComplete;

    public AutoCompletingEditBox(class_327 font, int x, int y, int width, int height, class_2561 message, SearchableType<T> type, Supplier<List<T>> entries) {
        this(font, x, y, width, height, null, message, type, entries);
    }

    public AutoCompletingEditBox(class_327 font, int x, int y, int width, int height, @Nullable class_342 thisBox, class_2561 message, SearchableType<T> type, Supplier<List<T>> entries) {
        super(font, x, y, width, height, thisBox, message);
        this.method_1880(Integer.MAX_VALUE);
        this.formattingVisitor = new FormattingVisitor(type);
        this.completionVisitor = new CompletionVisitor();
        Objects.requireNonNull(font);
        this.autoComplete = new AutoComplete<T>(type, this, entries, x, y + 2 + height, width, 9 + 2);
        this.method_47404(SearchablesConstants.COMPONENT_SEARCH);
        this.method_1854(this.formattingVisitor);
        this.method_1863(this.responders);
        this.addResponder(this.formattingVisitor);
        this.addResponder(this.completionVisitor);
        this.addResponder(this.autoComplete);
    }

    public boolean method_25405(double xpos, double ypos) {
        return super.method_25405(xpos, ypos) || this.autoComplete.method_25405(xpos, ypos);
    }

    public boolean method_25402(double xpos, double ypos, int button) {
        if (this.method_25370() && this.autoComplete.method_25402(xpos, ypos, button)) {
            return true;
        }
        if ((this.method_25405(xpos, ypos) || this.autoComplete().method_25405(xpos, ypos)) && button == 1) {
            this.method_1852("");
            return true;
        }
        return super.method_25402(xpos, ypos, button);
    }

    public boolean method_25404(int key, int scancode, int mods) {
        switch (key) {
            case 267: {
                this.autoComplete.scrollDown(this.autoComplete().maxSuggestions());
                return true;
            }
            case 264: {
                this.autoComplete().scrollDown();
                return true;
            }
            case 266: {
                this.autoComplete.scrollUp(this.autoComplete().maxSuggestions());
                return true;
            }
            case 265: {
                this.autoComplete().scrollUp();
                return true;
            }
            case 257: {
                this.autoComplete().insertSuggestion();
                return true;
            }
        }
        return super.method_25404(key, scancode, mods);
    }

    public void deleteChars(TokenRange range) {
        if (!this.method_1882().isEmpty() && !range.isEmpty()) {
            String newValue = range.delete(this.method_1882());
            if (this.getFilter().test(newValue)) {
                this.method_1852(newValue);
                this.method_1883(range.start(), false);
            }
        }
    }

    public Predicate<String> getFilter() {
        return ((AccessEditBox)((Object)this)).searchables$getFilter();
    }

    @Nullable
    public Consumer<String> getResponder() {
        return ((AccessEditBox)((Object)this)).searchables$getResponder();
    }

    @Deprecated
    public void method_1863(Consumer<String> responder) {
        if (this.getResponder() == null) {
            super.method_1863(this.responders);
        } else {
            this.addResponder(responder);
        }
    }

    public void addResponder(Consumer<String> responder) {
        this.responders.addConsumer(responder);
    }

    public FormattingVisitor formattingVisitor() {
        return this.formattingVisitor;
    }

    public CompletionVisitor completionVisitor() {
        return this.completionVisitor;
    }

    public AutoComplete<T> autoComplete() {
        return this.autoComplete;
    }

    private static class DelegatingConsumers<T>
    implements Consumer<T> {
        private final List<Consumer<T>> consumers = new ArrayList<Consumer<T>>();

        private DelegatingConsumers() {
        }

        @Override
        public void accept(T t) {
            this.consumers.forEach(tConsumer -> tConsumer.accept(t));
        }

        public void addConsumer(Consumer<T> consumer) {
            this.consumers.add(consumer);
        }
    }
}

