/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import java.util.List;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.component.ItemComponent;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

@ApiSide.ClientOnly
public class ItemListComponent
implements ITooltipComponent.HorizontalGrowing {
    private final List<class_1799> items;
    private final int maxHeight;
    private final float scale;
    private int gridWidth;
    private int gridHeight;
    private int maxIndex;

    public ItemListComponent(List<class_1799> items) {
        this(items, 3);
    }

    public ItemListComponent(List<class_1799> items, int maxHeight) {
        this(items, maxHeight, 1.0f);
    }

    public ItemListComponent(List<class_1799> items, int maxHeight, float scale) {
        this.items = items;
        this.maxHeight = maxHeight;
        this.scale = scale;
    }

    @Override
    public int getMinimalWidth() {
        return (int)((float)(Math.min(this.items.size(), 9) * 18) * this.scale);
    }

    @Override
    public void setGrownWidth(int grownWidth) {
        this.gridWidth = class_3532.method_15386((float)((float)grownWidth / (18.0f * this.scale)));
        this.gridHeight = this.items.isEmpty() ? 0 : Math.min(class_3532.method_38788((int)this.items.size(), (int)this.gridWidth), this.maxHeight);
        this.maxIndex = this.gridWidth * this.gridHeight - 1;
    }

    @Override
    public int getHeight() {
        return class_3532.method_15386((float)((float)(this.gridHeight * 18) * this.scale));
    }

    @Override
    public void render(class_332 ctx, int x, int y, class_9779 delta) {
        Matrix3x2fStack pose = ctx.method_51448();
        pose.pushMatrix();
        pose.translate((float)x, (float)y);
        pose.scale(this.scale, this.scale);
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 item = this.items.get(i);
            int ix = 18 * (i % this.gridWidth) + 1;
            int iy = 18 * (i / this.gridWidth) + 1;
            ctx.method_51427(item, ix, iy);
            ItemComponent.renderItemDecorations(ctx, item, ix, iy);
            if (i == this.maxIndex) break;
        }
        pose.popMatrix();
    }
}

