/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget;

import com.google.common.collect.ImmutableList;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.apache.commons.lang3.StringUtils;

public class CategoryEntry
extends ConfigListWidget.Entry {
    private static final IJsonConfig<Map<String, Boolean>> STATES = IJsonConfig.of(new TypeToken<Map<String, Boolean>>(){}).file("waila/category_entries").json5().factory(HashMap::new).commenter(() -> p -> !p.isEmpty() ? null : "This config controls the category entries collapsed state.\nYou shouldn't edit this config by hand.\n").build();
    public final class_2561 title;
    private final String key;
    private final class_4185 collapseButton;
    private final class_4185 expandAllButton;
    private final List<ConfigListWidget.Entry> children = new ArrayList<ConfigListWidget.Entry>();
    private boolean collapsed;
    private boolean hasNested = false;
    private boolean filterMatchParent = false;

    public CategoryEntry(String title) {
        this.key = title;
        this.title = class_2561.method_43471((String)title).method_27692(class_124.field_1067);
        this.collapseButton = DisplayUtil.createButton(0, 0, 12, 12, class_5244.field_39003, b -> this.toggleCollapse());
        this.expandAllButton = DisplayUtil.createButton(0, 0, 20, 12, (class_2561)class_2561.method_43470((String)"++"), b -> {
            this.setCollapse(false, true);
            this.list.init();
            this.list.method_25395((class_364)this);
            this.method_25395((class_364)b);
        });
        this.expandAllButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"config.waila.expand_all")));
        this.collapsed = Boolean.TRUE.equals(STATES.get().putIfAbsent(this.key, false));
        STATES.save();
    }

    public CategoryEntry with(ConfigListWidget.Entry child) {
        child.category = this;
        child.categoryDepth = this.categoryDepth + 1;
        this.children.add(child);
        if (child instanceof CategoryEntry) {
            this.hasNested = true;
        }
        return this;
    }

    @Override
    public int init() {
        boolean expand = !this.collapsed || this.list.filter != null;
        this.collapseButton.method_25355((class_2561)class_2561.method_43470((String)(!expand ? "+" : "-")));
        int added = 1;
        boolean matchCategory = StringUtils.containsIgnoreCase((CharSequence)this.title.getString(), (CharSequence)this.list.filter);
        if (this.category != null) {
            boolean bl = matchCategory = matchCategory || this.filterMatchParent;
        }
        if (expand) {
            for (ConfigListWidget.Entry child : this.children) {
                if (child instanceof CategoryEntry) {
                    CategoryEntry nest = (CategoryEntry)child;
                    nest.filterMatchParent = matchCategory;
                }
                if (!matchCategory && this.list.splitFilter != null && !child.match(this.list.splitFilter)) continue;
                this.list.add(this.index + added, child);
                added += child.init(this.list, this.index + added);
            }
        }
        return added;
    }

    @Override
    public void clear(ConfigListWidget list) {
        list.method_25396().removeIf(it -> it.category == this);
        for (ConfigListWidget.Entry child : this.children) {
            child.clear(list);
        }
    }

    private void setCollapse(boolean collapsed, boolean deep) {
        this.collapsed = collapsed;
        STATES.get().put(this.key, collapsed);
        STATES.save();
        if (deep) {
            for (ConfigListWidget.Entry child : this.children) {
                if (!(child instanceof CategoryEntry)) continue;
                CategoryEntry entry = (CategoryEntry)child;
                entry.setCollapse(collapsed, true);
            }
        }
    }

    private void toggleCollapse() {
        if (!this.collapsed) {
            this.setCollapse(true, true);
        } else {
            this.setCollapse(false, false);
        }
        this.list.init();
        this.list.method_25395((class_364)this);
        this.method_25395((class_364)this.collapseButton);
    }

    @Override
    protected void gatherChildren(ImmutableList.Builder<class_364> children) {
        children.add((Object)this.collapseButton);
        children.add((Object)this.expandAllButton);
    }

    @Override
    protected void drawEntry(class_332 ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        int buttonY = rowTop + (height - this.collapseButton.method_25364()) / 2;
        boolean hasFilter = this.list.filter != null;
        this.collapseButton.field_22763 = !hasFilter;
        this.collapseButton.method_46421(rowLeft);
        this.collapseButton.method_46419(buttonY);
        this.collapseButton.method_25394(ctx, mouseX, mouseY, deltaTime);
        class_327 class_3272 = this.client.field_1772;
        int n = rowLeft + this.collapseButton.method_25368() + 4;
        Objects.requireNonNull(this.client.field_1772);
        ctx.method_27535(class_3272, this.title, n, rowTop + (height - 9) / 2 + 1, -1);
        boolean bl = this.expandAllButton.field_22763 = this.hasNested && !hasFilter;
        if (this.expandAllButton.field_22763) {
            this.expandAllButton.method_46421(rowLeft + width - this.expandAllButton.method_25368());
            this.expandAllButton.method_46419(buttonY);
            this.expandAllButton.method_25394(ctx, mouseX, mouseY, deltaTime);
        }
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        sb.append(this.title.getString());
        if (!this.children.isEmpty()) {
            sb.append(" ");
            for (ConfigListWidget.Entry child : this.children) {
                child.buildSearchKey(sb);
            }
        }
    }
}

