/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.gammautils;

import io.github.sjouwer.gammautils.GammaUtils;
import io.github.sjouwer.gammautils.config.ModConfig;
import io.github.sjouwer.gammautils.statuseffect.StatusEffectManager;
import io.github.sjouwer.gammautils.util.InfoProvider;
import io.github.sjouwer.gammautils.util.LightLevelUtil;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class GammaManager {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig.GammaSettings gamma = GammaUtils.getConfig().gamma;
    private static Timer transitionTimer = null;
    private static double dynamicGammaTarget = Double.NaN;

    private GammaManager() {
    }

    public static double getGamma() {
        return gamma.getValue();
    }

    public static int getGammaPercentage() {
        return (int)Math.round(gamma.getValue() * 100.0);
    }

    public static void toggleGamma() {
        if (gamma.isDynamicEnabled()) {
            GammaManager.toggleDynamicPause();
            return;
        }
        double newValue = gamma.getValue() == gamma.getDefaultValue() ? gamma.getToggledValue() : gamma.getDefaultValue();
        dynamicGammaTarget = Double.NaN;
        GammaManager.setGamma(newValue, true, true);
    }

    public static void toggleDynamicPause() {
        gamma.toggleDynamicPause();
        InfoProvider.showDynamicGammaHudMessage();
        if (gamma.isDynamicPaused()) {
            dynamicGammaTarget = Double.NaN;
            GammaManager.setGamma(gamma.getDefaultValue(), true, false, true);
        }
    }

    public static void increaseGamma(double value) {
        double newValue = gamma.getValue();
        GammaManager.setGamma(newValue += value == 0.0 ? gamma.getStepValue() : value, false, true);
    }

    public static void decreaseGamma(double value) {
        double newValue = gamma.getValue();
        GammaManager.setGamma(newValue -= value == 0.0 ? gamma.getStepValue() : value, false, true);
    }

    public static void minGamma() {
        GammaManager.setGamma(gamma.getMinimumStrength(), true, true);
    }

    public static void maxGamma() {
        GammaManager.setGamma(gamma.getMaximumStrength(), true, true);
    }

    public static void setDimensionPreference() {
        if (GammaManager.client.field_1687 == null || !gamma.isDimensionPreferenceEnabled()) {
            return;
        }
        class_5321 dimension = GammaManager.client.field_1687.method_27983();
        if (dimension.equals(class_1937.field_25179)) {
            GammaManager.setGamma(gamma.getOverworldPreference(), false, false);
        } else if (dimension.equals(class_1937.field_25180)) {
            GammaManager.setGamma(gamma.getNetherPreference(), false, false);
        } else if (dimension.equals(class_1937.field_25181)) {
            GammaManager.setGamma(gamma.getEndPreference(), false, false);
        }
    }

    public static void setDynamicGamma() {
        if (!gamma.isDynamicEnabled() || gamma.isDynamicPaused()) {
            return;
        }
        double lightLevel = LightLevelUtil.getAverageLightLevel(gamma.getDynamicAveragingLightRange(), gamma.getSkyBrightnessOverride());
        double step = (gamma.getMaxDynamicStrength() - gamma.getMinDynamicStrength()) / 15.0;
        double target = gamma.getMinDynamicStrength() + step * (15.0 - lightLevel);
        if (dynamicGammaTarget != target) {
            dynamicGammaTarget = target;
            GammaManager.setGamma(target, true, false, true);
        }
    }

    public static void setGamma(double newValue, boolean smoothTransition, boolean showMessage) {
        if (gamma.isDynamicEnabled()) {
            if (showMessage) {
                class_5250 message = class_2561.method_43471((String)"text.gammautils.message.incompatibleWithDynamicGamma");
                InfoProvider.sendMessage((class_2561)message);
            }
            return;
        }
        GammaManager.setGamma(newValue, smoothTransition, showMessage, false);
    }

    private static void setGamma(double newValue, boolean smoothTransition, boolean showMessage, boolean dynamic) {
        if (transitionTimer != null) {
            transitionTimer.cancel();
        }
        if (gamma.isLimiterEnabled() && gamma.getMaximumStrength() > gamma.getMinimumStrength()) {
            newValue = Math.clamp(newValue, gamma.getMinimumStrength(), gamma.getMaximumStrength());
        }
        if (smoothTransition && (gamma.isSmoothTransitionEnabled() || dynamic)) {
            double valueChangePerTick = gamma.getTransitionSpeed(dynamic) / 100.0;
            if (newValue < gamma.getValue()) {
                valueChangePerTick *= -1.0;
            }
            GammaManager.startTransitionTimer(newValue, valueChangePerTick, showMessage);
        } else {
            gamma.setValue(newValue);
            StatusEffectManager.updateGammaStatusEffect();
            if (showMessage) {
                InfoProvider.showGammaHudMessage();
            }
        }
        if (gamma.isToggleUpdateEnabled() && newValue != gamma.getDefaultValue()) {
            gamma.setToggledValue(newValue);
        }
    }

    protected static void toggleDynamicGamma() {
        boolean newStatus = !gamma.isDynamicEnabled();
        gamma.setDynamicStatus(newStatus);
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.dynamicGamma" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    protected static void toggleStatusEffect() {
        boolean newStatus = !gamma.isStatusEffectEnabled();
        gamma.setStatusEffectStatus(newStatus);
        StatusEffectManager.updateGammaStatusEffect();
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.statusEffectGamma" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    protected static void toggleSmoothTransition() {
        boolean newStatus = !gamma.isSmoothTransitionEnabled();
        gamma.setSmoothTransitionStatus(newStatus);
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.transitionGamma" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    private static void startTransitionTimer(final double newValue, final double valueChangePerTick, final boolean showMessage) {
        transitionTimer = new Timer();
        transitionTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                double nextValue = gamma.getValue() + valueChangePerTick;
                if (valueChangePerTick > 0.0 && nextValue >= newValue || valueChangePerTick < 0.0 && nextValue <= newValue) {
                    transitionTimer.cancel();
                    gamma.setValue(newValue);
                } else {
                    gamma.setValue(nextValue);
                }
                StatusEffectManager.updateGammaStatusEffect();
                if (showMessage) {
                    InfoProvider.showGammaHudMessage();
                }
            }
        }, 0L, 10L);
    }
}

