/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.gammautils;

import io.github.sjouwer.gammautils.GammaUtils;
import io.github.sjouwer.gammautils.config.ModConfig;
import io.github.sjouwer.gammautils.statuseffect.StatusEffectManager;
import io.github.sjouwer.gammautils.util.InfoProvider;
import io.github.sjouwer.gammautils.util.LightLevelUtil;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class NightVisionManager {
    private static final ModConfig.NightVisionSettings nightVision = GammaUtils.getConfig().nightVision;
    private static final class_310 client = class_310.method_1551();
    private static Timer transitionTimer = null;
    private static double dynamicNightVisionTarget = Double.NaN;

    private NightVisionManager() {
    }

    public static int getNightVisionPercentage() {
        return (int)Math.round(nightVision.getValue());
    }

    public static void toggleNightVision() {
        if (nightVision.isDynamicEnabled()) {
            NightVisionManager.toggleDynamicPause();
            return;
        }
        if (nightVision.isEnabled()) {
            NightVisionManager.disableNightVision();
        } else {
            NightVisionManager.enableNightVision();
        }
    }

    public static void toggleDynamicPause() {
        nightVision.toggleDynamicPause();
        InfoProvider.showDynamicNightVisionHudMessage();
        if (nightVision.isDynamicPaused()) {
            dynamicNightVisionTarget = Double.NaN;
            NightVisionManager.setNightVision(0.0, true, false, true);
        }
    }

    public static void enableAndOrSetNightVision(int newValue) {
        if (nightVision.isEnabled()) {
            NightVisionManager.setNightVision(newValue, true, true);
        } else {
            NightVisionManager.enableNightVision(newValue);
        }
    }

    public static void enableNightVision() {
        NightVisionManager.enableNightVision(nightVision.getToggledValue());
    }

    private static void enableNightVision(int newValue) {
        NightVisionManager.setNightVision(0.0, false, false);
        NightVisionManager.setNightVisionStatus(true);
        NightVisionManager.setNightVision(newValue, true, true);
    }

    public static void disableNightVision() {
        NightVisionManager.setNightVision(0.0, true, true);
    }

    public static void increaseNightVision(int value) {
        double newValue = nightVision.getValue();
        NightVisionManager.setNightVision(newValue += value == 0 ? (double)nightVision.getStepValue() : (double)value, false, true);
    }

    public static void decreaseNightVision(int value) {
        double newValue = nightVision.getValue();
        NightVisionManager.setNightVision(newValue -= value == 0 ? (double)nightVision.getStepValue() : (double)value, false, true);
    }

    public static void setDimensionPreference() {
        if (NightVisionManager.client.field_1687 == null || !nightVision.isDimensionPreferenceEnabled()) {
            return;
        }
        class_5321 dimension = NightVisionManager.client.field_1687.method_27983();
        if (dimension.equals(class_1937.field_25179)) {
            NightVisionManager.setNightVision(nightVision.getOverworldPreference(), false, false);
        } else if (dimension.equals(class_1937.field_25180)) {
            NightVisionManager.setNightVision(nightVision.getNetherPreference(), false, false);
        } else if (dimension.equals(class_1937.field_25181)) {
            NightVisionManager.setNightVision(nightVision.getEndPreference(), false, false);
        }
    }

    public static void setDynamicNightVision() {
        if (!nightVision.isDynamicEnabled() || nightVision.isDynamicPaused()) {
            return;
        }
        double lightLevel = LightLevelUtil.getAverageLightLevel(nightVision.getDynamicAveragingLightRange(), nightVision.getSkyBrightnessOverride());
        double step = (double)(nightVision.getMaxDynamicStrength() - nightVision.getMinDynamicStrength()) / 15.0;
        double target = (double)nightVision.getMinDynamicStrength() + step * (15.0 - lightLevel);
        if (dynamicNightVisionTarget != target) {
            dynamicNightVisionTarget = target;
            NightVisionManager.setNightVision(target, true, false, true);
        }
    }

    public static void setNightVision(double newValue, boolean smoothTransition, boolean showMessage) {
        if (nightVision.isDynamicEnabled()) {
            if (showMessage) {
                class_5250 message = class_2561.method_43471((String)"text.gammautils.message.incompatibleWithDynamicNightVision");
                InfoProvider.sendMessage((class_2561)message);
            }
            return;
        }
        NightVisionManager.setNightVision(newValue, smoothTransition, showMessage, false);
    }

    private static void setNightVision(double newValue, boolean smoothTransition, boolean showMessage, boolean dynamic) {
        if (transitionTimer != null) {
            transitionTimer.cancel();
        }
        if (nightVision.isLimiterEnabled() && nightVision.getMaximumStrength() > nightVision.getMinimumStrength()) {
            newValue = Math.clamp(newValue, (double)nightVision.getMinimumStrength(), (double)nightVision.getMaximumStrength());
        }
        if (smoothTransition && (nightVision.isSmoothTransitionEnabled() || dynamic)) {
            double valueChangePerTick = nightVision.getTransitionSpeed(dynamic) / 100.0;
            if (newValue < nightVision.getValue()) {
                valueChangePerTick *= -1.0;
            }
            NightVisionManager.startTransitionTimer(newValue, valueChangePerTick, showMessage);
        } else {
            nightVision.setValue(newValue);
            if (newValue == 0.0) {
                NightVisionManager.setNightVisionStatus(false);
            }
            if (showMessage) {
                InfoProvider.showNightVisionStatusHudMessage();
            }
        }
        if (nightVision.isToggleUpdateEnabled() && newValue != 0.0) {
            nightVision.setToggledValue((int)Math.round(newValue));
        }
    }

    protected static void toggleDynamicNightVision() {
        boolean newStatus = !nightVision.isDynamicEnabled();
        nightVision.setDynamicStatus(newStatus);
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.dynamicNightVision" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    protected static void toggleStatusEffect() {
        boolean newStatus = !nightVision.isStatusEffectEnabled();
        nightVision.setStatusEffectStatus(newStatus);
        StatusEffectManager.updateNightVision();
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.statusEffectNightVision" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    protected static void toggleSmoothTransition() {
        boolean newStatus = !nightVision.isSmoothTransitionEnabled();
        nightVision.setSmoothTransitionStatus(newStatus);
        class_5250 message = class_2561.method_43471((String)("text.gammautils.message.transitionNightVision" + (newStatus ? "On" : "Off")));
        InfoProvider.sendMessage((class_2561)message);
    }

    private static void setNightVisionStatus(boolean status) {
        nightVision.setStatus(status);
        StatusEffectManager.updateNightVision();
    }

    private static void startTransitionTimer(final double newValue, final double valueChangePerTick, final boolean showMessage) {
        transitionTimer = new Timer();
        transitionTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                double nextValue = nightVision.getValue() + valueChangePerTick;
                if (valueChangePerTick > 0.0 && nextValue >= newValue || valueChangePerTick < 0.0 && nextValue <= newValue) {
                    transitionTimer.cancel();
                    nightVision.setValue(newValue);
                    NightVisionManager.setNightVisionStatus(newValue != 0.0);
                } else {
                    nightVision.setValue(nextValue);
                    NightVisionManager.setNightVisionStatus(nextValue != 0.0);
                }
                if (showMessage) {
                    InfoProvider.showNightVisionStatusHudMessage();
                }
            }
        }, 0L, 10L);
    }
}

