/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigFloat;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.util.StringUtils;
import net.minecraft.class_3532;

public class ConfigFloat
extends ConfigBase<ConfigFloat>
implements IConfigFloat {
    public static final Codec<ConfigFloat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PrimitiveCodec.STRING.fieldOf("name").forGetter(ConfigBase::getName), (App)PrimitiveCodec.FLOAT.fieldOf("defaultValue").forGetter(get -> Float.valueOf(get.defaultValue)), (App)PrimitiveCodec.FLOAT.fieldOf("minValue").forGetter(get -> Float.valueOf(get.minValue)), (App)PrimitiveCodec.FLOAT.fieldOf("maxValue").forGetter(get -> Float.valueOf(get.maxValue)), (App)PrimitiveCodec.FLOAT.fieldOf("value").forGetter(get -> Float.valueOf(get.value)), (App)PrimitiveCodec.BOOL.fieldOf("useSlider").forGetter(get -> get.useSlider), (App)PrimitiveCodec.STRING.fieldOf("comment").forGetter(get -> get.comment), (App)PrimitiveCodec.STRING.fieldOf("prettyName").forGetter(get -> get.prettyName), (App)PrimitiveCodec.STRING.fieldOf("translatedName").forGetter(get -> get.translatedName)).apply((Applicative)instance, ConfigFloat::new));
    protected final float minValue;
    protected final float maxValue;
    protected final float defaultValue;
    protected float value;
    protected boolean useSlider;

    public ConfigFloat(String name, float defaultValue) {
        this(name, defaultValue, Float.MIN_VALUE, Float.MAX_VALUE, false, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigFloat(String name, float defaultValue, String comment) {
        this(name, defaultValue, Float.MIN_VALUE, Float.MAX_VALUE, false, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigFloat(String name, float defaultValue, String comment, String prettyName) {
        this(name, defaultValue, Float.MIN_VALUE, Float.MAX_VALUE, false, comment, prettyName, name);
    }

    public ConfigFloat(String name, float defaultValue, String comment, String prettyName, String translatedName) {
        this(name, defaultValue, Float.MIN_VALUE, Float.MAX_VALUE, false, comment, prettyName, translatedName);
    }

    public ConfigFloat(String name, float defaultValue, float minValue, float maxValue) {
        this(name, defaultValue, minValue, maxValue, false, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigFloat(String name, float defaultValue, float minValue, float maxValue, String comment) {
        this(name, defaultValue, minValue, maxValue, false, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigFloat(String name, float defaultValue, float minValue, float maxValue, String comment, String prettyName) {
        this(name, defaultValue, minValue, maxValue, false, comment, prettyName, name);
    }

    public ConfigFloat(String name, float defaultValue, float minValue, float maxValue, boolean useSlider) {
        this(name, defaultValue, minValue, maxValue, useSlider, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigFloat(String name, float defaultValue, float minValue, float maxValue, boolean useSlider, String comment) {
        this(name, defaultValue, minValue, maxValue, useSlider, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigFloat(String name, float defaultValue, float minValue, float maxValue, boolean useSlider, String comment, String prettyName) {
        this(name, defaultValue, minValue, maxValue, useSlider, comment, prettyName, name);
    }

    public ConfigFloat(String name, float defaultValue, float minValue, float maxValue, boolean useSlider, String comment, String prettyName, String translatedName) {
        super(ConfigType.FLOAT, name, comment, prettyName, translatedName);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.useSlider = useSlider;
    }

    private ConfigFloat(String name, Float defaultValue, Float minValue, Float maxValue, Float value, Boolean useSlider, String comment, String prettyName, String translatedName) {
        this(name, defaultValue.floatValue(), minValue.floatValue(), maxValue.floatValue(), useSlider, comment, prettyName, translatedName);
        this.value = value.floatValue();
    }

    @Override
    public boolean shouldUseSlider() {
        return this.useSlider;
    }

    @Override
    public void toggleUseSlider() {
        this.useSlider = !this.useSlider;
    }

    @Override
    public float getFloatValue() {
        return this.value;
    }

    @Override
    public float getDefaultFloatValue() {
        return this.defaultValue;
    }

    @Override
    public void setFloatValue(float value) {
        float oldValue = this.value;
        this.value = this.getClampedValue(value);
        if (oldValue != this.value) {
            this.onValueChanged();
        }
    }

    @Override
    public float getMinFloatValue() {
        return this.minValue;
    }

    @Override
    public float getMaxFloatValue() {
        return this.maxValue;
    }

    protected float getClampedValue(float value) {
        return class_3532.method_15363((float)value, (float)this.minValue, (float)this.maxValue);
    }

    @Override
    public boolean isModified() {
        return this.value != this.defaultValue;
    }

    @Override
    public boolean isModified(String newValue) {
        try {
            return Float.parseFloat(newValue) != this.defaultValue;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void resetToDefault() {
        this.setFloatValue(this.defaultValue);
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.value);
    }

    @Override
    public String getDefaultStringValue() {
        return String.valueOf(this.defaultValue);
    }

    @Override
    public void setValueFromString(String value) {
        try {
            this.setFloatValue(Float.parseFloat(value));
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to set config value for {} from the string '{}'", (Object)this.getName(), (Object)value, (Object)e);
        }
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.value = this.getClampedValue(element.getAsFloat());
            } else {
                MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        return new JsonPrimitive((Number)Float.valueOf(this.value));
    }
}

