/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.data.tag;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import fi.dy.masa.malilib.data.tag.BoolDat;
import fi.dy.masa.malilib.data.tag.DoubleDat;
import fi.dy.masa.malilib.data.tag.FloatDat;
import fi.dy.masa.malilib.data.tag.FractionDat;
import fi.dy.masa.malilib.data.tag.IntDat;
import fi.dy.masa.malilib.data.tag.LongDat;
import fi.dy.masa.malilib.data.tag.ShortDat;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public enum DatType implements class_3542
{
    BOOL("bool"),
    INT("int"),
    SHORT("short"),
    LONG("long"),
    FLOAT("float"),
    DOUBLE("dbl"),
    FRACTION("fraction"),
    LIST("list"),
    EMPTY("empty");

    public static final class_3542.class_7292<DatType> CODEC;
    public static final class_9139<ByteBuf, DatType> PACKET_CODEC;
    public static final ImmutableList<DatType> VALUES;
    private final String name;

    private DatType(String name) {
        this.name = name;
    }

    public String method_15434() {
        return this.name;
    }

    @Nullable
    public static DatType fromString(String str) {
        for (DatType entry : DatType.values()) {
            if (!entry.method_15434().equalsIgnoreCase(str)) continue;
            return entry;
        }
        return null;
    }

    public static DatType fromClass(Class<?> type) {
        String name;
        switch (name = type.getName()) {
            case "Boolean": {
                return BOOL;
            }
            case "Integer": {
                return INT;
            }
            case "Short": {
                return SHORT;
            }
            case "Long": {
                return LONG;
            }
            case "Float": {
                return FLOAT;
            }
            case "Double": {
                return DOUBLE;
            }
            case "Fraction": {
                return FRACTION;
            }
            case "List": {
                return LIST;
            }
        }
        return EMPTY;
    }

    @Nullable
    public Codec<?> codec() {
        switch (this.name()) {
            case "bool": {
                return BoolDat.CODEC;
            }
            case "int": {
                return IntDat.CODEC;
            }
            case "short": {
                return ShortDat.CODEC;
            }
            case "long": {
                return LongDat.CODEC;
            }
            case "float": {
                return FloatDat.CODEC;
            }
            case "dbl": {
                return DoubleDat.CODEC;
            }
            case "fraction": {
                return FractionDat.CODEC;
            }
        }
        return null;
    }

    static {
        CODEC = class_3542.method_28140(DatType::values);
        PACKET_CODEC = class_9135.field_48554.method_56432(DatType::fromString, DatType::method_15434);
        VALUES = ImmutableList.copyOf((Object[])DatType.values());
    }
}

