/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.joml.Vector2d;

public class Vec2d {
    public static final Codec<Vec2d> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.DOUBLE.fieldOf("x").forGetter(get -> get.x), (App)PrimitiveCodec.DOUBLE.fieldOf("y").forGetter(get -> get.y)).apply((Applicative)inst, Vec2d::new));
    public static final class_9139<ByteBuf, Vec2d> PACKET_CODEC = new class_9139<ByteBuf, Vec2d>(){

        public void encode(ByteBuf buf, Vec2d value) {
            class_9135.field_48553.encode((Object)buf, (Object)value.x);
            class_9135.field_48553.encode((Object)buf, (Object)value.y);
        }

        public Vec2d decode(ByteBuf buf) {
            return new Vec2d((Double)class_9135.field_48553.decode((Object)buf), (Double)class_9135.field_48553.decode((Object)buf));
        }
    };
    public static final Vec2d ZERO = new Vec2d(0.0, 0.0);
    public final double x;
    public final double y;

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getSquaredDistance(double x, double y) {
        double diffX = x - this.x;
        double diffY = y - this.y;
        return diffX * diffX + diffY * diffY;
    }

    public double getDistance(double x, double y) {
        return Math.sqrt(this.getSquaredDistance(x, y));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec2d vec2d = (Vec2d)o;
        return Double.compare(vec2d.x, this.x) == 0 && Double.compare(vec2d.y, this.y) == 0;
    }

    public Vector2d toVector() {
        return new Vector2d(this.getX(), this.getY());
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Vec2d{x=" + this.x + ", y=" + this.y + "}";
    }
}

