/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mjson.Json;
import net.fabricmc.installer.util.FabricService;
import net.fabricmc.installer.util.VersionMeta;

public class LauncherMeta {
    private static LauncherMeta launcherMeta = null;
    public final List<Version> versions;

    public static LauncherMeta getLauncherMeta() throws IOException {
        if (launcherMeta == null) {
            launcherMeta = LauncherMeta.load();
        }
        return launcherMeta;
    }

    private static LauncherMeta load() throws IOException {
        ArrayList<Version> versions = new ArrayList<Version>();
        versions.addAll(LauncherMeta.getVersionsFromUrl("https://launchermeta.mojang.com/mc/game/version_manifest_v2.json"));
        versions.addAll(LauncherMeta.getVersionsFromUrl("https://maven.fabricmc.net/net/minecraft/experimental_versions.json"));
        return new LauncherMeta(versions);
    }

    private static List<Version> getVersionsFromUrl(String url) throws IOException {
        Json json = FabricService.queryJsonSubstitutedMaven(url);
        List<Version> versions = json.at("versions").asJsonList().stream().map(Version::new).collect(Collectors.toList());
        return versions;
    }

    public LauncherMeta(List<Version> versions) {
        this.versions = versions;
    }

    public Version getVersion(String version) {
        return this.versions.stream().filter(v -> v.id.equals(version)).findFirst().orElse(null);
    }

    public static class Version {
        public final String id;
        public final String url;
        private VersionMeta versionMeta = null;

        public Version(Json json) {
            this.id = json.at("id").asString();
            this.url = json.at("url").asString();
        }

        public VersionMeta getVersionMeta() throws IOException {
            if (this.versionMeta == null) {
                Json json = FabricService.queryJsonSubstitutedMaven(this.url);
                this.versionMeta = new VersionMeta(json);
            }
            return this.versionMeta;
        }
    }
}

