/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.malilib.util.nbt.NbtInventory;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineChunkCache;
import fi.dy.masa.minihud.mixin.world.IMixinServerWorld;
import fi.dy.masa.minihud.renderer.InventoryOverlayHandler;
import fi.dy.masa.minihud.renderer.OverlayRenderer;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.IServerEntityManager;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.SpeedUnits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_276;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3568;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4481;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_5455;
import net.minecraft.class_5537;
import net.minecraft.class_640;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class RenderHandler
implements IRenderer {
    private static final RenderHandler INSTANCE = new RenderHandler();
    private final class_310 mc;
    private final DataStorage data;
    private final HudDataManager hudData;
    private final Date date;
    private final Set<InfoToggle> addedTypes = new HashSet<InfoToggle>();
    private long infoUpdateTime;
    private final List<StringHolder> lineWrappers = new ArrayList<StringHolder>();
    private final List<String> lines = new ArrayList<String>();
    private Pair<class_2586, class_2487> lastBlockEntity = null;
    private Pair<class_1297, class_2487> lastEntity = null;
    private Pair<class_1297, class_2487> lastEnderItems = null;

    public RenderHandler() {
        this.mc = class_310.method_1551();
        this.data = DataStorage.getInstance();
        this.hudData = HudDataManager.getInstance();
        this.date = new Date();
    }

    public static RenderHandler getInstance() {
        return INSTANCE;
    }

    public DataStorage getDataStorage() {
        return this.data;
    }

    public HudDataManager getHudData() {
        return this.hudData;
    }

    public static void fixDebugRendererState() {
    }

    public void onRenderGameOverlayPostAdvanced(class_332 drawContext, float partialTicks, class_3695 profiler, class_310 mc) {
        if (!Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue()) {
            InfoLineChunkCache.INSTANCE.onReset();
            return;
        }
        if (!(mc.method_53526().method_53536() || mc.field_1724 == null || mc.field_1690.field_1842 || Configs.Generic.REQUIRE_SNEAK.getBooleanValue() && !mc.field_1724.method_5715() || !Configs.Generic.REQUIRED_KEY.getKeybind().isKeybindHeld())) {
            long currentTime = System.nanoTime();
            if (currentTime - this.infoUpdateTime >= 50000000L) {
                this.updateLines();
                this.infoUpdateTime = currentTime;
            }
            int x = Configs.Generic.TEXT_POS_X.getIntegerValue();
            int y = Configs.Generic.TEXT_POS_Y.getIntegerValue();
            int textColor = Configs.Colors.TEXT_COLOR.getIntegerValue();
            int bgColor = Configs.Colors.TEXT_BACKGROUND_COLOR.getIntegerValue();
            HudAlignment alignment = (HudAlignment)Configs.Generic.HUD_ALIGNMENT.getOptionListValue();
            boolean useBackground = Configs.Generic.USE_TEXT_BACKGROUND.getBooleanValue();
            boolean useShadow = Configs.Generic.USE_FONT_SHADOW.getBooleanValue();
            RenderUtils.renderText((class_332)drawContext, (int)x, (int)y, (double)Configs.Generic.FONT_SCALE.getDoubleValue(), (int)textColor, (int)bgColor, (HudAlignment)alignment, (boolean)useBackground, (boolean)useShadow, (boolean)Configs.Generic.HUD_STATUS_EFFECTS_SHIFT.getBooleanValue(), this.lines);
        }
        if (Configs.Generic.INVENTORY_PREVIEW_ENABLED.getBooleanValue() && Configs.Generic.INVENTORY_PREVIEW.getKeybind().isKeybindHeld()) {
            InventoryOverlayHandler.getInstance().getRenderContext(drawContext, profiler, mc);
        }
    }

    public void onRenderWorldPreWeather(class_276 fb, Matrix4f posMatrix, Matrix4f projMatrix, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
    }

    public void onRenderWorldLastAdvanced(class_276 fb, Matrix4f posMatrix, Matrix4f projMatrix, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
        if (Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && this.mc.field_1687 != null && this.mc.field_1724 != null && !this.mc.field_1690.field_1842) {
            OverlayRenderer.renderOverlays(posMatrix, projMatrix, this.mc, frustum, camera, profiler);
        }
    }

    public void onRenderTooltipLast(class_332 drawContext, class_1799 stack, int x, int y) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1806) {
            if (Configs.Generic.MAP_PREVIEW.getBooleanValue() && (!Configs.Generic.MAP_PREVIEW_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                RenderUtils.renderMapPreview((class_332)drawContext, (class_1799)stack, (int)x, (int)y, (int)Configs.Generic.MAP_PREVIEW_SIZE.getIntegerValue(), (boolean)false);
            }
        } else if (stack.method_57353().method_57832(class_9334.field_49622) && InventoryUtils.shulkerBoxHasItems((class_1799)stack)) {
            if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                RenderUtils.renderShulkerBoxPreview((class_332)drawContext, (class_1799)stack, (int)x, (int)y, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            }
        } else if (stack.method_31574(class_1802.field_8466) && Configs.Generic.SHULKER_DISPLAY_ENDER_CHEST.getBooleanValue()) {
            class_1937 world;
            class_1657 player;
            if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown()) && (player = (world = WorldUtils.getBestWorld((class_310)this.mc)).method_18470(this.mc.field_1724.method_5667())) != null) {
                class_1730 inv;
                Pair<class_1297, class_2487> pair = EntitiesDataManager.getInstance().requestEntity(world, player.method_5628());
                if (pair != null && pair.getRight() != null && ((class_2487)pair.getRight()).method_10545("EnderItems")) {
                    inv = InventoryUtils.getPlayerEnderItemsFromNbt((class_2487)((class_2487)pair.getRight()), (class_5455)world.method_30349());
                    this.lastEnderItems = pair;
                } else {
                    class_1657 pe;
                    Object object;
                    inv = pair != null && (object = pair.getLeft()) instanceof class_1657 && !(pe = (class_1657)object).method_7274().method_5442() ? pe.method_7274() : (this.lastEnderItems != null ? InventoryUtils.getPlayerEnderItemsFromNbt((class_2487)((class_2487)this.lastEnderItems.getRight()), (class_5455)world.method_30349()) : player.method_7274());
                }
                if (inv != null) {
                    try (NbtInventory nbtInv = NbtInventory.fromInventory((class_1263)inv);){
                        class_2487 nbt = new class_2487();
                        class_2499 list = nbtInv.toNbtList(world.method_30349());
                        nbt.method_10566("EnderItems", (class_2520)list);
                        RenderUtils.renderNbtItemsPreview((class_332)drawContext, (class_1799)stack, (class_2487)nbt, (int)x, (int)y, (boolean)false);
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (stack.method_57353().method_57832(class_9334.field_49650) && InventoryUtils.bundleHasItems((class_1799)stack) && Configs.Generic.BUNDLE_PREVIEW.getBooleanValue() && (!Configs.Generic.BUNDLE_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
            RenderUtils.renderBundlePreview((class_332)drawContext, (class_1799)stack, (int)x, (int)y, (int)Configs.Generic.BUNDLE_DISPLAY_ROW_WIDTH.getIntegerValue(), (boolean)Configs.Generic.BUNDLE_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
        }
    }

    public Supplier<String> getProfilerSectionSupplier() {
        return () -> "minihud_renderer";
    }

    public void onRenderTooltipComponentInsertFirst(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
    }

    public void onRenderTooltipComponentInsertMiddle(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (Configs.Generic.BUNDLE_TOOLTIPS.getBooleanValue() && stack.method_7909() instanceof class_5537) {
            MiscUtils.addBundleTooltip(stack, list);
        }
    }

    public void onRenderTooltipComponentInsertLast(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        class_1747 blockItem;
        class_1792 class_17922;
        if (Configs.Generic.AXOLOTL_TOOLTIPS.getBooleanValue() && stack.method_7909() == class_1802.field_28354) {
            MiscUtils.addAxolotlTooltip(stack, list);
        }
        if (Configs.Generic.BEE_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_49624)) {
            MiscUtils.addBeeTooltip(stack, list);
        }
        if (Configs.Generic.CUSTOM_MODEL_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_49637)) {
            MiscUtils.addCustomModelTooltip(stack, list);
        }
        if (Configs.Generic.FOOD_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_50075)) {
            MiscUtils.addFoodTooltip(stack, list);
        }
        if (Configs.Generic.HONEY_TOOLTIPS.getBooleanValue() && (class_17922 = stack.method_7909()) instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof class_4481) {
            MiscUtils.addHoneyTooltip(stack, list);
        }
        if (Configs.Generic.LODESTONE_TOOLTIPS.getBooleanValue() && stack.method_57826(class_9334.field_49614)) {
            MiscUtils.addLodestoneTooltip(stack, list);
        }
    }

    public int getSubtitleOffset() {
        if (Configs.Generic.OFFSET_SUBTITLE_HUD.getBooleanValue() && Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && Configs.Generic.HUD_ALIGNMENT.getOptionListValue() == HudAlignment.BOTTOM_RIGHT) {
            int offset = (int)((double)(this.lineWrappers.size() * (StringUtils.getFontHeight() + 2)) * Configs.Generic.FONT_SCALE.getDoubleValue());
            return -(offset - 16);
        }
        return 0;
    }

    public void updateData(class_310 mc) {
        if (mc.field_1687 != null && RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            DataStorage.getInstance().updateStructureData();
        }
    }

    private void updateLines() {
        this.lineWrappers.clear();
        this.addedTypes.clear();
        InfoLineChunkCache.INSTANCE.onUpdate();
        ArrayList<LinePos> positions = new ArrayList<LinePos>();
        for (InfoToggle toggle : InfoToggle.values()) {
            if (!toggle.getBooleanValue()) continue;
            positions.add(new LinePos(toggle.getIntegerValue(), toggle));
        }
        Collections.sort(positions);
        for (LinePos pos : positions) {
            try {
                this.addLine(pos.type);
            }
            catch (Exception e) {
                this.addLine(pos.type.getName() + ": exception");
            }
        }
        if (Configs.Generic.SORT_LINES_BY_LENGTH.getBooleanValue()) {
            Collections.sort(this.lineWrappers);
            if (Configs.Generic.SORT_LINES_REVERSED.getBooleanValue()) {
                Collections.reverse(this.lineWrappers);
            }
        }
        this.lines.clear();
        for (StringHolder holder : this.lineWrappers) {
            this.lines.add(holder.str);
        }
    }

    private void processEntries(List<InfoLine.Entry> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (InfoLine.Entry entry : list) {
            if (entry.isEmpty()) continue;
            if (entry.isTranslated()) {
                this.addLine(entry.format());
                continue;
            }
            if (entry.hasArgs()) {
                this.addLineI18n(entry.format(), entry.args());
                continue;
            }
            this.addLineI18n(entry.format(), new Object[0]);
        }
    }

    public void addLine(String text) {
        this.lineWrappers.add(new StringHolder(this, text));
    }

    public void addLineI18n(String translatedName, Object ... args) {
        this.addLine(StringUtils.translate((String)translatedName, (Object[])args));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addLine(InfoToggle type) {
        class_310 mc = this.mc;
        class_1297 entity = mc.method_1560();
        class_1937 world = entity.method_37908();
        double y = entity.method_23318();
        class_2338 pos = class_2338.method_49637((double)entity.method_23317(), (double)y, (double)entity.method_23321());
        class_1923 chunkPos = new class_1923(pos);
        boolean isChunkLoaded = mc.field_1687.method_22340(pos);
        SpeedUnits speedUnits = (SpeedUnits)Configs.Generic.SPEED_UNITS.getOptionListValue();
        if (!isChunkLoaded) {
            return;
        }
        if (type == InfoToggle.FPS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.MEMORY_USAGE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_REAL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_WORLD) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_WORLD_FORMATTED) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_DAY_MODULO) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_TOTAL_MODULO) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.SERVER_TPS) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        }
        if (type == InfoToggle.SERVUX) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        }
        if (type == InfoToggle.WEATHER) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        }
        if (type == InfoToggle.MOB_CAPS) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        }
        if (type == InfoToggle.PING) {
            class_640 info = mc.field_1724.field_3944.method_2871(mc.field_1724.method_5667());
            if (info == null) return;
            this.addLineI18n("minihud.info_line.ping", info.method_2959());
            return;
        }
        if (type == InfoToggle.COORDINATES || type == InfoToggle.COORDINATES_SCALED || type == InfoToggle.DIMENSION) {
            if (this.addedTypes.contains((Object)InfoToggle.COORDINATES) || this.addedTypes.contains((Object)InfoToggle.COORDINATES_SCALED) || this.addedTypes.contains((Object)InfoToggle.DIMENSION)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            String fmtStr = Configs.Generic.COORDINATE_FORMAT_STRING.getStringValue();
            double x = entity.method_23317();
            double z = entity.method_23321();
            if (InfoToggle.COORDINATES.getBooleanValue()) {
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append(StringUtils.translate((String)"minihud.info_line.coordinates.exception", (Object[])new Object[0]));
                    }
                } else {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates.format", (Object[])new Object[]{x, y, z}));
                }
                pre = " / ";
            }
            if (InfoToggle.COORDINATES_SCALED.getBooleanValue() && (world.method_27983() == class_1937.field_25180 || world.method_27983() == class_1937.field_25179)) {
                boolean isNether = world.method_27983() == class_1937.field_25180;
                double scale = isNether ? 8.0 : 0.125;
                x *= scale;
                z *= scale;
                str.append(pre);
                if (isNether) {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates_scaled.overworld", (Object[])new Object[0]));
                } else {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates_scaled.nether", (Object[])new Object[0]));
                }
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append(StringUtils.translate((String)"minihud.info_line.coordinates.exception", (Object[])new Object[0]));
                    }
                } else {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates.format", (Object[])new Object[]{x, y, z}));
                }
                pre = " / ";
            }
            if (InfoToggle.DIMENSION.getBooleanValue()) {
                String dimName = world.method_27983().method_29177().toString();
                str.append(pre).append(StringUtils.translate((String)"minihud.info_line.dimension", (Object[])new Object[0])).append(dimName);
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.COORDINATES);
            this.addedTypes.add(InfoToggle.COORDINATES_SCALED);
            this.addedTypes.add(InfoToggle.DIMENSION);
            return;
        }
        if (type == InfoToggle.BLOCK_POS || type == InfoToggle.CHUNK_POS || type == InfoToggle.REGION_FILE) {
            if (this.addedTypes.contains((Object)InfoToggle.BLOCK_POS) || this.addedTypes.contains((Object)InfoToggle.CHUNK_POS) || this.addedTypes.contains((Object)InfoToggle.REGION_FILE)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(256);
            if (InfoToggle.BLOCK_POS.getBooleanValue()) {
                try {
                    String fmt = Configs.Generic.BLOCK_POS_FORMAT_STRING.getStringValue();
                    str.append(String.format(fmt, pos.method_10263(), pos.method_10264(), pos.method_10260()));
                }
                catch (Exception e) {
                    str.append(StringUtils.translate((String)"minihud.info_line.block_pos.exception", (Object[])new Object[0]));
                }
                pre = " / ";
            }
            if (InfoToggle.CHUNK_POS.getBooleanValue()) {
                str.append(pre).append(StringUtils.translate((String)"minihud.info_line.chunk_pos", (Object[])new Object[]{chunkPos.field_9181, pos.method_10264() >> 4, chunkPos.field_9180}));
                pre = " / ";
            }
            if (InfoToggle.REGION_FILE.getBooleanValue()) {
                str.append(pre).append(StringUtils.translate((String)"minihud.info_line.region_file", (Object[])new Object[]{pos.method_10263() >> 9, pos.method_10260() >> 9}));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.BLOCK_POS);
            this.addedTypes.add(InfoToggle.CHUNK_POS);
            this.addedTypes.add(InfoToggle.REGION_FILE);
            return;
        }
        if (type == InfoToggle.BLOCK_IN_CHUNK) {
            this.addLineI18n("minihud.info_line.block_in_chunk", pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF, chunkPos.field_9181, pos.method_10264() >> 4, chunkPos.field_9180);
            return;
        } else if (type == InfoToggle.BLOCK_BREAK_SPEED) {
            this.addLineI18n("minihud.info_line.block_break_speed", DataStorage.getInstance().getBlockBreakingSpeed());
            return;
        } else if (type == InfoToggle.SPRINTING && mc.field_1724.method_5624()) {
            this.addLineI18n("minihud.info_line.sprinting", new Object[0]);
            return;
        } else if (type == InfoToggle.DISTANCE) {
            class_243 ref = DataStorage.getInstance().getDistanceReferencePoint();
            double dist = Math.sqrt(ref.method_1028(entity.method_23317(), entity.method_23318(), entity.method_23321()));
            this.addLineI18n("minihud.info_line.distance", dist, entity.method_23317() - ref.field_1352, entity.method_23318() - ref.field_1351, entity.method_23321() - ref.field_1350, ref.field_1352, ref.field_1351, ref.field_1350);
            return;
        } else if (type == InfoToggle.FACING) {
            String str;
            class_2350 facing = entity.method_5735();
            String facingName = StringUtils.translate((String)("minihud.info_line.facing." + facing.name().toLowerCase() + ".name"), (Object[])new Object[0]);
            if (facingName.contains("minihud.info_line.facing." + facing.name().toLowerCase() + ".name")) {
                facingName = facing.name().toLowerCase();
                str = StringUtils.translate((String)"minihud.info_line.invalid_value", (Object[])new Object[0]);
            } else {
                str = StringUtils.translate((String)("minihud.info_line.facing." + facing.name().toLowerCase()), (Object[])new Object[0]);
            }
            this.addLineI18n("minihud.info_line.facing", facingName, str);
            return;
        } else if (type == InfoToggle.LIGHT_LEVEL) {
            class_2818 clientChunk = InfoLineChunkCache.INSTANCE.getClientChunk(chunkPos);
            if (clientChunk.method_12223()) return;
            class_3568 lightingProvider = world.method_8398().method_12130();
            this.addLineI18n("minihud.info_line.light_level", lightingProvider.method_15562(class_1944.field_9282).method_15543(pos));
            return;
        } else if (type == InfoToggle.BEE_COUNT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            Pair<class_2586, class_2487> pair = this.getTargetedBlockEntity(bestWorld, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, (class_2586)pair.getLeft(), null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.COMPARATOR_OUTPUT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            Pair<class_2586, class_2487> pair = this.getTargetedBlockEntity(bestWorld, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, (class_2586)pair.getLeft(), null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.HONEY_LEVEL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_2680 state = this.getTargetedBlock(mc);
            if (state == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, state, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.FURNACE_XP) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            Pair<class_2586, class_2487> pair = this.getTargetedBlockEntity(bestWorld, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, (class_2586)pair.getLeft(), null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.HORSE_SPEED || type == InfoToggle.HORSE_JUMP) {
            InfoLine.Context ctx;
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(bestWorld, mc);
            if (mc.field_1724.method_5765() && pair == null) {
                ctx = new InfoLine.Context(bestWorld, mc.field_1724.method_5854(), null, null, null, null);
            } else {
                if (pair == null) return;
                ctx = new InfoLine.Context(bestWorld, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            }
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ROTATION_YAW || type == InfoToggle.ROTATION_PITCH || type == InfoToggle.SPEED) {
            if (this.addedTypes.contains((Object)InfoToggle.ROTATION_YAW) || this.addedTypes.contains((Object)InfoToggle.ROTATION_PITCH) || this.addedTypes.contains((Object)InfoToggle.SPEED)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            if (InfoToggle.ROTATION_YAW.getBooleanValue()) {
                str.append(StringUtils.translate((String)"minihud.info_line.rotation_yaw", (Object[])new Object[]{Float.valueOf(class_3532.method_15393((float)entity.method_36454()))}));
                pre = " / ";
            }
            if (InfoToggle.ROTATION_PITCH.getBooleanValue()) {
                str.append(pre).append(StringUtils.translate((String)"minihud.info_line.rotation_pitch", (Object[])new Object[]{Float.valueOf(class_3532.method_15393((float)entity.method_36455()))}));
                pre = " / ";
            }
            if (InfoToggle.SPEED.getBooleanValue()) {
                double dx = entity.method_23317() - entity.field_6038;
                double dy = entity.method_23318() - entity.field_5971;
                double dz = entity.method_23321() - entity.field_5989;
                double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                str.append(pre).append(StringUtils.translate((String)("minihud.info_line.speed_" + speedUnits.suffix), (Object[])new Object[]{speedUnits.convert(dist * 20.0)}));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.ROTATION_YAW);
            this.addedTypes.add(InfoToggle.ROTATION_PITCH);
            this.addedTypes.add(InfoToggle.SPEED);
            return;
        } else if (type == InfoToggle.SPEED_HV) {
            double dx = entity.method_23317() - entity.field_6038;
            double dy = entity.method_23318() - entity.field_5971;
            double dz = entity.method_23321() - entity.field_5989;
            this.addLineI18n("minihud.info_line.speed_hv_" + speedUnits.suffix, speedUnits.convert(Math.sqrt(dx * dx + dz * dz) * 20.0), speedUnits.convert(dy * 20.0));
            return;
        } else if (type == InfoToggle.SPEED_AXIS) {
            double dx = entity.method_23317() - entity.field_6038;
            double dy = entity.method_23318() - entity.field_5971;
            double dz = entity.method_23321() - entity.field_5989;
            this.addLineI18n("minihud.info_line.speed_axis_" + speedUnits.suffix, speedUnits.convert(dx * 20.0), speedUnits.convert(dy * 20.0), speedUnits.convert(dz * 20.0));
            return;
        } else if (type == InfoToggle.CHUNK_SECTIONS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.CHUNK_SECTIONS_FULL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.CHUNK_UPDATES) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.LOADED_CHUNKS_COUNT) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PANDA_GENE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PARTICLE_COUNT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.DIFFICULTY) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.BIOME) {
            class_2818 clientChunk = InfoLineChunkCache.INSTANCE.getClientChunk(chunkPos);
            if (clientChunk.method_12223()) return;
            class_1959 biome = (class_1959)mc.field_1687.method_23753(pos).comp_349();
            class_2960 id = mc.field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
            String translationKey = "biome." + id.toString().replace(":", ".");
            String biomeName = StringUtils.translate((String)translationKey, (Object[])new Object[0]);
            if (biomeName.equals(translationKey)) {
                biomeName = StringUtils.prettifyRawTranslationPath((String)id.method_12832());
            }
            this.addLineI18n("minihud.info_line.biome", biomeName);
            return;
        } else if (type == InfoToggle.BIOME_REG_NAME) {
            class_2818 clientChunk = InfoLineChunkCache.INSTANCE.getClientChunk(chunkPos);
            if (clientChunk.method_12223()) return;
            class_1959 biome = (class_1959)mc.field_1687.method_23753(pos).comp_349();
            class_2960 rl = mc.field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
            String name = rl != null ? rl.toString() : "?";
            this.addLineI18n("minihud.info_line.biome_reg_name", name);
            return;
        } else if (type == InfoToggle.ENTITIES) {
            String ent = mc.field_1769.method_3272();
            int p = ent.indexOf(",");
            if (p != -1) {
                ent = ent.substring(0, p);
            }
            this.addLine(ent);
            return;
        } else if (type == InfoToggle.TILE_ENTITIES) {
            this.addLineI18n("minihud.info_line.tile_entities", new Object[0]);
            return;
        } else if (type == InfoToggle.ENTITIES_CLIENT_WORLD) {
            class_1937 serverWorld;
            int countClient = mc.field_1687.method_18120();
            if (mc.method_1496() && (serverWorld = WorldUtils.getBestWorld((class_310)mc)) instanceof class_3218) {
                IServerEntityManager manager = (IServerEntityManager)((IMixinServerWorld)serverWorld).minihud_getEntityManager();
                int indexSize = manager.minihud$getIndexSize();
                this.addLineI18n("minihud.info_line.entities_client_world.server", countClient, indexSize);
                return;
            }
            this.addLineI18n("minihud.info_line.entities_client_world", countClient);
            return;
        } else if (type == InfoToggle.SLIME_CHUNK) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.LOOKING_AT_ENTITY) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_VARIANT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_HOME_POS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.LOOKING_AT_EFFECTS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ZOMBIE_CONVERSION) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.DOLPHIN_TREASURE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_REG_NAME) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PLAYER_EXPERIENCE) {
            if (mc.field_1724 == null) return;
            this.addLineI18n("minihud.info_line.player_experience", mc.field_1724.field_7520, Float.valueOf(100.0f * mc.field_1724.field_7510), mc.field_1724.field_7495);
            return;
        } else if (type == InfoToggle.LOOKING_AT_PLAYER_EXP) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<class_1297, class_2487> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (class_1297)pair.getLeft(), null, null, null, (class_2487)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.LOOKING_AT_BLOCK || type == InfoToggle.LOOKING_AT_BLOCK_CHUNK) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_2680 state = this.getTargetedBlock(mc);
            if (state == null) return;
            class_2338 lookPos = ((class_3965)mc.field_1765).method_17777();
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, lookPos, state, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else {
            if (type != InfoToggle.BLOCK_PROPS) return;
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            class_2680 state = this.getTargetedBlock(mc);
            if (state == null) return;
            class_2338 lookPos = ((class_3965)mc.field_1765).method_17777();
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, lookPos, state, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
        }
    }

    private boolean isEntityDataValid(@Nonnull class_2487 nbt) {
        if (InventoryUtils.hasNbtItems((class_2487)nbt)) {
            return true;
        }
        Iterator iterator = nbt.method_10541().iterator();
        block28: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "Fire": {
                    short fire = nbt.method_68565("Fire", (short)-1);
                    if (fire >= 0 && fire <= 0) continue block28;
                    return true;
                }
                case "Age": {
                    int age = nbt.method_68083("Age", -1);
                    if (age != 0 && age <= 1) continue block28;
                    return true;
                }
                case "Brain": {
                    class_2487 tag = nbt.method_68568("Brain");
                    if (tag.method_33133() || tag.method_10562("memories").isEmpty()) continue block28;
                    return true;
                }
                case "Offers": {
                    return true;
                }
                case "Recipes": {
                    return true;
                }
                case "ConversionTime": {
                    if (nbt.method_68083("ConversionTime", -1) <= 0) break;
                    return true;
                }
                case "DrownedConversionTime": {
                    if (nbt.method_68083("DrownedConversionTime", -1) <= 0) break;
                    return true;
                }
                case "StrayConversionTime": {
                    if (nbt.method_68083("StrayConversionTime", -1) <= 0) break;
                    return true;
                }
                case "ConversionPlayer": {
                    return true;
                }
                case "recipeBook": {
                    return true;
                }
                case "recipes": {
                    return true;
                }
                case "active_effects": {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public Pair<class_1297, class_2487> getTargetEntity(class_1937 world, class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1331) {
            class_1297 lookedEntity = ((class_3966)mc.field_1765).method_17782();
            if (lookedEntity == null || lookedEntity.method_5628() == mc.field_1724.method_5628()) {
                return null;
            }
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            Pair<class_1297, class_2487> pair = null;
            if (bestWorld instanceof class_3218) {
                class_3218 serverWorld = (class_3218)bestWorld;
                class_1297 serverEntity = serverWorld.method_8469(lookedEntity.method_5628());
                class_2487 nbt = NbtEntityUtils.invokeEntityNbtDataNoPassengers((class_1297)serverEntity, (int)lookedEntity.method_5628());
                if (!nbt.method_33133()) {
                    pair = Pair.of((Object)serverEntity, (Object)nbt);
                }
            } else {
                pair = EntitiesDataManager.getInstance().requestEntity(world, lookedEntity.method_5628());
            }
            if (pair == null && this.lastEntity != null && ((class_1297)this.lastEntity.getLeft()).method_5628() == lookedEntity.method_5628()) {
                pair = this.lastEntity;
            } else if (pair != null && pair.getRight() != null && !((class_2487)pair.getRight()).method_33133() && this.isEntityDataValid((class_2487)pair.getRight())) {
                this.lastEntity = pair;
            } else if (this.lastEntity != null && ((class_1297)this.lastEntity.getLeft()).method_5628() == lookedEntity.method_5628()) {
                pair = this.lastEntity;
            }
            return pair;
        }
        return null;
    }

    @Nullable
    public Pair<class_2586, class_2487> getTargetedBlockEntity(class_1937 world, class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            class_1937 bestWorld = WorldUtils.getBestWorld((class_310)mc);
            class_2680 state = bestWorld.method_8320(posLooking);
            Pair<class_2586, class_2487> pair = null;
            if (state.method_26204() instanceof class_2343) {
                if (bestWorld instanceof class_3218) {
                    class_2586 be;
                    class_2487 nbt = new class_2487();
                    pair = Pair.of((Object)be, (Object)((be = bestWorld.method_8500(posLooking).method_8321(posLooking)) != null ? be.method_38242((class_7225.class_7874)bestWorld.method_30349()) : nbt));
                } else {
                    pair = EntitiesDataManager.getInstance().requestBlockEntity(world, posLooking);
                }
                if (pair == null && this.lastBlockEntity != null && ((class_2586)this.lastBlockEntity.getLeft()).method_11016().equals((Object)posLooking)) {
                    pair = this.lastBlockEntity;
                } else if (pair != null) {
                    this.lastBlockEntity = pair;
                }
                return pair;
            }
        }
        return null;
    }

    @Nullable
    public Pair<class_2586, class_2487> requestBlockEntityAt(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            class_2745 type;
            Pair<class_2586, class_2487> pair = EntitiesDataManager.getInstance().requestBlockEntity(world, pos);
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() instanceof class_2281 && (type = (class_2745)state.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569) {
                return EntitiesDataManager.getInstance().requestBlockEntity(world, pos.method_10093(class_2281.method_9758((class_2680)state)));
            }
            return pair;
        }
        return null;
    }

    @Nullable
    private class_2680 getTargetedBlock(class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            return mc.field_1687.method_8320(posLooking);
        }
        return null;
    }

    private <T extends Comparable<T>> void getBlockProperties(class_310 mc) {
        if (mc.field_1765 != null && mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            class_2338 posLooking = ((class_3965)mc.field_1765).method_17777();
            class_2680 state = mc.field_1687.method_8320(posLooking);
            class_2960 rl = class_7923.field_41175.method_10221((Object)state.method_26204());
            this.addLine(rl != null ? rl.toString() : "<null>");
            for (String line : BlockUtils.getFormattedBlockStateProperties((class_2680)state)) {
                this.addLine(line);
            }
        }
    }

    private static class LinePos
    implements Comparable<LinePos> {
        private final int position;
        private final InfoToggle type;

        private LinePos(int position, InfoToggle type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public int compareTo(@Nonnull LinePos other) {
            if (this.position < 0) {
                return other.position >= 0 ? 1 : 0;
            }
            if (other.position < 0 && this.position >= 0) {
                return -1;
            }
            return this.position < other.position ? -1 : (this.position > other.position ? 1 : 0);
        }
    }

    private class StringHolder
    implements Comparable<StringHolder> {
        public final String str;

        public StringHolder(RenderHandler renderHandler, String str) {
            this.str = str;
        }

        @Override
        public int compareTo(StringHolder other) {
            int lenOther;
            int lenThis = this.str.length();
            if (lenThis == (lenOther = other.str.length())) {
                return 0;
            }
            return this.str.length() > other.str.length() ? -1 : 1;
        }
    }
}

