/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.api.sync.SyncSignal;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataHolder;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import net.minecraft.class_1297;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class DataEntry<E extends class_1297, T> {
    private final SyncSignal signal;
    private final DataHolder holder;
    private final SyncedDataKey<E, T> key;
    private T value;
    private boolean dirty;

    DataEntry(DataHolder holder, SyncedDataKey<E, T> key) {
        this.holder = holder;
        this.key = key;
        this.value = key.defaultValueSupplier().get();
        this.signal = new SyncSignal(this::markDirty);
        this.updateSignal(this.value);
    }

    SyncedDataKey<E, T> getKey() {
        return this.key;
    }

    T getValue() {
        return this.value;
    }

    void setValue(T value, boolean dirty) {
        this.updateSignal(value);
        this.value = value;
        this.dirty = dirty;
    }

    void markDirty() {
        this.dirty = true;
        this.holder.markDirty();
    }

    boolean isDirty() {
        return this.dirty;
    }

    void clean() {
        this.dirty = false;
    }

    public void write(class_9129 buffer) {
        int id = SyncedEntityData.instance().getInternalId(this.key);
        buffer.method_10804(id);
        this.key.serializer().getCodec().encode((Object)buffer, this.value);
    }

    public static DataEntry<?, ?> read(class_9129 buffer) {
        SyncedDataKey<?, ?> key = SyncedEntityData.instance().getKey(buffer.method_10816());
        Validate.notNull(key, (String)"Synced key does not exist for id", (Object[])new Object[0]);
        DataEntry entry = new DataEntry(null, key);
        entry.readValue(buffer);
        return entry;
    }

    private void readValue(class_9129 buffer) {
        this.value = this.getKey().serializer().getCodec().decode((Object)buffer);
    }

    @Nullable
    class_2520 writeValue(class_7225.class_7874 provider) {
        return this.key.serializer().getTagWriter().apply(this.value, provider);
    }

    void readValue(@Nullable class_2520 tag, class_7225.class_7874 provider) {
        this.value = this.key.serializer().getTagReader().apply(tag, provider);
    }

    private void updateSignal(T value) {
        if (value instanceof SyncSignal.Consumer) {
            SyncSignal.Consumer consumer = (SyncSignal.Consumer)value;
            consumer.accept(this.signal);
        }
    }
}

