/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.CustomItemRenderer;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.TriFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginManager;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5614;
import net.minecraft.class_5617;
import net.minecraft.class_827;
import net.minecraft.class_897;
import org.jetbrains.annotations.ApiStatus;

public class ClientRegistrationHandler {
    private static final Map<String, ClientRegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, ClientRegistrationHandler>();
    private static boolean haveRenderersBeenRegistered = false;
    private static boolean haveModelsBeenRegistered = false;
    private final String modid;
    private final Set<class_2960> models = new HashSet<class_2960>();
    private final Map<class_1091, Supplier<class_1087>> specialModels = new HashMap<class_1091, Supplier<class_1087>>();
    private final List<Pair<Predicate<class_1091>, Function<class_1087, class_1087>>> modelOverwrites = new ArrayList<Pair<Predicate<class_1091>, Function<class_1087, class_1087>>>();
    private final List<Pair<Supplier<class_1299<?>>, Function<class_5617.class_5618, class_897<?>>>> entityRenderers = new ArrayList();
    private final List<Pair<Supplier<class_2591<?>>, Function<class_5614.class_5615, class_827<?>>>> blockEntityRenderers = new ArrayList();
    private final Map<class_2960, Set<class_2960>> textureAtlasSprites = new HashMap<class_2960, Set<class_2960>>();
    private final List<Pair<Supplier<class_1792>, Supplier<BuiltinItemRendererRegistry.DynamicItemRenderer>>> customItemRenderers = new ArrayList<Pair<Supplier<class_1792>, Supplier<BuiltinItemRendererRegistry.DynamicItemRenderer>>>();
    private final List<Pair<Supplier<class_3917<?>>, TriFunction<class_1703, class_1661, class_2561, class_437>>> containerScreens = new ArrayList();
    private final List<Pair<Supplier<class_2248>, Supplier<class_1921>>> blockRenderTypes = new ArrayList<Pair<Supplier<class_2248>, Supplier<class_1921>>>();
    private boolean passedModelRegistry;
    private boolean passedTextureStitch;

    @Deprecated
    @ApiStatus.Internal
    public static void registerRenderersInternal() {
        haveRenderersBeenRegistered = true;
        REGISTRATION_HELPER_MAP.values().forEach(ClientRegistrationHandler::registerRenderers);
    }

    @Deprecated
    @ApiStatus.Internal
    public static void registerModelOverwritesInternal(Map<class_1091, class_1087> modelRegistry) {
        haveModelsBeenRegistered = true;
        REGISTRATION_HELPER_MAP.values().forEach(handler -> handler.registerModelOverwrites(modelRegistry));
    }

    public static synchronized ClientRegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (modid.equals("minecraft")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        } else {
            ModContainer container = FabricLoader.getInstance().getModContainer(modid).orElse(null);
            if (container == null) {
                CoreLib.LOGGER.warn("Mod is requesting registration helper for unknown modid '" + modid + "'!");
            }
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, ClientRegistrationHandler::new);
    }

    @ApiStatus.Internal
    public static void collectSprites(class_2960 atlas, Consumer<class_2960> spriteConsumer) {
        for (ClientRegistrationHandler value : REGISTRATION_HELPER_MAP.values()) {
            value.addSprites(atlas, spriteConsumer);
        }
    }

    private ClientRegistrationHandler(String modid) {
        this.modid = modid;
        ModelLoadingPluginManager.registerPlugin(context -> this.handleModelRegistryEvent(arg_0 -> ((ModelLoadingPlugin.Context)context).addModels(arg_0)));
    }

    public void registerModel(class_2960 identifier) {
        if (this.passedModelRegistry) {
            throw new IllegalStateException("Cannot register new models after model registry has been completed!");
        }
        if (this.models.contains(identifier)) {
            throw new RuntimeException("Duplicate model location '" + String.valueOf(identifier) + "'!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model location '" + String.valueOf(identifier) + "'!");
        }
        this.models.add(identifier);
    }

    public void registerModel(String namespace, String identifier) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerModel(class_2960.method_60655((String)namespace, (String)identifier));
    }

    public void registerModel(String identifier) {
        this.registerModel(this.modid, identifier);
    }

    public void registerSpecialModel(String identifier, Supplier<class_1087> model) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new special models after model baking has completed!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        class_1091 fullIdentifier = new class_1091(class_2960.method_60655((String)this.modid, (String)identifier), "");
        if (this.specialModels.containsKey(fullIdentifier)) {
            throw new RuntimeException("Duplicate special model entry '" + String.valueOf(fullIdentifier) + "'!");
        }
        this.specialModels.put(fullIdentifier, model);
    }

    public void registerSpecialModel(String identifier, class_1087 model) {
        this.registerSpecialModel(identifier, () -> model);
    }

    public void registerModelOverwrite(class_1091 identifier, Function<class_1087, class_1087> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after model baking has completed!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model overwrite '" + String.valueOf(identifier) + "'!");
        }
        this.modelOverwrites.add(Pair.of(arg_0 -> ((class_1091)identifier).equals(arg_0), modelOverwrite));
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Function<class_1087, class_1087> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        if (!RegistryUtil.isValidPath(variant)) {
            throw new IllegalArgumentException("Variant '" + variant + "' must only contain characters [a-z0-9_./-]!");
        }
        class_1091 fullIdentifier = new class_1091(class_2960.method_60655((String)namespace, (String)identifier), variant);
        this.registerModelOverwrite(fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, Function<class_1087, class_1087> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, "", modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Supplier<class_1087> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (class_1087 model) -> (class_1087)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, Supplier<class_1087> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (class_1087 model) -> (class_1087)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, class_1087 modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (class_1087 model) -> modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, class_1087 modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (class_1087 model) -> modelOverwrite);
    }

    public void registerBlockModelOverwrite(Supplier<class_2248> block, Function<class_1087, class_1087> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        Holder blockIdentifierHolder = new Holder();
        this.modelOverwrites.add(Pair.of(identifier -> {
            class_2960 blockIdentifier = (class_2960)blockIdentifierHolder.get();
            if (blockIdentifier == null) {
                blockIdentifier = Registries.BLOCKS.getIdentifier((class_2248)block.get());
                blockIdentifierHolder.set(blockIdentifier);
            }
            return identifier.comp_2875().equals((Object)blockIdentifier);
        }, modelOverwrite));
    }

    public void registerBlockModelOverwrite(Supplier<class_2248> block, Supplier<class_1087> modelOverwrite) {
        this.registerBlockModelOverwrite(block, (class_1087 model) -> (class_1087)modelOverwrite.get());
    }

    public void registerBlockModelOverwrite(Supplier<class_2248> block, class_1087 modelOverwrite) {
        this.registerBlockModelOverwrite(block, (class_1087 model) -> modelOverwrite);
    }

    public void registerItemModelOverwrite(Supplier<class_1792> item, Function<class_1087, class_1087> modelOverwrite) {
        if (haveModelsBeenRegistered) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        Holder itemIdentifierHolder = new Holder();
        this.modelOverwrites.add(Pair.of(identifier -> {
            class_2960 itemIdentifier = (class_2960)itemIdentifierHolder.get();
            if (itemIdentifier == null) {
                itemIdentifier = Registries.ITEMS.getIdentifier((class_1792)item.get());
                itemIdentifierHolder.set(itemIdentifier);
            }
            return identifier.comp_2875().method_12836().equals(itemIdentifier.method_12836()) && identifier.comp_2875().method_12832().equals(itemIdentifier.method_12832()) && identifier.method_4740().equals("inventory");
        }, modelOverwrite));
    }

    public void registerItemModelOverwrite(Supplier<class_1792> item, Supplier<class_1087> modelOverwrite) {
        this.registerItemModelOverwrite(item, (class_1087 model) -> (class_1087)modelOverwrite.get());
    }

    public void registerItemModelOverwrite(Supplier<class_1792> item, class_1087 modelOverwrite) {
        this.registerItemModelOverwrite(item, (class_1087 model) -> modelOverwrite);
    }

    public <T extends class_1297> void registerEntityRenderer(Supplier<class_1299<T>> entityType, Function<class_5617.class_5618, class_897<? super T>> entityRenderer) {
        if (haveRenderersBeenRegistered) {
            throw new IllegalStateException("Cannot register new renderers after renderer registration has been completed!");
        }
        this.entityRenderers.add(Pair.of(entityType, entityRenderer));
    }

    public <T extends class_1297> void registerEntityRenderer(Supplier<class_1299<T>> entityType, Supplier<class_897<? super T>> entityRenderer) {
        this.registerEntityRenderer(entityType, (class_5617.class_5618 context) -> (class_897)entityRenderer.get());
    }

    public <T extends class_1297> void registerEntityRenderer(Supplier<class_1299<T>> entityType, class_897<? super T> entityRenderer) {
        this.registerEntityRenderer(entityType, (class_5617.class_5618 context) -> entityRenderer);
    }

    public <T extends class_2586> void registerBlockEntityRenderer(Supplier<class_2591<T>> entityType, Function<class_5614.class_5615, class_827<? super T>> blockEntityRenderer) {
        if (haveRenderersBeenRegistered) {
            throw new IllegalStateException("Cannot register new renderers after renderer registration has been completed!");
        }
        this.blockEntityRenderers.add(Pair.of(entityType, blockEntityRenderer));
    }

    public <T extends class_2586> void registerBlockEntityRenderer(Supplier<class_2591<T>> entityType, Supplier<class_827<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (class_5614.class_5615 context) -> (class_827)blockEntityRenderer.get());
    }

    public <T extends class_2586> void registerBlockEntityRenderer(Supplier<class_2591<T>> entityType, class_827<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (class_5614.class_5615 context) -> blockEntityRenderer);
    }

    public <T extends class_2586> void registerCustomBlockEntityRenderer(Supplier<class_2591<T>> entityType, Supplier<CustomBlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (class_5614.class_5615 context) -> CustomBlockEntityRenderer.of((CustomBlockEntityRenderer)blockEntityRenderer.get()));
    }

    public <T extends class_2586> void registerCustomBlockEntityRenderer(Supplier<class_2591<T>> entityType, CustomBlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (class_5614.class_5615 context) -> CustomBlockEntityRenderer.of(blockEntityRenderer));
    }

    public void registerAtlasSprite(class_2960 textureAtlas, class_2960 spriteLocation) {
        if (this.passedTextureStitch) {
            throw new IllegalStateException("Cannot register new models after texture stitching has been completed!");
        }
        if (textureAtlas == null) {
            throw new IllegalArgumentException("Texture atlas must not be null!");
        }
        if (textureAtlas.method_12832().startsWith("textures/atlas/") && textureAtlas.method_12832().endsWith(".png")) {
            textureAtlas = class_2960.method_60655((String)textureAtlas.method_12836(), (String)textureAtlas.method_12832().substring("textures/atlas/".length(), textureAtlas.method_12832().length() - ".png".length()));
        }
        this.textureAtlasSprites.putIfAbsent(textureAtlas, new HashSet());
        if (this.textureAtlasSprites.get(textureAtlas).contains(spriteLocation)) {
            throw new RuntimeException("Duplicate sprite registration '" + String.valueOf(spriteLocation) + "' for atlas '" + String.valueOf(textureAtlas) + "'!");
        }
        this.textureAtlasSprites.get(textureAtlas).add(spriteLocation);
    }

    public void registerAtlasSprite(class_2960 textureAtlas, String spriteLocation) {
        if (!RegistryUtil.isValidPath(spriteLocation)) {
            throw new IllegalArgumentException("Sprite location '" + spriteLocation + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerAtlasSprite(textureAtlas, class_2960.method_60655((String)this.modid, (String)spriteLocation));
    }

    public void registerItemRenderer(Supplier<class_1792> item, Supplier<BuiltinItemRendererRegistry.DynamicItemRenderer> itemRenderer) {
        if (haveRenderersBeenRegistered) {
            throw new IllegalStateException("Cannot register new renderers after renderer registration has been completed!");
        }
        this.customItemRenderers.add(Pair.of(item, itemRenderer));
    }

    public void registerItemRenderer(Supplier<class_1792> item, BuiltinItemRendererRegistry.DynamicItemRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> itemRenderer);
    }

    public void registerItemRenderer(class_1792 item, Supplier<BuiltinItemRendererRegistry.DynamicItemRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, itemRenderer);
    }

    public void registerItemRenderer(class_1792 item, BuiltinItemRendererRegistry.DynamicItemRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> itemRenderer);
    }

    public void registerCustomItemRenderer(Supplier<class_1792> item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(Supplier<class_1792> item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public void registerCustomItemRenderer(class_1792 item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(class_1792 item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public <T extends class_1703, U extends class_437> void registerContainerScreen(Supplier<class_3917<T>> menuType, TriFunction<T, class_1661, class_2561, U> screenSupplier) {
        if (haveRenderersBeenRegistered) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.containerScreens.add(Pair.of(menuType, screenSupplier));
    }

    public <T extends class_1703, U extends class_437> void registerContainerScreen(Supplier<class_3917<T>> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(menuType, (T container, class_1661 inventory, class_2561 title) -> (class_437)screenSupplier.apply(container));
    }

    public <T extends class_1703, U extends class_437> void registerContainerScreen(class_3917<T> menuType, TriFunction<T, class_1661, class_2561, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, screenSupplier);
    }

    public <T extends class_1703, U extends class_437> void registerContainerScreen(class_3917<T> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, (T container, class_1661 inventory, class_2561 title) -> (class_437)screenSupplier.apply(container));
    }

    public void registerBlockModelRenderType(Supplier<class_2248> block, Supplier<class_1921> renderTypeSupplier) {
        if (haveRenderersBeenRegistered) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.blockRenderTypes.add(Pair.of(block, renderTypeSupplier));
    }

    public void registerBlockModelRenderType(Supplier<class_2248> block, class_1921 renderType) {
        this.registerBlockModelRenderType(block, renderType);
    }

    public void registerBlockModelRenderType(class_2248 block, Supplier<class_1921> renderTypeSupplier) {
        this.registerBlockModelRenderType(() -> block, renderTypeSupplier);
    }

    public void registerBlockModelSolidRenderType(Supplier<class_2248> block) {
        this.registerBlockModelRenderType(block, class_1921::method_23577);
    }

    public void registerBlockModelSolidRenderType(class_2248 block) {
        this.registerBlockModelRenderType(block, class_1921::method_23577);
    }

    public void registerBlockModelCutoutMippedRenderType(Supplier<class_2248> block) {
        this.registerBlockModelRenderType(block, class_1921::method_23579);
    }

    public void registerBlockModelCutoutMippedRenderType(class_2248 block) {
        this.registerBlockModelRenderType(block, class_1921::method_23579);
    }

    public void registerBlockModelCutoutRenderType(Supplier<class_2248> block) {
        this.registerBlockModelRenderType(block, class_1921::method_23581);
    }

    public void registerBlockModelCutoutRenderType(class_2248 block) {
        this.registerBlockModelRenderType(block, class_1921::method_23581);
    }

    public void registerBlockModelTranslucentRenderType(Supplier<class_2248> block) {
        this.registerBlockModelRenderType(block, class_1921::method_23583);
    }

    public void registerBlockModelTranslucentRenderType(class_2248 block) {
        this.registerBlockModelRenderType(block, class_1921::method_23583);
    }

    private void registerRenderers() {
        HashSet entityTypes = new HashSet();
        for (Pair<Supplier<class_1299<?>>, Function<class_5617.class_5618, class_897<?>>> entry : this.entityRenderers) {
            class_1299<?> class_12992 = entry.left().get();
            if (class_12992 == null) {
                throw new RuntimeException("Entity renderer registered with null entity type!");
            }
            if (entityTypes.contains(class_12992)) {
                throw new RuntimeException("Duplicate entity renderer for entity type '" + String.valueOf(Registries.ENTITY_TYPES.getIdentifier(class_12992)) + "'!");
            }
            entityTypes.add(class_12992);
            EntityRendererRegistry.register(class_12992, ((Function)entry.right())::apply);
        }
        HashSet<class_2591> blockEntityTypes = new HashSet<class_2591>();
        for (Pair pair : this.blockEntityRenderers) {
            class_2591 class_25912 = (class_2591)((Supplier)pair.left()).get();
            if (class_25912 == null) {
                throw new RuntimeException("Block entity renderer registered with null block entity type!");
            }
            if (blockEntityTypes.contains(class_25912)) {
                throw new RuntimeException("Duplicate block entity renderer for block entity type '" + String.valueOf(Registries.BLOCK_ENTITY_TYPES.getIdentifier(class_25912)) + "'!");
            }
            blockEntityTypes.add(class_25912);
            BlockEntityRendererRegistry.register((class_2591)class_25912, ((Function)pair.right())::apply);
        }
        HashSet<class_1792> items = new HashSet<class_1792>();
        for (Pair<Supplier<class_1792>, Supplier<BuiltinItemRendererRegistry.DynamicItemRenderer>> pair : this.customItemRenderers) {
            class_1792 class_17922 = pair.left().get();
            if (class_17922 == null) {
                throw new RuntimeException("Custom item renderer registered with null item!");
            }
            if (items.contains(class_17922)) {
                throw new RuntimeException("Duplicate custom item renderer for item '" + String.valueOf(Registries.ITEMS.getIdentifier(class_17922)) + "'!");
            }
            BuiltinItemRendererRegistry.DynamicItemRenderer customRenderer = pair.right().get();
            if (customRenderer == null) {
                throw new RuntimeException("Got null custom item renderer for item '" + String.valueOf(Registries.ITEMS.getIdentifier(class_17922)) + "'!");
            }
            items.add(class_17922);
            BuiltinItemRendererRegistry.INSTANCE.register((class_1935)class_17922, customRenderer);
        }
        HashSet hashSet = new HashSet();
        for (Pair<Supplier<class_3917<?>>, TriFunction<class_1703, class_1661, class_2561, class_437>> pair : this.containerScreens) {
            class_3917<?> menuType = pair.left().get();
            if (menuType == null) {
                throw new RuntimeException("Container screen registered with null menu type!");
            }
            if (hashSet.contains(menuType)) {
                throw new RuntimeException("Duplicate container screen for menu type '" + String.valueOf(Registries.MENU_TYPES.getIdentifier(menuType)) + "'!");
            }
            hashSet.add(menuType);
            class_3929.method_17542(menuType, pair.right()::apply);
        }
        HashSet<class_2248> hashSet2 = new HashSet<class_2248>();
        for (Pair<Supplier<class_2248>, Supplier<class_1921>> entry : this.blockRenderTypes) {
            class_2248 block = entry.left().get();
            if (block == null) {
                throw new RuntimeException("Block render type registered for null block!");
            }
            if (hashSet2.contains(block)) {
                throw new RuntimeException("Duplicate render type for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            class_1921 renderType = entry.right().get();
            if (renderType == null) {
                throw new RuntimeException("Got null render type for block '" + String.valueOf(Registries.BLOCKS.getIdentifier(block)) + "'!");
            }
            hashSet2.add(block);
            BlockRenderLayerMap.INSTANCE.putBlock(block, renderType);
        }
    }

    private void handleModelRegistryEvent(Consumer<Collection<class_2960>> out) {
        this.passedModelRegistry = true;
        out.accept(this.models);
    }

    private void registerModelOverwrites(Map<class_1091, class_1087> modelRegistry) {
        for (Map.Entry<class_1091, Supplier<class_1087>> entry : this.specialModels.entrySet()) {
            class_1091 identifier2 = entry.getKey();
            if (modelRegistry.containsKey(identifier2)) {
                throw new RuntimeException("Special model '" + String.valueOf(identifier2) + "' is trying to overwrite another model!");
            }
            class_1087 model = entry.getValue().get();
            if (model == null) {
                throw new RuntimeException("Got null object for special model '" + String.valueOf(entry.getKey()) + "'!");
            }
            modelRegistry.put(entry.getKey(), model);
        }
        for (Pair pair : this.modelOverwrites) {
            List modelIdentifiers = modelRegistry.keySet().stream().filter(identifier -> ((Predicate)pair.left()).test(identifier)).collect(Collectors.toList());
            for (class_1091 identifier3 : modelIdentifiers) {
                if (!modelRegistry.containsKey(identifier3)) {
                    throw new RuntimeException("No model registered for model overwrite '" + String.valueOf(identifier3) + "'!");
                }
                class_1087 model = modelRegistry.get(identifier3);
                model = (class_1087)((Function)pair.right()).apply(model);
                if (model == null) {
                    throw new RuntimeException("Model overwrite for '" + String.valueOf(identifier3) + "' returned a null model!");
                }
                modelRegistry.put(identifier3, model);
            }
        }
    }

    private void addSprites(class_2960 atlas, Consumer<class_2960> spriteConsumer) {
        this.passedTextureStitch = true;
        Set<class_2960> sprites = this.textureAtlasSprites.get(atlas);
        if (sprites == null) {
            return;
        }
        sprites.forEach(spriteConsumer);
    }
}

