/*
 * Decompiled with CFR 0.152.
 */
package com.peter.blockRenderers;

import com.peter.CityBlocksClient;
import com.peter.blocks.signs.CustomSignBlockEntity;
import com.peter.blocks.signs.TextLineInfo;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Vector2f;
import org.joml.Vector3d;

@Environment(value=EnvType.CLIENT)
public class CustomSignBlockEntityRenderer
implements class_827<CustomSignBlockEntity> {
    private final class_327 textRenderer;

    public CustomSignBlockEntityRenderer(class_5614.class_5615 context) {
        this.textRenderer = context.method_32143();
    }

    public void render(CustomSignBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22903();
        class_2350 facing = entity.getFacing();
        matrices.method_22904(0.5, 0.5, 0.5);
        switch (facing) {
            case field_11043: {
                break;
            }
            case field_11034: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                break;
            }
            case field_11035: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
        }
        matrices.method_22904(-0.5, -0.5, -0.5);
        if (!entity.isTextOnly()) {
            CustomSignBlockEntityRenderer.drawTexture(vertexConsumers, matrices, entity, light);
        }
        if (entity.getMaxTextLines() > 0) {
            String[] lines = entity.getText();
            TextLineInfo[] info = entity.getTextInfo();
            for (int l = 0; l < info.length; ++l) {
                TextLineInfo lineInfo = info[l];
                this.renderText(vertexConsumers, matrices, light, lines[lineInfo.lineN], lineInfo);
            }
        }
        matrices.method_22909();
    }

    private static void drawTexture(class_4597 vertexConsumerProvider, class_4587 matrices, CustomSignBlockEntity entity, int light) {
        class_4587.class_4665 matrix = matrices.method_23760();
        class_4730 spriteId = CityBlocksClient.blockTexture(entity.getTexture());
        class_4588 vertexConsumer = spriteId.method_24145(vertexConsumerProvider, class_1921::method_23576);
        class_1058 sprite = spriteId.method_24148();
        Vector2f textureUVSize = entity.getTextureUVSize();
        float minU = sprite.method_4594();
        float maxU = sprite.method_4577();
        float uSize = maxU - minU;
        maxU = minU + uSize * textureUVSize.x;
        float minV = sprite.method_4593();
        float maxV = sprite.method_4575();
        float vSize = maxV - minV;
        maxV = minV + vSize * textureUVSize.y;
        Vector3d pos = entity.getTexturePosition().div(16.0);
        Vector3d size = entity.getTextureSize().div(16.0);
        CustomSignBlockEntityRenderer.addVertex(vertexConsumer, matrix, pos.x, pos.y, pos.z, minU, maxV, light);
        CustomSignBlockEntityRenderer.addVertex(vertexConsumer, matrix, pos.x + size.x, pos.y, pos.z, maxU, maxV, light);
        CustomSignBlockEntityRenderer.addVertex(vertexConsumer, matrix, pos.x + size.x, pos.y + size.y, pos.z, maxU, minV, light);
        CustomSignBlockEntityRenderer.addVertex(vertexConsumer, matrix, pos.x, pos.y + size.y, pos.z, minU, minV, light);
    }

    private static void addVertex(class_4588 vertices, class_4587.class_4665 matrix, double x, double y, double z, float u, float v, int light) {
        vertices.method_56824(matrix, (float)x, (float)y, (float)z).method_1336(-1, -1, -1, -1).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_60831(matrix, 0.0f, 1.0f, 0.0f);
    }

    public void renderText(class_4597 vertexConsumerProvider, class_4587 matrices, int light, String text, TextLineInfo info) {
        float sF;
        matrices.method_22903();
        if (info.rotation != 0.0f) {
            matrices.method_22904(0.5, 0.5, 0.5);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(info.rotation));
            matrices.method_22904(-0.5, -0.5, -0.5);
        }
        Objects.requireNonNull(this.textRenderer);
        float textHeight = 9.0f;
        float y = 0.0f;
        matrices.method_46416(info.position.x / 16.0f, info.position.y / 16.0f, info.position.z / 16.0f);
        float textScale = info.scale * 0.015625f;
        if (info.maxWidth > 0.0f && (sF = info.maxWidth / 16.0f / (float)this.textRenderer.method_1727(text)) < textScale) {
            float diff = sF - textScale;
            textScale = sF;
            matrices.method_46416(0.0f, textHeight * diff * 0.5f, 0.0f);
        }
        matrices.method_22905(textScale, -textScale, textScale);
        float x = 0.0f;
        if (info.centered) {
            x = (float)(-this.textRenderer.method_1727(text)) / 2.0f;
        }
        this.textRenderer.method_27521(text, x, y, info.color, false, matrices.method_23760().method_23761(), vertexConsumerProvider, class_327.class_6415.field_33995, 0, light);
        matrices.method_22909();
    }
}

