/*
 * Decompiled with CFR 0.152.
 */
package com.peter.blocks.signal;

import com.peter.blocks.signal.LampState;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class CycleState {
    public LampState[][] states = new LampState[24][];
    public int time;
    private static final String NBT_TIME = "time";
    private static final String NBT_STATES = "states";

    public CycleState() {
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = new LampState[]{LampState.SOLID, LampState.OFF, LampState.OFF};
        }
        this.time = -1;
    }

    public CycleState(int time) {
        this();
        this.time = time;
    }

    public CycleState(int time, LampState[] defaultState) {
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = (LampState[])defaultState.clone();
        }
        this.time = time;
    }

    public void set(int head, LampState[] lampStates) {
        this.states[head] = (LampState[])lampStates.clone();
    }

    public LampState[] getState(int head) {
        return this.states[head];
    }

    public class_2487 toNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10569(NBT_TIME, this.time);
        class_2499 statesNbt = new class_2499();
        nbt.method_10566(NBT_STATES, (class_2520)statesNbt);
        for (int i = 0; i < this.states.length; ++i) {
            statesNbt.add((Object)new class_2495(LampState.toIntArray(this.states[i])));
        }
        return nbt;
    }

    public static CycleState fromNbt(class_2487 nbt) {
        CycleState state = new CycleState();
        if (nbt.method_10545(NBT_TIME)) {
            state.time = nbt.method_10550(NBT_TIME);
        }
        if (nbt.method_10545(NBT_STATES)) {
            class_2499 stateList = (class_2499)nbt.method_10580(NBT_STATES);
            for (int i = 0; i < state.states.length; ++i) {
                state.states[i] = LampState.fromIntArray(stateList.method_36111(i));
            }
        }
        return state;
    }
}

