/*
 * Decompiled with CFR 0.152.
 */
package com.peter.blocks.signal;

import com.peter.CityBlocks;
import com.peter.blocks.signal.Cycle;
import com.peter.blocks.signal.LampState;
import com.peter.blocks.signal.PedestrianSignalBlock;
import com.peter.blocks.signal.PedestrianSignalBlockEntity;
import com.peter.blocks.signal.SignalControllerBlock;
import com.peter.blocks.signal.SignalControllerPeripheral;
import com.peter.blocks.signal.SignalHeadBlock;
import com.peter.blocks.signal.SignalHeadBlockEntity;
import com.peter.gui.SignalControllerScreenHandler;
import com.peter.networking.BlockPosScreenPacket;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import java.util.ArrayList;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class SignalControllerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<BlockPosScreenPacket> {
    public static final String NAME = "signal_controller_entity";
    public static final class_2960 ID = CityBlocks.identifier("signal_controller_entity");
    public static final class_2591<SignalControllerBlockEntity> BLOCK_ENTITY_TYPE = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)ID, (Object)class_2591.class_2592.method_20528(SignalControllerBlockEntity::new, (class_2248[])new class_2248[]{SignalControllerBlock.BLOCK}).build());
    public static final int MAX_HEADS = 24;
    private Cycle[] cycles = new Cycle[3];
    private int cycleMode = 0;
    private int cPhase = 0;
    private int cTime = 0;
    private ArrayList<class_2338> heads;
    private ArrayList<class_2338> pedestrians;
    private LampState[][] tempState = new LampState[24][];
    private boolean tempChanged = false;
    private final SignalControllerPeripheral peripheral = new SignalControllerPeripheral(this);
    private static final String NBT_CYCLE_MODE = "cycleMode";
    private static final String NBT_C_PHASE = "cPhase";
    private static final String NBT_C_TIME = "cTime";
    private static final String NBT_HEADS = "heads";
    private static final String NBT_PEDESTRIAN = "pedestrian";
    private static final String NBT_TEMP_STATE = "tempState";

    public static void register() {
        PeripheralLookup.get().registerForBlockEntity(SignalControllerBlockEntity::getPeripheral, BLOCK_ENTITY_TYPE);
    }

    public SignalControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
        this.heads = new ArrayList();
        this.pedestrians = new ArrayList();
        this.cycles[0] = Cycle.basicSwitchCycle(200, 60, 40);
        this.cycles[1] = Cycle.basic3WayCycle(200, 60, 40);
        this.cycles[2] = Cycle.basic4WayCycle(200, 60, 40);
        for (int i = 0; i < this.tempState.length; ++i) {
            this.tempState[i] = new LampState[]{LampState.SOLID_FLASH, LampState.OFF, LampState.OFF};
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, SignalControllerBlockEntity blockEntity) {
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, SignalControllerBlockEntity blockEntity) {
        blockEntity.serverTick(world, pos, state);
    }

    private void serverTick(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.cycleMode == -1) {
            this.foreachHead(head -> head.setStates(new LampState[]{LampState.SOLID_FLASH, LampState.OFF, LampState.OFF}));
            this.foreachPedestrian(signal -> signal.setState(3));
        } else if (this.cycleMode >= 0) {
            ++this.cTime;
            this.method_5431();
            if (this.cycles[this.cycleMode].cycleStates[this.cPhase].time <= this.cTime) {
                this.cycle();
            }
        }
        if (this.tempChanged) {
            this.foreachHead(head -> head.setStates(this.tempState[head.headId]));
            this.foreachPedestrian(signal -> {
                LampState[] states = this.tempState[signal.headId];
                if (states[0] != LampState.OFF) {
                    signal.setState(3);
                } else if (states[1] != LampState.OFF) {
                    signal.setState(2);
                } else if (states[2] != LampState.OFF) {
                    signal.setState(1);
                } else {
                    signal.setState(0);
                }
            });
            this.tempChanged = false;
            this.method_5431();
        }
    }

    public void cycle(class_1657 player) {
        this.cycle();
        player.method_43496((class_2561)CityBlocks.translatableText("chat", "signal_controller.cycle", this.cPhase));
    }

    public void cycle() {
        if (this.cycleMode < 0) {
            return;
        }
        ++this.cPhase;
        this.cTime = 0;
        if (this.cPhase > this.cycles[this.cycleMode].maxPhase) {
            this.cPhase = 0;
        }
        this.updateHeads();
        this.method_5431();
    }

    private void updateHeads() {
        if (this.cycleMode < 0) {
            return;
        }
        this.foreachHead(head -> head.setStates(this.cycles[this.cycleMode].cycleStates[this.cPhase].getState(head.getHeadId())));
        this.foreachPedestrian(signal -> {
            LampState[] states = this.cycles[this.cycleMode].cycleStates[this.cPhase].getState(signal.getHeadId());
            if (states[0] != LampState.OFF) {
                signal.setState(3);
            } else if (states[1] != LampState.OFF) {
                signal.setState(2);
            } else if (states[2] != LampState.OFF) {
                signal.setState(1);
            } else {
                signal.setState(0);
            }
        });
        for (int i = 0; i < 24; ++i) {
            this.tempState[i] = this.cycles[this.cycleMode].cycleStates[this.cPhase].getState(i);
        }
    }

    private void foreachHead(SignalHeadForeach runnable) {
        ArrayList<class_2338> toRemove = new ArrayList<class_2338>();
        for (class_2338 pos : this.heads) {
            class_2586 blockEntity = this.field_11863.method_8321(pos);
            if (blockEntity instanceof SignalHeadBlockEntity) {
                runnable.run((SignalHeadBlockEntity)blockEntity);
                continue;
            }
            if (!this.field_11863.method_8320(pos).method_27852(SignalHeadBlock.BLOCK)) {
                toRemove.add(pos);
                continue;
            }
            CityBlocks.LOGGER.warn(String.format("Could not find signal head at %d,%d,%d", pos.method_10263(), pos.method_10264(), pos.method_10260()));
        }
        if (toRemove.size() > 0) {
            for (class_2338 blockPos : toRemove) {
                this.heads.remove(blockPos);
                CityBlocks.LOGGER.warn(String.format("Could not find signal head at %d,%d,%d, removing from list", this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260()));
            }
            this.method_5431();
        }
    }

    private void foreachPedestrian(PedestrianSignalForeach runnable) {
        ArrayList<class_2338> toRemove = new ArrayList<class_2338>();
        for (class_2338 pos : this.pedestrians) {
            class_2586 blockEntity = this.field_11863.method_8321(pos);
            if (blockEntity instanceof PedestrianSignalBlockEntity) {
                runnable.run((PedestrianSignalBlockEntity)blockEntity);
                continue;
            }
            if (!this.field_11863.method_8320(pos).method_27852(PedestrianSignalBlock.BLOCK)) {
                toRemove.add(pos);
                continue;
            }
            CityBlocks.LOGGER.warn(String.format("Could not find pedestrian signal at %d,%d,%d", pos.method_10263(), pos.method_10264(), pos.method_10260()));
        }
        if (toRemove.size() > 0) {
            for (class_2338 blockPos : toRemove) {
                this.pedestrians.remove(blockPos);
                CityBlocks.LOGGER.warn(String.format("Could not find pedestrian signal at %d,%d,%d, removing from list", this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260()));
            }
            this.method_5431();
        }
    }

    public class_2561 method_5476() {
        return CityBlocks.translatableText("block", "signal_controller");
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SignalControllerScreenHandler(syncId, playerInventory, this.getScreenOpeningData((class_3222)player));
    }

    public BlockPosScreenPacket getScreenOpeningData(class_3222 player) {
        return new BlockPosScreenPacket(this.field_11867);
    }

    public boolean link(class_2338 pos) {
        class_2680 blockState = this.field_11863.method_8320(pos);
        if (blockState.method_27852(SignalHeadBlock.BLOCK)) {
            if (this.heads.contains(pos)) {
                this.heads.remove(pos);
                this.method_5431();
                return false;
            }
            this.heads.add(pos);
            this.method_5431();
            SignalHeadBlockEntity head = (SignalHeadBlockEntity)this.field_11863.method_8321(pos);
            if (head != null) {
                head.setStates(this.tempState[head.headId]);
            }
        } else if (blockState.method_27852(PedestrianSignalBlock.BLOCK)) {
            if (this.pedestrians.contains(pos)) {
                this.pedestrians.remove(pos);
                this.method_5431();
                return false;
            }
            this.pedestrians.add(pos);
            this.method_5431();
            PedestrianSignalBlockEntity signal = (PedestrianSignalBlockEntity)this.field_11863.method_8321(pos);
            if (signal != null) {
                LampState[] states = this.tempState[signal.headId];
                if (states[0] != LampState.OFF) {
                    signal.setState(3);
                } else if (states[1] != LampState.OFF) {
                    signal.setState(2);
                } else if (states[2] != LampState.OFF) {
                    signal.setState(1);
                } else {
                    signal.setState(0);
                }
            }
        } else {
            CityBlocks.LOGGER.error("Tried to link signal controller to unknown block: " + blockState.toString());
        }
        return true;
    }

    public int getCyclePhase() {
        return this.cPhase;
    }

    public int getCycleMode() {
        return this.cycleMode;
    }

    public int getCycleModeMax() {
        return this.cycles.length;
    }

    public String getCycleModeName() {
        if (this.cycleMode == -2) {
            return "Peripheral Control";
        }
        if (this.cycleMode == -1) {
            return "Uncontrolled / Error";
        }
        return this.cycles[this.cycleMode].name;
    }

    public int getCyclePhaseMax() {
        if (this.cycleMode < 0) {
            return -1;
        }
        return this.cycles[this.cycleMode].maxPhase;
    }

    public int getCycleTime() {
        return this.cTime;
    }

    public int getCycleTimeMax() {
        if (this.cycleMode < 0) {
            return -1;
        }
        return this.cycles[this.cycleMode].cycleStates[this.cPhase].time;
    }

    public void setCycleMode(int mode) {
        if (this.field_11863.field_9236) {
            return;
        }
        this.cycleMode = mode;
        this.cPhase = 0;
        if (this.cycleMode <= -1) {
            this.cycleMode = -1;
        } else if (this.cycleMode > this.cycles.length) {
            this.cycleMode = this.cycles.length;
        }
        if (this.cycleMode == -1) {
            this.foreachHead(head -> head.setStates(new LampState[]{LampState.SOLID_FLASH, LampState.OFF, LampState.OFF}));
            this.foreachPedestrian(signal -> signal.setState(3));
        } else if (this.cycleMode >= 0) {
            this.updateHeads();
        }
        this.method_5431();
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10569(NBT_CYCLE_MODE, this.cycleMode);
        nbt.method_10569(NBT_C_PHASE, this.cPhase);
        nbt.method_10569(NBT_C_TIME, this.cTime);
        class_2499 headsNbt = new class_2499();
        for (class_2338 class_23382 : this.heads) {
            headsNbt.add((Object)new class_2495(new int[]{class_23382.method_10263(), class_23382.method_10264(), class_23382.method_10260()}));
        }
        nbt.method_10566(NBT_HEADS, (class_2520)headsNbt);
        class_2499 pedestriansNbt = new class_2499();
        for (class_2338 signal : this.pedestrians) {
            pedestriansNbt.add((Object)new class_2495(new int[]{signal.method_10263(), signal.method_10264(), signal.method_10260()}));
        }
        nbt.method_10566(NBT_PEDESTRIAN, (class_2520)pedestriansNbt);
        class_2499 class_24992 = new class_2499();
        for (int i = 0; i < this.tempState.length; ++i) {
            class_24992.add((Object)new class_2495(LampState.toIntArray(this.tempState[i])));
        }
        nbt.method_10566(NBT_TEMP_STATE, (class_2520)class_24992);
        super.method_11007(nbt, registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int[] pos;
        int i;
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10545(NBT_CYCLE_MODE)) {
            this.cycleMode = nbt.method_10550(NBT_CYCLE_MODE);
        }
        if (nbt.method_10545(NBT_C_PHASE)) {
            this.cPhase = nbt.method_10550(NBT_C_PHASE);
            if (this.cPhase < 0) {
                this.cPhase = 0;
            }
        }
        if (nbt.method_10545(NBT_C_TIME)) {
            this.cTime = nbt.method_10550(NBT_C_TIME);
        }
        if (nbt.method_10545(NBT_HEADS)) {
            class_2499 headsNbt = (class_2499)nbt.method_10580(NBT_HEADS);
            for (i = 0; i < headsNbt.size(); ++i) {
                pos = headsNbt.method_36111(i);
                this.heads.add(new class_2338(pos[0], pos[1], pos[2]));
            }
        }
        if (nbt.method_10545(NBT_PEDESTRIAN)) {
            class_2499 pedestriansNbt = (class_2499)nbt.method_10580(NBT_PEDESTRIAN);
            for (i = 0; i < pedestriansNbt.size(); ++i) {
                pos = pedestriansNbt.method_36111(i);
                this.pedestrians.add(new class_2338(pos[0], pos[1], pos[2]));
            }
        }
        if (nbt.method_10545(NBT_TEMP_STATE)) {
            class_2499 tempStateNbt = (class_2499)nbt.method_10580(NBT_TEMP_STATE);
            for (i = 0; i < tempStateNbt.size(); ++i) {
                this.tempState[i] = LampState.fromIntArray(tempStateNbt.method_36111(i));
            }
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public void method_5431() {
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        super.method_5431();
    }

    public LampState[] getStates(int head) {
        return this.tempState[head];
    }

    public void api_setHeadState(int headId, int[] state) {
        this.cycleMode = -2;
        this.cTime = 0;
        for (int i = 0; i < state.length; ++i) {
            this.tempState[headId][i] = LampState.fromCode(state[i]);
        }
        this.tempChanged = true;
        if (this.field_11863.field_9236) {
            System.err.println("thing-ing");
        }
    }

    public SignalControllerPeripheral getPeripheral() {
        return this.peripheral;
    }

    public SignalControllerPeripheral getPeripheral(class_2350 direction) {
        return this.getPeripheral();
    }

    private static interface SignalHeadForeach {
        public void run(SignalHeadBlockEntity var1);
    }

    private static interface PedestrianSignalForeach {
        public void run(PedestrianSignalBlockEntity var1);
    }
}

