/*
 * Decompiled with CFR 0.152.
 */
package com.peter.blocks.signs;

import com.peter.blocks.signs.CustomSignBlock;
import com.peter.blocks.signs.SignSticker;
import com.peter.blocks.signs.TextLineInfo;
import com.peter.gui.CustomSignScreenHandler;
import com.peter.networking.BlockPosScreenPacket;
import java.util.ArrayList;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.joml.Vector2f;
import org.joml.Vector3d;

public class CustomSignBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<BlockPosScreenPacket> {
    private final class_2561 screenName;
    private int variant = 0;
    private String[] text = new String[0];
    private ArrayList<SignSticker> stickers = new ArrayList();
    public static final String NBT_VARIANT = "variant";
    public static final String NBT_TEXT = "text";
    public static final String NBT_STICKERS = "stickers";
    public static final String NBT_BLOCK_STATE = "block_state";

    public CustomSignBlockEntity(class_2591<? extends CustomSignBlockEntity> type, class_2338 pos, class_2680 state, class_2561 screenName) {
        super(type, pos, state);
        this.screenName = screenName;
    }

    public CustomSignBlock getBlock() {
        return (CustomSignBlock)this.method_11010().method_26204();
    }

    public int getVariant() {
        int maxV = this.getMaxVariant();
        if (this.variant > maxV) {
            this.variant = maxV;
            this.method_5431();
        }
        return this.variant;
    }

    public void setVariant(int variant) {
        boolean changed = this.variant != variant;
        this.variant = variant;
        int maxV = this.getMaxVariant();
        if (variant > maxV) {
            variant = maxV;
            changed = true;
        }
        if (changed) {
            this.text = new String[this.getMaxTextLines()];
            for (int i = 0; i < this.text.length; ++i) {
                this.text[i] = "";
            }
            TextLineInfo[] textInfo = this.getTextInfo();
            for (int i = 0; i < textInfo.length; ++i) {
                if (textInfo[i].defaultText == null) continue;
                this.text[textInfo[i].lineN] = textInfo[i].defaultText;
            }
            this.method_5431();
        }
    }

    public int getMaxVariant() {
        return this.getBlock().getMaxVariant(this.method_11010());
    }

    public String getTexture() {
        return this.getBlock().getTexture(this.method_11010(), this.getVariant());
    }

    public String[] getText() {
        if (this.text.length != this.getMaxTextLines()) {
            this.text = new String[this.getMaxTextLines()];
            for (int i = 0; i < this.text.length; ++i) {
                this.text[i] = "";
            }
            TextLineInfo[] textInfo = this.getTextInfo();
            for (int i = 0; i < textInfo.length; ++i) {
                if (textInfo[i].defaultText == null) continue;
                this.text[textInfo[i].lineN] = textInfo[i].defaultText;
            }
            this.method_5431();
        }
        return this.text;
    }

    public void setText(String[] text) {
        int nLines = this.getMaxTextLines();
        this.text = new String[nLines];
        if (text.length > nLines) {
            for (int i = 0; i < nLines; ++i) {
                this.text[i] = text[i];
            }
        } else {
            int i;
            for (i = 0; i < text.length; ++i) {
                this.text[i] = text[i];
            }
            if (text.length < nLines) {
                for (i = text.length; i < nLines; ++i) {
                    this.text[i] = "";
                }
                TextLineInfo[] textInfo = this.getTextInfo();
                for (int i2 = 0; i2 < textInfo.length; ++i2) {
                    if (textInfo[i2].defaultText == null || textInfo[i2].lineN < text.length) continue;
                    text[textInfo[i2].lineN] = textInfo[i2].defaultText;
                }
            }
        }
        this.method_5431();
    }

    public String getLineText(int line) {
        if (line < 0 || line > this.getMaxTextLines()) {
            return "";
        }
        return this.text[line];
    }

    public void setLineText(int line, String text) {
        if (line < 0 || line > this.getMaxTextLines()) {
            return;
        }
        this.text[line] = text;
    }

    public int getMaxTextLines() {
        return this.getBlock().getMaxTextLines(this.method_11010(), this.getVariant());
    }

    public int getMaxTextLines(int texture) {
        return this.getBlock().getMaxTextLines(this.method_11010(), texture);
    }

    public SignSticker[] getStickers() {
        return this.stickers.toArray(new SignSticker[0]);
    }

    public Vector3d getTexturePosition() {
        return this.getBlock().getTexturePosition(this.method_11010(), this.getVariant());
    }

    public Vector3d getTextureSize() {
        return this.getBlock().getTextureSize(this.method_11010(), this.getVariant());
    }

    public Vector2f getTextureUVSize() {
        return this.getBlock().getTextureUVSize(this.method_11010(), this.getVariant());
    }

    public class_2350 getFacing() {
        return this.getBlock().getFacing(this.method_11010());
    }

    public String[] getVariantNames() {
        return this.getBlock().getVariantNames(this.method_11010());
    }

    public TextLineInfo[] getTextInfo() {
        return this.getBlock().getTextInfo(this.method_11010(), this.getVariant());
    }

    public class_2561 method_5476() {
        return this.screenName;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int i;
        super.method_11007(nbt, registryLookup);
        nbt.method_10569(NBT_VARIANT, this.variant);
        if (this.text.length > 0) {
            class_2499 textList = new class_2499();
            for (i = 0; i < this.text.length; ++i) {
                textList.add((Object)class_2519.method_23256((String)this.text[i]));
            }
            nbt.method_10566(NBT_TEXT, (class_2520)textList);
        }
        if (this.stickers.size() > 0) {
            class_2499 stickersList = new class_2499();
            for (i = 0; i < this.stickers.size(); ++i) {
                stickersList.add((Object)this.stickers.get(i).toNbt());
            }
            nbt.method_10566(NBT_STICKERS, (class_2520)stickersList);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10545(NBT_VARIANT)) {
            this.variant = nbt.method_10550(NBT_VARIANT);
            int maxV = this.getMaxVariant();
            if (this.variant > maxV) {
                this.variant = maxV;
            }
        }
        if (nbt.method_10545(NBT_TEXT)) {
            class_2499 textList = (class_2499)nbt.method_10580(NBT_TEXT);
            int nLines = this.getMaxTextLines();
            this.text = new String[nLines];
            if (textList.size() > nLines) {
                for (int i = 0; i < nLines; ++i) {
                    this.text[i] = textList.method_10608(i);
                }
            } else {
                int i;
                for (i = 0; i < textList.size(); ++i) {
                    this.text[i] = textList.method_10608(i);
                }
                for (i = textList.size(); i < nLines; ++i) {
                    this.text[i] = "";
                }
                TextLineInfo[] textInfo = this.getTextInfo();
                for (int i2 = 0; i2 < textInfo.length; ++i2) {
                    if (textInfo[i2].defaultText == null || textInfo[i2].lineN < textList.size()) continue;
                    this.text[textInfo[i2].lineN] = textInfo[i2].defaultText;
                }
            }
        }
        if (nbt.method_10545(NBT_STICKERS)) {
            class_2499 stickerList = (class_2499)nbt.method_10580(NBT_STICKERS);
            this.stickers = new ArrayList();
            for (int i = 0; i < stickerList.size(); ++i) {
                this.stickers.add(SignSticker.fromNbt(stickerList.method_10602(i)));
            }
        }
    }

    public void method_38240(class_1799 stack, class_7225.class_7874 registries) {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt, registries);
        nbt.method_10566(NBT_BLOCK_STATE, (class_2520)this.getBlock().getNbt(this.method_11010(), this.variant));
        class_1747.method_57338((class_1799)stack, (class_2591)this.method_11017(), (class_2487)nbt);
        stack.method_57365(this.method_57590());
    }

    public void method_5431() {
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 2);
        super.method_5431();
    }

    public void markDirty(class_2680 state) {
        this.field_11863.method_8413(this.field_11867, this.method_11010(), state, 2);
        super.method_5431();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new CustomSignScreenHandler(syncId, playerInventory, this.getScreenOpeningData((class_3222)player));
    }

    public BlockPosScreenPacket getScreenOpeningData(class_3222 player) {
        return new BlockPosScreenPacket(this.field_11867);
    }

    public boolean isTextOnly() {
        return this.getBlock().isTextOnly(this.method_11010(), this.variant);
    }

    public static class_2487 getNbtFromStack(class_1799 stack) {
        class_9279 nbtComp = (class_9279)stack.method_57825(class_9334.field_49611, (Object)class_9279.field_49302);
        if (!nbtComp.method_57458()) {
            return nbtComp.method_57461();
        }
        return null;
    }

    public static class_2487 getBlockStateNbtFromStack(class_1799 stack) {
        class_9279 nbtComp = (class_9279)stack.method_57825(class_9334.field_49611, (Object)class_9279.field_49302);
        if (!nbtComp.method_57458()) {
            class_2487 nbt = nbtComp.method_57461();
            return nbt.method_10562(NBT_BLOCK_STATE);
        }
        return null;
    }
}

