/*
 * Decompiled with CFR 0.152.
 */
package com.peter.networking;

import com.peter.blocks.signal.LampColor;
import com.peter.blocks.signal.LampState;
import com.peter.blocks.signal.PedestrianSignalBlockEntity;
import com.peter.blocks.signal.SignalControllerBlockEntity;
import com.peter.blocks.signal.SignalHeadBlockEntity;
import com.peter.blocks.signs.CustomSignBlockEntity;
import com.peter.networking.CustomSignUpdatePayload;
import com.peter.networking.PedestrianSignalUpdatePayload;
import com.peter.networking.SignalControllerUpdatePayload;
import com.peter.networking.SignalHeadUpdatePayload;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class CityBlocksClientNetworking {
    public static void sendHeadUpdate(SignalHeadBlockEntity entity, int lamp, LampState newState, LampColor newColor, int newHeadId) {
        ClientPlayNetworking.send((class_8710)new SignalHeadUpdatePayload((class_5321<class_1937>)entity.method_10997().method_27983(), entity.method_11016(), lamp, newState.code, newColor.code, newHeadId));
    }

    public static void sendHeadStateUpdate(SignalHeadBlockEntity entity, int lamp, LampState newState) {
        CityBlocksClientNetworking.sendHeadUpdate(entity, lamp, newState, LampColor.NULL, -1);
    }

    public static void sendHeadColorUpdate(SignalHeadBlockEntity entity, int lamp, LampColor newColor) {
        CityBlocksClientNetworking.sendHeadUpdate(entity, lamp, LampState.NULL, newColor, -1);
    }

    public static void sendHeadIDUpdate(SignalHeadBlockEntity entity, int newHeadId) {
        CityBlocksClientNetworking.sendHeadUpdate(entity, -1, LampState.NULL, LampColor.NULL, newHeadId);
    }

    public static void sendControllerCycleModeUpdate(SignalControllerBlockEntity entity, int newCycleMode) {
        ClientPlayNetworking.send((class_8710)new SignalControllerUpdatePayload((class_5321<class_1937>)entity.method_10997().method_27983(), entity.method_11016(), newCycleMode));
    }

    public static void sendCustomSignVariantUpdate(CustomSignBlockEntity signEntity, int variant) {
        CityBlocksClientNetworking.sendCustomSignUpdate(signEntity, variant, false, null);
    }

    public static void sendCustomSignTextUpdate(CustomSignBlockEntity signEntity, String[] text) {
        CityBlocksClientNetworking.sendCustomSignUpdate(signEntity, -1, true, text);
    }

    public static void sendCustomSignTextUpdate(CustomSignBlockEntity signEntity, int lineN, String line) {
        String[] text = signEntity.getText();
        text[lineN] = line;
        CityBlocksClientNetworking.sendCustomSignTextUpdate(signEntity, text);
    }

    public static void sendCustomSignUpdate(CustomSignBlockEntity signEntity, int variant, boolean updateText, String[] text) {
        ClientPlayNetworking.send((class_8710)new CustomSignUpdatePayload((class_5321<class_1937>)signEntity.method_10997().method_27983(), signEntity.method_11016(), variant, updateText, updateText ? StringUtils.join((Object[])text, (String)"\n") : ""));
    }

    public static void sendPedestrianUpdate(PedestrianSignalBlockEntity entity, int headId, int state) {
        ClientPlayNetworking.send((class_8710)new PedestrianSignalUpdatePayload((class_5321<class_1937>)entity.method_10997().method_27983(), entity.method_11016(), headId, state));
    }

    public static void sendPedestrianHeadIdUpdate(PedestrianSignalBlockEntity entity, int headId) {
        CityBlocksClientNetworking.sendPedestrianUpdate(entity, headId, -1);
    }

    public static void sendPedestrianStateUpdate(PedestrianSignalBlockEntity entity, int state) {
        CityBlocksClientNetworking.sendPedestrianUpdate(entity, -1, state);
    }
}

