/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.block.ToasterBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleProcessingLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_7225;

public class ToasterBlockEntity
extends ElectricityModuleProcessingLootBlockEntity {
    public static final int[] INPUT_SLOTS = new int[]{0, 1};
    public static final int[] OUTPUT_SLOTS = new int[]{0, 1};
    protected boolean heating;
    protected boolean sync;

    public ToasterBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.TOASTER.get(), pos, state, 2, (class_3956<? extends ProcessingRecipe>)((class_3956)ModRecipeTypes.TOASTER_HEATING.get()));
    }

    public ToasterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, int containerSize, class_3956<? extends ProcessingRecipe.Item> recipeType) {
        super(type, pos, state, containerSize, recipeType);
    }

    @Override
    public void setNodePowered(boolean powered) {
        super.setNodePowered(powered);
        if (!powered && this.isHeating()) {
            this.setHeating(false);
        }
    }

    public void startHeating() {
        if (!this.heating && this.canProcessInput() && this.isNodePowered()) {
            this.setHeating(true);
        }
    }

    public boolean toggleHeating() {
        if (this.heating || this.canProcessInput() && this.isNodePowered()) {
            this.setHeating(!this.heating);
            return true;
        }
        return false;
    }

    private void setHeating(boolean heating) {
        this.heating = heating;
        this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ToasterBlock.POWERED, (Comparable)Boolean.valueOf(this.heating)), 3);
        this.playLeverSound(heating);
        this.sync();
    }

    public boolean isHeating() {
        return this.heating;
    }

    @Override
    public int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public int[] getEnergySlots() {
        return NO_SLOTS;
    }

    @Override
    protected boolean shouldProcessAll() {
        return true;
    }

    @Override
    public boolean canProcess() {
        return this.heating && super.canProcessInput();
    }

    @Override
    public void onCompleteProcess() {
        super.onCompleteProcess();
        this.setHeating(false);
        this.sync();
    }

    @Override
    protected boolean handleProcessed(class_1799 stack) {
        class_2338 pos = this.field_11867;
        class_1542 entity = new class_1542(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack.method_7972());
        entity.method_6988();
        entity.method_18799(new class_243(0.0, 0.35, 0.0));
        this.field_11863.method_8649((class_1297)entity);
        return true;
    }

    @Override
    public boolean processTick() {
        boolean result = super.processTick();
        if (this.sync) {
            BlockEntityHelper.sendCustomUpdate((class_2586)this, class_2586::method_16887);
            this.sync = false;
        }
        return result;
    }

    public int method_5444() {
        return 1;
    }

    @Override
    public boolean isMatchingContainerMenu(class_1703 menu) {
        return false;
    }

    protected class_2561 method_17823() {
        return Utils.translation("container", "toaster", new Object[0]);
    }

    protected class_1703 method_5465(int windowId, class_1661 playerInventory) {
        return null;
    }

    @Override
    public boolean method_5437(int slotIndex, class_1799 stack) {
        return !this.isHeating() && super.method_5437(slotIndex, stack);
    }

    @Override
    public boolean method_49104(class_1263 container, int slotIndex, class_1799 stack) {
        return !this.isHeating() && super.method_49104(container, slotIndex, stack);
    }

    public void method_5431() {
        super.method_5431();
        if (!this.field_11863.method_8608()) {
            this.sync();
        }
    }

    protected void sync() {
        this.sync = true;
    }

    public boolean insertItem(class_1799 heldItem) {
        if (this.isHeating()) {
            return false;
        }
        if (heldItem.method_7960() || this.isFull()) {
            return this.extractItem();
        }
        if (this.isRecipe(heldItem)) {
            for (int i = 0; i < this.method_5439(); ++i) {
                if (!this.method_5438(i).method_7960()) continue;
                class_1799 stack = heldItem.method_7972();
                stack.method_7939(1);
                heldItem.method_7934(1);
                this.method_5447(i, stack);
                this.playInsertSound();
                this.sync();
                return true;
            }
        }
        return false;
    }

    public boolean extractItem() {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960()) continue;
            class_2338 pos = this.field_11867;
            class_1542 entity = new class_1542(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, stack.method_7972());
            this.method_5447(i, class_1799.field_8037);
            this.field_11863.method_8649((class_1297)entity);
            this.sync();
            return true;
        }
        return false;
    }

    private boolean isFull() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    private void playLeverSound(boolean heating) {
        Preconditions.checkNotNull((Object)this.field_11863);
        class_3414 event = heating ? (class_3414)ModSounds.BLOCK_TOASTER_DOWN.get() : (class_3414)ModSounds.BLOCK_TOASTER_POP.get();
        this.field_11863.method_8396(null, this.field_11867, event, class_3419.field_15245, 1.0f, 0.9f + 0.1f * this.field_11863.field_9229.method_43057());
    }

    private void playInsertSound() {
        Preconditions.checkNotNull((Object)this.field_11863);
        this.field_11863.method_8396(null, this.field_11867, (class_3414)ModSounds.BLOCK_TOASTER_INSERT.get(), class_3419.field_15245, 0.5f, 0.9f + 0.1f * this.field_11863.field_9229.method_43057());
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, ToasterBlockEntity entity) {
        if (((Boolean)state.method_11654((class_2769)ToasterBlock.POWERED)).booleanValue()) {
            level.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0, 0.1 * level.field_9229.method_43058(), 0.0);
        }
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10573("Heating", 1)) {
            this.heating = tag.method_10577("Heating");
        }
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10556("Heating", this.heating);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }
}

