/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.IModuleNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public final class ElectricityTicker {
    private final class_1937 level;
    private final Map<class_2338, WeakReference<IModuleNode>> modules = new ConcurrentHashMap<class_2338, WeakReference<IModuleNode>>();
    private final Map<class_2338, WeakReference<ISourceNode>> sources = new ConcurrentHashMap<class_2338, WeakReference<ISourceNode>>();

    public ElectricityTicker(class_1937 level) {
        this.level = level;
    }

    public void addElectricityNode(IElectricityNode node) {
        if (node instanceof IModuleNode) {
            IModuleNode module = (IModuleNode)node;
            this.modules.put(node.getNodePosition(), new WeakReference<IModuleNode>(module));
        } else if (node instanceof ISourceNode) {
            ISourceNode source = (ISourceNode)node;
            this.sources.put(node.getNodePosition(), new WeakReference<ISourceNode>(source));
        }
    }

    public void earlyTick() {
        this.tickSet(this.modules, this::getModuleNode, IElectricityNode::earlyNodeTick);
        this.tickSet(this.sources, this::getSourceNode, IElectricityNode::earlyNodeTick);
    }

    public void tick() {
        this.tickSet(this.modules, this::getModuleNode, IModuleNode::moduleTick);
    }

    private <T extends IElectricityNode> void tickSet(Map<class_2338, WeakReference<T>> nodes, Function<class_2338, T> getter, BiConsumer<T, class_1937> ticker) {
        Iterator<class_2338> it = nodes.keySet().iterator();
        while (it.hasNext()) {
            class_2338 pos = it.next();
            IElectricityNode node = (IElectricityNode)getter.apply(pos);
            if (node == null) {
                Constants.LOG.debug("Stopping ticking node at {}", (Object)pos);
                it.remove();
                continue;
            }
            if (!this.level.method_41411(pos)) continue;
            ticker.accept(node, this.level);
        }
    }

    @Nullable
    private <T extends IElectricityNode> T getElectricityNode(Map<class_2338, WeakReference<T>> map, class_2338 pos, Function<class_2586, T> caster) {
        WeakReference<T> sourceRef = map.get(pos);
        if (sourceRef != null) {
            IElectricityNode node = (IElectricityNode)sourceRef.get();
            if (node == null && this.level.method_8477(pos) && (node = (IElectricityNode)caster.apply(this.level.method_8321(pos))) != null) {
                map.put(pos, new WeakReference<IElectricityNode>(node));
            }
            if (node != null && !node.getNodeOwner().method_11015()) {
                return (T)node;
            }
        }
        return null;
    }

    @Nullable
    private IModuleNode getModuleNode(class_2338 pos) {
        return this.getElectricityNode(this.modules, pos, entity -> {
            IModuleNode node;
            return entity instanceof IModuleNode ? (node = (IModuleNode)entity) : null;
        });
    }

    @Nullable
    private ISourceNode getSourceNode(class_2338 pos) {
        return this.getElectricityNode(this.sources, pos, entity -> {
            ISourceNode node;
            return entity instanceof ISourceNode ? (node = (ISourceNode)entity) : null;
        });
    }

    public static ElectricityTicker get(class_1937 level) {
        return ((Access)level).refurbishedFurniture$GetElectricityTicker();
    }

    public static interface Access {
        public ElectricityTicker refurbishedFurniture$GetElectricityTicker();
    }
}

