/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dan200.computercraft.client.model.EmissiveBakedModel;
import dan200.computercraft.client.model.ExtraModels;
import dan200.computercraft.client.model.turtle.UnbakedTurtleModel;
import dan200.computercraft.mixin.client.BlockModelAccessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;
import net.minecraft.class_793;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class CustomModelLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CustomModelLoader.class);
    private static final class_7654 converter = class_7654.method_45114((String)"models");
    private final Map<class_2960, class_1100> models = new HashMap<class_2960, class_1100>();
    private final Map<class_2960, String> emissiveModels = new HashMap<class_2960, String>();
    private final Collection<class_2960> extraModels;

    private CustomModelLoader(Collection<class_2960> extraModels) {
        this.extraModels = extraModels;
    }

    public static CompletableFuture<CustomModelLoader> prepare(class_3300 resources, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            CustomModelLoader loader = new CustomModelLoader(ExtraModels.loadAll(resources));
            for (Map.Entry resource : resources.method_14488("models", x -> x.method_12836().equals("computercraft") && x.method_12832().endsWith(".json")).entrySet()) {
                loader.loadModel((class_2960)resource.getKey(), (class_3298)resource.getValue());
            }
            return loader;
        }, executor);
    }

    private void loadModel(class_2960 path, class_3298 resource) {
        class_2960 id = converter.method_45115(path);
        try {
            String emissive;
            JsonObject model;
            try (BufferedReader reader = resource.method_43039();){
                model = class_3518.method_15255((Reader)reader).getAsJsonObject();
            }
            String loader = class_3518.method_15253((JsonObject)model, (String)"loader", null);
            if (loader != null) {
                switch (loader) {
                    case "computercraft:turtle": {
                        break;
                    }
                    default: {
                        throw new JsonParseException("Unknown model loader " + loader);
                    }
                }
                class_1100 unbaked = UnbakedTurtleModel.parse(model);
                this.models.put(id, unbaked);
            }
            if ((emissive = class_3518.method_15253((JsonObject)model, (String)"computercraft:emissive_texture", null)) != null) {
                this.emissiveModels.put(id, emissive);
            }
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            LOG.error("Couldn't parse model file {} from {}", new Object[]{id, path, e});
        }
    }

    public Collection<class_2960> getExtraModels() {
        return this.extraModels;
    }

    @Nullable
    public class_1100 loadModel(class_2960 path) {
        return path.method_12836().equals("computercraft") ? this.models.get(path) : null;
    }

    public class_1087 wrapModel(ModelModifier.AfterBake.Context ctx, class_1087 baked) {
        class_2960 id = ctx.resourceId();
        if (id == null || !id.method_12836().equals("computercraft")) {
            return baked;
        }
        class_1100 class_11002 = ctx.sourceModel();
        if (!(class_11002 instanceof class_793)) {
            return baked;
        }
        class_793 model = (class_793)class_11002;
        String emissive = this.getEmissive(id, model);
        return emissive == null ? baked : EmissiveBakedModel.wrap(baked, (class_1058)ctx.textureGetter().apply(model.method_24077(emissive)));
    }

    @Nullable
    private String getEmissive(class_2960 id, class_793 model) {
        do {
            String emissive;
            if ((emissive = this.emissiveModels.get(id)) != null) {
                return emissive;
            }
            id = ((BlockModelAccessor)model).computercraft$getParentLocation();
            model = ((BlockModelAccessor)model).computercraft$getParent();
        } while (id != null && model != null);
        return null;
    }
}

