/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model.turtle;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_4590;
import net.minecraft.class_777;
import org.joml.Matrix4f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class ModelTransformer {
    private static final int[] INVERSE_ORDER = new int[]{3, 2, 1, 0};
    private static final int STRIDE = 8;
    private static final int POS_OFFSET = 0;
    protected final Matrix4f transformation;
    protected final boolean invert;
    @Nullable
    private TransformedQuads cache;

    public ModelTransformer(class_4590 transformation) {
        this.transformation = transformation.method_22936();
        this.invert = transformation.method_22936().determinant() < 0.0f;
    }

    public List<class_777> transform(List<class_777> quads) {
        if (quads.isEmpty()) {
            return List.of();
        }
        TransformedQuads cache = this.cache;
        if (cache != null && quads.equals(cache.original())) {
            return cache.transformed();
        }
        ArrayList<class_777> transformed = new ArrayList<class_777>(quads.size());
        for (class_777 quad : quads) {
            transformed.add(this.transformQuad(quad));
        }
        this.cache = new TransformedQuads(quads, transformed);
        return transformed;
    }

    private class_777 transformQuad(class_777 quad) {
        int[] inputData = quad.method_3357();
        int[] outputData = new int[inputData.length];
        for (int i = 0; i < 4; ++i) {
            int inStart = 8 * i;
            int outStart = ModelTransformer.getVertexOffset(i, this.invert);
            System.arraycopy(inputData, inStart, outputData, outStart, 8);
            int inPosStart = inStart + 0;
            int outPosStart = outStart + 0;
            float x = Float.intBitsToFloat(inputData[inPosStart]);
            float y = Float.intBitsToFloat(inputData[inPosStart + 1]);
            float z = Float.intBitsToFloat(inputData[inPosStart + 2]);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            this.transformation.transformProject(pos);
            outputData[outPosStart] = Float.floatToRawIntBits(pos.x());
            outputData[outPosStart + 1] = Float.floatToRawIntBits(pos.y());
            outputData[outPosStart + 2] = Float.floatToRawIntBits(pos.z());
        }
        class_2350 direction = class_2350.method_23225((Matrix4f)this.transformation, (class_2350)quad.method_3358());
        return new class_777(outputData, quad.method_3359(), direction, quad.method_35788(), quad.method_24874());
    }

    public static int getVertexOffset(int vertex, boolean invert) {
        return (invert ? INVERSE_ORDER[vertex] : vertex) * 8;
    }

    @Environment(value=EnvType.CLIENT)
    private record TransformedQuads(List<class_777> original, List<class_777> transformed) {
    }
}

