/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;

class BlockModelProvider {
    private static final class_4945 CURSOR = class_4945.method_27043((String)"cursor");
    private static final class_4945 LEFT = class_4945.method_27043((String)"left");
    private static final class_4945 RIGHT = class_4945.method_27043((String)"right");
    private static final class_4945 BACKPACK = class_4945.method_27043((String)"backpack");
    private static final class_4942 COMPUTER_ON = new class_4942(Optional.of(class_2960.method_60655((String)"computercraft", (String)"block/computer_on")), Optional.empty(), new class_4945[]{class_4945.field_23016, class_4945.field_23018, class_4945.field_23015, CURSOR});
    private static final class_4942 MONITOR_BASE = new class_4942(Optional.of(class_2960.method_60655((String)"computercraft", (String)"block/monitor_base")), Optional.empty(), new class_4945[]{class_4945.field_23016, class_4945.field_23018, class_4945.field_23015, class_4945.field_23017});
    private static final class_4942 MODEM = new class_4942(Optional.of(class_2960.method_60655((String)"computercraft", (String)"block/modem")), Optional.empty(), new class_4945[]{class_4945.field_23016, class_4945.field_23017});
    private static final class_4942 TURTLE = new class_4942(Optional.of(class_2960.method_60655((String)"computercraft", (String)"block/turtle_base")), Optional.empty(), new class_4945[]{class_4945.field_23016, class_4945.field_23017, class_4945.field_23015, class_4945.field_23014, LEFT, RIGHT, BACKPACK});
    private static final class_4942 TURTLE_UPGRADE_LEFT = new class_4942(Optional.of(class_2960.method_60655((String)"computercraft", (String)"block/turtle_upgrade_base_left")), Optional.of("_left"), new class_4945[]{class_4945.field_23011});
    private static final class_4942 TURTLE_UPGRADE_RIGHT = new class_4942(Optional.of(class_2960.method_60655((String)"computercraft", (String)"block/turtle_upgrade_base_right")), Optional.of("_left"), new class_4945[]{class_4945.field_23011});
    private static final class_2746[] CABLE_DIRECTIONS = new class_2746[]{CableBlock.DOWN, CableBlock.UP, CableBlock.NORTH, CableBlock.SOUTH, CableBlock.WEST, CableBlock.EAST};
    private static final boolean[] BOOLEANS = new boolean[]{false, true};

    BlockModelProvider() {
    }

    public static void addBlockModels(class_4910 generators) {
        BlockModelProvider.registerComputer(generators, (ComputerBlock)ModRegistry.Blocks.COMPUTER_NORMAL.get());
        BlockModelProvider.registerComputer(generators, (ComputerBlock)ModRegistry.Blocks.COMPUTER_ADVANCED.get());
        BlockModelProvider.registerComputer(generators, (ComputerBlock)ModRegistry.Blocks.COMPUTER_COMMAND.get());
        BlockModelProvider.registerTurtle(generators, (TurtleBlock)ModRegistry.Blocks.TURTLE_NORMAL.get());
        BlockModelProvider.registerTurtle(generators, (TurtleBlock)ModRegistry.Blocks.TURTLE_ADVANCED.get());
        BlockModelProvider.registerWirelessModem(generators, (WirelessModemBlock)((Object)ModRegistry.Blocks.WIRELESS_MODEM_NORMAL.get()));
        BlockModelProvider.registerWirelessModem(generators, (WirelessModemBlock)((Object)ModRegistry.Blocks.WIRELESS_MODEM_ADVANCED.get()));
        BlockModelProvider.registerWiredModems(generators);
        BlockModelProvider.registerMonitor(generators, (MonitorBlock)((Object)ModRegistry.Blocks.MONITOR_NORMAL.get()));
        BlockModelProvider.registerMonitor(generators, (MonitorBlock)((Object)ModRegistry.Blocks.MONITOR_ADVANCED.get()));
        generators.method_25605((class_2248)ModRegistry.Blocks.SPEAKER.get(), class_4946.field_23042);
        BlockModelProvider.registerDiskDrive(generators);
        BlockModelProvider.registerPrinter(generators);
        BlockModelProvider.registerCable(generators);
        BlockModelProvider.registerTurtleUpgrade(generators, "block/turtle_crafting_table", "block/turtle_crafty_face");
        BlockModelProvider.registerTurtleUpgrade(generators, "block/turtle_speaker", "block/turtle_speaker_face");
        BlockModelProvider.registerTurtleModem(generators, "block/turtle_modem_normal", "block/wireless_modem_normal_face");
        BlockModelProvider.registerTurtleModem(generators, "block/turtle_modem_advanced", "block/wireless_modem_advanced_face");
        generators.field_22830.accept(class_4925.method_25770((class_2248)((class_2248)ModRegistry.Blocks.LECTERN.get()), (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25842((class_2248)class_2246.field_16330))).method_25775(BlockModelProvider.createHorizontalFacingDispatch()));
    }

    private static void registerDiskDrive(class_4910 generators) {
        DiskDriveBlock diskDrive = (DiskDriveBlock)((Object)ModRegistry.Blocks.DISK_DRIVE.get());
        generators.field_22830.accept(class_4925.method_25769((class_2248)diskDrive).method_25775(BlockModelProvider.createHorizontalFacingDispatch()).method_25775(BlockModelProvider.createModelDispatch(DiskDriveBlock.STATE, value -> {
            String textureSuffix = switch (value) {
                default -> throw new MatchException(null, null);
                case DiskDriveState.EMPTY -> "_front";
                case DiskDriveState.INVALID -> "_front_rejected";
                case DiskDriveState.FULL -> "_front_accepted";
            };
            return class_4943.field_22978.method_25847((class_2248)diskDrive, "_" + value.method_15434(), class_4944.method_25907((class_2248)diskDrive).method_25868(class_4945.field_23016, class_4944.method_25866((class_2248)diskDrive, (String)textureSuffix)), generators.field_22831);
        })));
        generators.method_25623((class_2248)diskDrive, class_4941.method_25843((class_2248)diskDrive, (String)"_empty"));
    }

    private static void registerPrinter(class_4910 generators) {
        PrinterBlock printer = (PrinterBlock)((Object)ModRegistry.Blocks.PRINTER.get());
        generators.field_22830.accept(class_4925.method_25769((class_2248)printer).method_25775(BlockModelProvider.createHorizontalFacingDispatch()).method_25775(BlockModelProvider.createModelDispatch(PrinterBlock.TOP, PrinterBlock.BOTTOM, (top, bottom) -> {
            String texture;
            String model;
            if (top.booleanValue() && bottom.booleanValue()) {
                model = "_both_full";
                texture = "_both_trays";
            } else if (top.booleanValue()) {
                model = "_top_full";
                texture = "_top_tray";
            } else if (bottom.booleanValue()) {
                model = "_bottom_full";
                texture = "_bottom_tray";
            } else {
                model = "_empty";
                texture = "_empty";
            }
            return class_4943.field_22978.method_25847((class_2248)printer, model, class_4944.method_25907((class_2248)printer).method_25868(class_4945.field_23016, class_4944.method_25866((class_2248)printer, (String)("_front" + texture))), generators.field_22831);
        })));
        generators.method_25623((class_2248)printer, class_4941.method_25843((class_2248)printer, (String)"_empty"));
    }

    private static void registerComputer(class_4910 generators, ComputerBlock<?> block) {
        generators.field_22830.accept(class_4925.method_25769(block).method_25775(BlockModelProvider.createHorizontalFacingDispatch()).method_25775(BlockModelProvider.createModelDispatch(ComputerBlock.STATE, state -> switch (state) {
            default -> throw new MatchException(null, null);
            case ComputerState.OFF -> class_4943.field_22978.method_25847((class_2248)block, "_" + state.method_15434(), class_4944.method_25907((class_2248)block), generators.field_22831);
            case ComputerState.ON, ComputerState.BLINKING -> COMPUTER_ON.method_25847((class_2248)block, "_" + state.method_15434(), class_4944.method_25907((class_2248)block).method_25868(CURSOR, class_2960.method_60655((String)"computercraft", (String)("block/computer" + state.getTexture()))), generators.field_22831);
        })));
        generators.method_25623(block, class_4941.method_25843(block, (String)"_blinking"));
    }

    private static void registerTurtle(class_4910 generators, TurtleBlock block) {
        class_2960 model = TURTLE.method_25846((class_2248)block, new class_4944().method_25868(class_4945.field_23016, class_4944.method_25866((class_2248)block, (String)"_front")).method_25868(class_4945.field_23017, class_4944.method_25866((class_2248)block, (String)"_back")).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom")).method_25868(LEFT, class_4944.method_25866((class_2248)block, (String)"_left")).method_25868(RIGHT, class_4944.method_25866((class_2248)block, (String)"_right")).method_25868(BACKPACK, class_4944.method_25866((class_2248)block, (String)"_backpack")), generators.field_22831);
        generators.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model)).method_25775(BlockModelProvider.createHorizontalFacingDispatch()));
        generators.field_22831.accept(class_4941.method_25840((class_1792)block.method_8389()), () -> {
            JsonObject out = new JsonObject();
            out.addProperty("loader", "computercraft:turtle");
            out.addProperty("model", model.toString());
            return out;
        });
    }

    private static void registerWirelessModem(class_4910 generators, WirelessModemBlock block) {
        generators.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockModelProvider.createFacingDispatch()).method_25775(BlockModelProvider.createModelDispatch(WirelessModemBlock.ON, on -> BlockModelProvider.modemModel(generators, class_4941.method_25843((class_2248)block, (String)(on != false ? "_on" : "_off")), class_4944.method_25866((class_2248)block, (String)("_face" + (on != false ? "_on" : "")))))));
        generators.method_25623((class_2248)block, class_4941.method_25843((class_2248)block, (String)"_off"));
    }

    private static void registerWiredModems(class_4910 generators) {
        WiredModemFullBlock fullBlock = (WiredModemFullBlock)((Object)ModRegistry.Blocks.WIRED_MODEM_FULL.get());
        generators.field_22830.accept(class_4925.method_25769((class_2248)fullBlock).method_25775(BlockModelProvider.createModelDispatch(WiredModemFullBlock.MODEM_ON, WiredModemFullBlock.PERIPHERAL_ON, (on, peripheral) -> {
            String suffix = (on != false ? "_on" : "_off") + (peripheral != false ? "_peripheral" : "");
            class_2960 faceTexture = class_2960.method_60655((String)"computercraft", (String)("block/wired_modem_face" + (peripheral != false ? "_peripheral" : "") + (on != false ? "_on" : "")));
            BlockModelProvider.modemModel(generators, class_2960.method_60655((String)"computercraft", (String)("block/wired_modem" + suffix)), faceTexture);
            return class_4943.field_22972.method_25852(class_4941.method_25843((class_2248)fullBlock, (String)suffix), new class_4944().method_25868(class_4945.field_23010, faceTexture), generators.field_22831);
        })));
        generators.method_25623((class_2248)fullBlock, class_4941.method_25843((class_2248)fullBlock, (String)"_off"));
        generators.method_25538((class_1792)ModRegistry.Items.WIRED_MODEM.get(), class_2960.method_60655((String)"computercraft", (String)"block/wired_modem_off"));
    }

    private static class_2960 modemModel(class_4910 generators, class_2960 name, class_2960 texture) {
        return MODEM.method_25852(name, new class_4944().method_25868(class_4945.field_23016, texture).method_25868(class_4945.field_23017, class_2960.method_60655((String)"computercraft", (String)"block/modem_back")), generators.field_22831);
    }

    private static void registerMonitor(class_4910 generators, MonitorBlock block) {
        BlockModelProvider.monitorModel(generators, block, "", 16, 4, 0, 32);
        BlockModelProvider.monitorModel(generators, block, "_d", 20, 7, 0, 36);
        BlockModelProvider.monitorModel(generators, block, "_l", 19, 4, 1, 33);
        BlockModelProvider.monitorModel(generators, block, "_ld", 31, 7, 1, 45);
        BlockModelProvider.monitorModel(generators, block, "_lr", 18, 4, 2, 34);
        BlockModelProvider.monitorModel(generators, block, "_lrd", 30, 7, 2, 46);
        BlockModelProvider.monitorModel(generators, block, "_lru", 24, 5, 2, 40);
        BlockModelProvider.monitorModel(generators, block, "_lrud", 27, 6, 2, 43);
        BlockModelProvider.monitorModel(generators, block, "_lu", 25, 5, 1, 39);
        BlockModelProvider.monitorModel(generators, block, "_lud", 28, 6, 1, 42);
        BlockModelProvider.monitorModel(generators, block, "_r", 17, 4, 3, 35);
        BlockModelProvider.monitorModel(generators, block, "_rd", 29, 7, 3, 47);
        BlockModelProvider.monitorModel(generators, block, "_ru", 23, 5, 3, 41);
        BlockModelProvider.monitorModel(generators, block, "_rud", 26, 6, 3, 44);
        BlockModelProvider.monitorModel(generators, block, "_u", 22, 5, 0, 38);
        BlockModelProvider.monitorModel(generators, block, "_ud", 21, 6, 0, 37);
        generators.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockModelProvider.createHorizontalFacingDispatch()).method_25775(BlockModelProvider.createVerticalFacingDispatch((class_2769<class_2350>)MonitorBlock.ORIENTATION)).method_25775(BlockModelProvider.createModelDispatch(MonitorBlock.STATE, edge -> class_4941.method_25843((class_2248)block, (String)(edge == MonitorEdgeState.NONE ? "" : "_" + edge.method_15434())))));
        generators.method_25623((class_2248)block, BlockModelProvider.monitorModel(generators, block, "_item", 15, 4, 0, 32));
    }

    private static class_2960 monitorModel(class_4910 generators, MonitorBlock block, String corners, int front, int side, int top, int back) {
        return MONITOR_BASE.method_25852(class_4941.method_25843((class_2248)block, (String)corners), new class_4944().method_25868(class_4945.field_23016, class_4944.method_25866((class_2248)block, (String)("_" + front))).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)("_" + side))).method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)("_" + top))).method_25868(class_4945.field_23017, class_4944.method_25866((class_2248)block, (String)("_" + back))), generators.field_22831);
    }

    private static void registerCable(class_4910 generators) {
        class_4922 generator = class_4922.method_25758((class_2248)((class_2248)ModRegistry.Blocks.CABLE.get()));
        class_2960 coreFacing = class_2960.method_60655((String)"computercraft", (String)"block/cable_core_facing");
        generator.method_25760(class_4918.method_25746((class_4918[])new class_4918[]{BlockModelProvider.cableNoNeighbour(class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039).method_25751((class_2769)CableBlock.UP, (Comparable)Boolean.valueOf(true)), BlockModelProvider.cableNoNeighbour(class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039).method_25751((class_2769)CableBlock.DOWN, (Comparable)Boolean.valueOf(true))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)coreFacing).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891));
        generator.method_25760(class_4918.method_25746((class_4918[])new class_4918[]{BlockModelProvider.cableNoNeighbour(class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039), BlockModelProvider.cableNoNeighbour(class_2350.field_11036, class_2350.field_11033, class_2350.field_11034, class_2350.field_11039).method_25751((class_2769)CableBlock.NORTH, (Comparable)Boolean.valueOf(true)), BlockModelProvider.cableNoNeighbour(class_2350.field_11036, class_2350.field_11033, class_2350.field_11034, class_2350.field_11039).method_25751((class_2769)CableBlock.SOUTH, (Comparable)Boolean.valueOf(true))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)coreFacing).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890));
        generator.method_25760(class_4918.method_25746((class_4918[])new class_4918[]{BlockModelProvider.cableNoNeighbour(class_2350.field_11043, class_2350.field_11035, class_2350.field_11036, class_2350.field_11033).method_25751((class_2769)CableBlock.EAST, (Comparable)Boolean.valueOf(true)), BlockModelProvider.cableNoNeighbour(class_2350.field_11043, class_2350.field_11035, class_2350.field_11036, class_2350.field_11033).method_25751((class_2769)CableBlock.WEST, (Comparable)Boolean.valueOf(true))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)coreFacing).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
        class_2960 core = class_2960.method_60655((String)"computercraft", (String)"block/cable_core_any");
        ArrayList<class_4918.class_4921> rightAngles = new ArrayList<class_4918.class_4921>();
        for (int i = 0; i < DirectionUtil.FACINGS.length; ++i) {
            for (int j = i; j < DirectionUtil.FACINGS.length; ++j) {
                if (DirectionUtil.FACINGS[i].method_10166() == DirectionUtil.FACINGS[j].method_10166()) continue;
                rightAngles.add(new class_4918.class_4921().method_25751((class_2769)CableBlock.CABLE, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)CABLE_DIRECTIONS[i], (Comparable)Boolean.valueOf(true)).method_25751((class_2769)CABLE_DIRECTIONS[j], (Comparable)Boolean.valueOf(true)));
            }
        }
        generator.method_25760(class_4918.method_25746((class_4918[])rightAngles.toArray(new class_4918[0])), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)core));
        class_2960 arm = class_2960.method_60655((String)"computercraft", (String)"block/cable_arm");
        for (class_2350 direction : DirectionUtil.FACINGS) {
            generator.method_25760((class_4918)new class_4918.class_4921().method_25751((class_2769)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)arm).method_25828(class_4936.field_22885, (Object)BlockModelProvider.toXAngle(direction.method_10153())).method_25828(class_4936.field_22886, (Object)BlockModelProvider.toYAngle(direction.method_10153())));
        }
        for (class_2350 direction : DirectionUtil.FACINGS) {
            for (boolean on : BOOLEANS) {
                for (boolean peripheral : BOOLEANS) {
                    String suffix = (on ? "_on" : "_off") + (peripheral ? "_peripheral" : "");
                    generator.method_25760((class_4918)new class_4918.class_4921().method_25751(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.from(direction, on, peripheral))), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_2960.method_60655((String)"computercraft", (String)("block/wired_modem" + suffix))).method_25828(class_4936.field_22885, (Object)BlockModelProvider.toXAngle(direction)).method_25828(class_4936.field_22886, (Object)BlockModelProvider.toYAngle(direction)));
                }
            }
        }
        generators.field_22830.accept(generator);
    }

    private static class_4918.class_4921 cableNoNeighbour(class_2350 ... directions) {
        class_4918.class_4921 condition = new class_4918.class_4921().method_25751((class_2769)CableBlock.CABLE, (Comparable)Boolean.valueOf(true));
        for (class_2350 direction : directions) {
            condition.method_25751((class_2769)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(false));
        }
        return condition;
    }

    private static void registerTurtleUpgrade(class_4910 generators, String name, String texture) {
        TURTLE_UPGRADE_LEFT.method_25852(class_2960.method_60655((String)"computercraft", (String)(name + "_left")), class_4944.method_25869((class_2960)class_2960.method_60655((String)"computercraft", (String)texture)), generators.field_22831);
        TURTLE_UPGRADE_RIGHT.method_25852(class_2960.method_60655((String)"computercraft", (String)(name + "_right")), class_4944.method_25869((class_2960)class_2960.method_60655((String)"computercraft", (String)texture)), generators.field_22831);
    }

    private static void registerTurtleModem(class_4910 generators, String name, String texture) {
        BlockModelProvider.registerTurtleUpgrade(generators, name + "_off", texture);
        BlockModelProvider.registerTurtleUpgrade(generators, name + "_on", texture + "_on");
    }

    private static class_4936.class_4937 toXAngle(class_2350 direction) {
        return switch (direction) {
            default -> class_4936.class_4937.field_22890;
            case class_2350.field_11036 -> class_4936.class_4937.field_22893;
            case class_2350.field_11033 -> class_4936.class_4937.field_22891;
        };
    }

    private static class_4936.class_4937 toYAngle(class_2350 direction) {
        return switch (direction) {
            default -> class_4936.class_4937.field_22890;
            case class_2350.field_11043 -> class_4936.class_4937.field_22890;
            case class_2350.field_11035 -> class_4936.class_4937.field_22892;
            case class_2350.field_11034 -> class_4936.class_4937.field_22891;
            case class_2350.field_11039 -> class_4936.class_4937.field_22893;
        };
    }

    private static class_4926 createHorizontalFacingDispatch() {
        class_4926.class_4927 dispatch = class_4926.method_25783((class_2769)class_2741.field_12481);
        for (class_2350 direction : class_2741.field_12481.method_11898()) {
            dispatch.method_25793((Comparable)direction, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)BlockModelProvider.toYAngle(direction)));
        }
        return dispatch;
    }

    private static class_4926 createVerticalFacingDispatch(class_2769<class_2350> property) {
        class_4926.class_4927 dispatch = class_4926.method_25783(property);
        for (class_2350 direction : property.method_11898()) {
            dispatch.method_25793((Comparable)direction, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)BlockModelProvider.toXAngle(direction)));
        }
        return dispatch;
    }

    private static class_4926 createFacingDispatch() {
        class_4926.class_4927 dispatch = class_4926.method_25783((class_2769)class_2741.field_12525);
        for (class_2350 direction : class_2741.field_12525.method_11898()) {
            dispatch.method_25793((Comparable)direction, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)BlockModelProvider.toYAngle(direction)).method_25828(class_4936.field_22885, (Object)BlockModelProvider.toXAngle(direction)));
        }
        return dispatch;
    }

    private static <T extends Comparable<T>> class_4926 createModelDispatch(class_2769<T> property, Function<T, class_2960> makeModel) {
        class_4926.class_4927 variant = class_4926.method_25783(property);
        for (Comparable value : property.method_11898()) {
            variant.method_25793(value, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)makeModel.apply(value)));
        }
        return variant;
    }

    private static <T extends Comparable<T>, U extends Comparable<U>> class_4926 createModelDispatch(class_2769<T> propertyT, class_2769<U> propertyU, BiFunction<T, U, class_2960> makeModel) {
        class_4926.class_4928 variant = class_4926.method_25784(propertyT, propertyU);
        for (Comparable valueT : propertyT.method_11898()) {
            for (Comparable valueU : propertyU.method_11898()) {
                variant.method_25797(valueT, valueU, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)makeModel.apply(valueT, valueU)));
            }
        }
        return variant;
    }
}

