/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.data.TurtleOverlays;
import dan200.computercraft.data.recipe.ShapedSpecBuilder;
import dan200.computercraft.data.recipe.ShapelessSpecBuilder;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.ClearColourRecipe;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapedRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapelessRecipe;
import dan200.computercraft.shared.recipe.ShapedRecipeSpec;
import dan200.computercraft.shared.recipe.ShapelessRecipeSpec;
import dan200.computercraft.shared.recipe.TransformShapedRecipe;
import dan200.computercraft.shared.recipe.TransformShapelessRecipe;
import dan200.computercraft.shared.recipe.function.CopyComponents;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.RegistryHelper;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_175;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7784;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import net.minecraft.class_9282;
import net.minecraft.class_9296;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

final class RecipeProvider
extends class_2446 {
    private final RecipeIngredients ingredients = PlatformHelper.get().getRecipeIngredients();
    private final CompletableFuture<class_7225.class_7874> registries;

    RecipeProvider(class_7784 output, CompletableFuture<class_7225.class_7874> registries) {
        super(output, registries);
        this.registries = registries;
    }

    private class_7225.class_7874 registries() {
        try {
            return this.registries.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted");
        }
        catch (ExecutionException e) {
            RuntimeException rt;
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (rt = (RuntimeException)cause) : new RuntimeException("Unexpected error", cause);
        }
    }

    public void method_10419(class_8790 add) {
        class_7225.class_7874 registries = this.registries();
        this.basicRecipes(add);
        this.diskColours(add);
        this.pocketUpgrades(add, registries);
        this.turtleUpgrades(add, registries);
        this.turtleOverlays(add, registries);
        RecipeProvider.addSpecial(add, new DiskRecipe(class_7710.field_40251));
        RecipeProvider.addSpecial(add, new ColourableRecipe(class_7710.field_40251));
        RecipeProvider.addSpecial(add, new ClearColourRecipe(class_7710.field_40251));
        RecipeProvider.addSpecial(add, new TurtleUpgradeRecipe(class_7710.field_40251));
        RecipeProvider.addSpecial(add, new PocketComputerUpgradeRecipe(class_7710.field_40251));
    }

    private void diskColours(class_8790 output) {
        for (Colour colour : Colour.VALUES) {
            ((ShapelessSpecBuilder)((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(class_7800.field_40636, DataComponentUtil.createStack((class_1935)ModRegistry.Items.DISK.get(), class_9334.field_49644, new class_9282(colour.getHex(), false))).requires(this.ingredients.redstone()).requires((class_1935)class_1802.field_8407).requires((class_1935)class_1769.method_7803((class_1767)RecipeProvider.ofColour(colour))).group("computercraft:disk")).unlockedBy("has_drive", RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.DISK_DRIVE.get()))).build(ImpostorShapelessRecipe::new).save(output, class_2960.method_60655((String)"computercraft", (String)("disk_" + (colour.ordinal() + 1))));
        }
    }

    private static List<TurtleItem> turtleItems() {
        return List.of((TurtleItem)ModRegistry.Items.TURTLE_NORMAL.get(), (TurtleItem)ModRegistry.Items.TURTLE_ADVANCED.get());
    }

    private void turtleUpgrades(class_8790 add, class_7225.class_7874 registries) {
        for (TurtleItem turtleItem : RecipeProvider.turtleItems()) {
            class_2960 name = RegistryHelper.getKeyOrThrow(class_7923.field_41178, turtleItem);
            registries.method_46762(ITurtleUpgrade.REGISTRY).method_42017().forEach(upgradeHolder -> {
                ITurtleUpgrade upgrade = (ITurtleUpgrade)upgradeHolder.comp_349();
                ((ShapedSpecBuilder)((ShapedSpecBuilder)ShapedSpecBuilder.shaped(class_7800.field_40636, DataComponentUtil.createStack((class_1935)turtleItem, (class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), UpgradeData.ofDefault(upgradeHolder))).group(name.toString())).pattern("#T").define('T', (class_1935)turtleItem).define('#', (class_1935)upgrade.getCraftingItem().method_7909()).unlockedBy("has_items", RecipeProvider.inventoryChange(new class_1935[]{turtleItem, upgrade.getCraftingItem().method_7909()}))).build(ImpostorShapedRecipe::new).save(add, name.method_48331(String.format("/%s/%s", upgradeHolder.method_40237().method_29177().method_12836(), upgradeHolder.method_40237().method_29177().method_12832())));
            });
        }
    }

    private static List<PocketComputerItem> pocketComputerItems() {
        return List.of((PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get(), (PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get());
    }

    private void pocketUpgrades(class_8790 add, class_7225.class_7874 registries) {
        for (PocketComputerItem pocket : RecipeProvider.pocketComputerItems()) {
            class_2960 name = RegistryHelper.getKeyOrThrow(class_7923.field_41178, pocket).method_45134(x -> x.replace("pocket_computer_", "pocket_"));
            registries.method_46762(IPocketUpgrade.REGISTRY).method_42017().forEach(upgradeHolder -> {
                IPocketUpgrade upgrade = (IPocketUpgrade)upgradeHolder.comp_349();
                ((ShapedSpecBuilder)((ShapedSpecBuilder)ShapedSpecBuilder.shaped(class_7800.field_40636, DataComponentUtil.createStack((class_1935)pocket, (class_9331)ModRegistry.DataComponents.POCKET_UPGRADE.get(), UpgradeData.ofDefault(upgradeHolder))).group(name.toString())).pattern("#").pattern("P").define('P', (class_1935)pocket).define('#', (class_1935)upgrade.getCraftingItem().method_7909()).unlockedBy("has_items", RecipeProvider.inventoryChange(new class_1935[]{pocket, upgrade.getCraftingItem().method_7909()}))).build(ImpostorShapedRecipe::new).save(add, name.method_48331(String.format("/%s/%s", upgradeHolder.method_40237().method_29177().method_12836(), upgradeHolder.method_40237().method_29177().method_12832())));
            });
        }
    }

    private void turtleOverlays(class_8790 add, class_7225.class_7874 registries) {
        this.turtleOverlay(add, registries, TurtleOverlays.TRANS_FLAG, x -> ((ShapelessSpecBuilder)x.unlockedBy("has_dye", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.dye())))).requires(ColourUtils.getDyeTag(class_1767.field_7951)).requires(ColourUtils.getDyeTag(class_1767.field_7954)).requires(ColourUtils.getDyeTag(class_1767.field_7952)).requires((class_1935)class_1802.field_8600));
        this.turtleOverlay(add, registries, TurtleOverlays.RAINBOW_FLAG, x -> ((ShapelessSpecBuilder)x.unlockedBy("has_dye", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.dye())))).requires(ColourUtils.getDyeTag(class_1767.field_7964)).requires(ColourUtils.getDyeTag(class_1767.field_7946)).requires(ColourUtils.getDyeTag(class_1767.field_7947)).requires(ColourUtils.getDyeTag(class_1767.field_7942)).requires(ColourUtils.getDyeTag(class_1767.field_7966)).requires(ColourUtils.getDyeTag(class_1767.field_7945)).requires((class_1935)class_1802.field_8600));
    }

    private void turtleOverlay(class_8790 add, class_7225.class_7874 registries, class_5321<TurtleOverlay> overlay, Consumer<ShapelessSpecBuilder> build) {
        class_6880.class_6883 holder = registries.method_46762(overlay.method_58273()).method_46747(overlay);
        for (TurtleItem turtleItem : RecipeProvider.turtleItems()) {
            class_2960 name = RegistryHelper.getKeyOrThrow(class_7923.field_41178, turtleItem);
            ShapelessSpecBuilder builder = (ShapelessSpecBuilder)((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(class_7800.field_40636, DataComponentUtil.createStack((class_1935)turtleItem, (class_9331)ModRegistry.DataComponents.OVERLAY.get(), holder)).group(name.method_48331("_overlay").toString())).unlockedBy("has_turtle", RecipeProvider.inventoryChange(new class_1935[]{turtleItem}));
            build.accept(builder);
            builder.requires((class_1935)turtleItem).build(s -> new TransformShapelessRecipe((ShapelessRecipeSpec)s, List.of(CopyComponents.builder((class_1935)turtleItem).exclude((class_9331)ModRegistry.DataComponents.OVERLAY.get()).build()))).save(add, name.method_48331("_overlays/" + overlay.method_29177().method_12832()));
        }
    }

    private void basicRecipes(class_8790 add) {
        class_2447.method_10436((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.CABLE.get()), (int)6).method_10439(" # ").method_10439("#R#").method_10439(" # ").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20391).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_modem", RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.COMPUTER_NORMAL.get())).method_10439("###").method_10439("#R#").method_10439("#G#").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20391).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_redstone", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.redstone()))).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get())).method_10439("###").method_10439("#R#").method_10439("#G#").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_components", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.redstone()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).method_10431(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(class_7800.field_40636, (class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get()).pattern("###").pattern("#C#").pattern("# #").define('#', this.ingredients.goldIngot()).define('C', (class_1935)ModRegistry.Items.COMPUTER_NORMAL.get()).unlockedBy("has_components", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((class_1935)ModRegistry.Items.COMPUTER_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot())))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((class_1935)ModRegistry.Items.COMPUTER_NORMAL.get())))).save(add, class_2960.method_60655((String)"computercraft", (String)"computer_advanced_upgrade"));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.COMPUTER_COMMAND.get())).method_10439("###").method_10439("#R#").method_10439("#G#").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('R'), (class_1935)class_1802.field_8866).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_components", RecipeProvider.inventoryChange(new class_1935[]{class_1802.field_8866})).method_10431(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(class_7800.field_40636, (class_1935)ModRegistry.Items.TURTLE_NORMAL.get()).pattern("###").pattern("#C#").pattern("#I#").define('#', this.ingredients.ironIngot()).define('C', (class_1935)ModRegistry.Items.COMPUTER_NORMAL.get()).define('I', this.ingredients.woodenChest()).unlockedBy("has_computer", RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.COMPUTER_NORMAL.get()))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((class_1935)ModRegistry.Items.COMPUTER_NORMAL.get())))).save(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(class_7800.field_40636, (class_1935)ModRegistry.Items.TURTLE_ADVANCED.get()).pattern("###").pattern("#C#").pattern("#I#").define('#', this.ingredients.goldIngot()).define('C', (class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get()).define('I', this.ingredients.woodenChest()).unlockedBy("has_computer", RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.COMPUTER_NORMAL.get()))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get())))).save(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(class_7800.field_40636, (class_1935)ModRegistry.Items.TURTLE_ADVANCED.get()).pattern("###").pattern("#C#").pattern(" B ").define('#', this.ingredients.goldIngot()).define('C', (class_1935)ModRegistry.Items.TURTLE_NORMAL.get()).define('B', this.ingredients.goldBlock()).unlockedBy("has_components", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((class_1935)ModRegistry.Items.TURTLE_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot())))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((class_1935)ModRegistry.Items.TURTLE_NORMAL.get())))).save(add, class_2960.method_60655((String)"computercraft", (String)"turtle_advanced_upgrade"));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.DISK_DRIVE.get())).method_10439("###").method_10439("#R#").method_10439("#R#").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20391).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.MONITOR_NORMAL.get())).method_10439("###").method_10439("#G#").method_10439("###").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20391).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10436((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.MONITOR_ADVANCED.get()), (int)4).method_10439("###").method_10439("#G#").method_10439("###").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get())).method_10439("###").method_10439("#A#").method_10439("#G#").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20391).method_10434(Character.valueOf('A'), (class_1935)class_1802.field_8463).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_apple", RecipeProvider.inventoryChange(new class_1935[]{class_1802.field_8463})).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get())).method_10439("###").method_10439("#A#").method_10439("#G#").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('A'), (class_1935)class_1802.field_8463).method_10428(Character.valueOf('G'), this.ingredients.glassPane()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_apple", RecipeProvider.inventoryChange(new class_1935[]{class_1802.field_8463})).method_10431(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(class_7800.field_40636, (class_1935)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get()).pattern("###").pattern("#C#").pattern("# #").define('#', this.ingredients.goldIngot()).define('C', (class_1935)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()).unlockedBy("has_components", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((class_1935)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot())))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((class_1935)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get())))).save(add, class_2960.method_60655((String)"computercraft", (String)"pocket_computer_advanced_upgrade"));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.PRINTER.get())).method_10439("###").method_10439("#R#").method_10439("#D#").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20391).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10428(Character.valueOf('D'), this.ingredients.dye()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.SPEAKER.get())).method_10439("###").method_10439("#N#").method_10439("#R#").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20391).method_10434(Character.valueOf('N'), (class_1935)class_1802.field_8643).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.WIRED_MODEM.get())).method_10439("###").method_10439("#R#").method_10439("###").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20391).method_10428(Character.valueOf('R'), this.ingredients.redstone()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_cable", RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.CABLE.get())).method_10431(add);
        class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.WIRED_MODEM_FULL.get())).method_10454((class_1935)ModRegistry.Items.WIRED_MODEM.get()).method_10442("has_modem", RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).method_17972(add, class_2960.method_60655((String)"computercraft", (String)"wired_modem_full_from"));
        class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.WIRED_MODEM.get())).method_10454((class_1935)ModRegistry.Items.WIRED_MODEM_FULL.get()).method_10442("has_modem", RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).method_17972(add, class_2960.method_60655((String)"computercraft", (String)"wired_modem_full_to"));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.WIRELESS_MODEM_NORMAL.get())).method_10439("###").method_10439("#E#").method_10439("###").method_10434(Character.valueOf('#'), (class_1935)class_1802.field_20391).method_10428(Character.valueOf('E'), this.ingredients.enderPearl()).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10431(add);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)((class_1935)ModRegistry.Items.WIRELESS_MODEM_ADVANCED.get())).method_10439("###").method_10439("#E#").method_10439("###").method_10428(Character.valueOf('#'), this.ingredients.goldIngot()).method_10434(Character.valueOf('E'), (class_1935)class_1802.field_8449).method_10429("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).method_10429("has_wireless", RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.WIRELESS_MODEM_NORMAL.get())).method_10431(add);
        ((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(class_7800.field_40635, RecipeProvider.playerHead("Cloudhunter", "6d074736-b1e9-4378-a99b-bd8777821c9c")).requires((class_6862<class_1792>)class_3489.field_48298).requires((class_1935)ModRegistry.Items.MONITOR_NORMAL.get()).unlockedBy("has_monitor", RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.MONITOR_NORMAL.get()))).build().save(add, class_2960.method_60655((String)"computercraft", (String)"skull_cloudy"));
        ((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(class_7800.field_40635, RecipeProvider.playerHead("dan200", "f3c8d69b-0776-4512-8434-d1b2165909eb")).requires((class_6862<class_1792>)class_3489.field_48298).requires((class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get()).unlockedBy("has_computer", RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.COMPUTER_ADVANCED.get()))).build().save(add, class_2960.method_60655((String)"computercraft", (String)"skull_dan200"));
        class_1856 pages = class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)ModRegistry.Items.PRINTED_PAGE.get(), (class_1935)ModRegistry.Items.PRINTED_PAGES.get(), class_1802.field_8407});
        ((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(class_7800.field_40636, (class_1935)ModRegistry.Items.PRINTED_PAGES.get()).requires(this.ingredients.string()).unlockedBy("has_printer", RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.PRINTER.get()))).build(x -> new PrintoutRecipe((ShapelessRecipeSpec)x, pages, 2)).save(add);
        ((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(class_7800.field_40636, (class_1935)ModRegistry.Items.PRINTED_BOOK.get()).requires(this.ingredients.leather()).requires(this.ingredients.string()).unlockedBy("has_printer", RecipeProvider.inventoryChange((class_1935)ModRegistry.Items.PRINTER.get()))).build(x -> new PrintoutRecipe((ShapelessRecipeSpec)x, pages, 1)).save(add);
    }

    private static class_1767 ofColour(Colour colour) {
        return class_1767.method_7791((int)(15 - colour.ordinal()));
    }

    private static class_175<class_2066.class_2068> inventoryChange(class_6862<class_1792> stack) {
        return class_2066.class_2068.method_8957((class_2073[])new class_2073[]{RecipeProvider.itemPredicate(stack)});
    }

    private static class_175<class_2066.class_2068> inventoryChange(class_1935 ... stack) {
        return class_2066.class_2068.method_8959((class_1935[])stack);
    }

    private static class_175<class_2066.class_2068> inventoryChange(class_2073 ... items) {
        return class_2066.class_2068.method_8957((class_2073[])items);
    }

    private static class_2073 itemPredicate(class_1935 item) {
        return class_2073.class_2074.method_8973().method_8977(new class_1935[]{item}).method_8976();
    }

    private static class_2073 itemPredicate(class_6862<class_1792> item) {
        return class_2073.class_2074.method_8973().method_8975(item).method_8976();
    }

    private static class_2073 itemPredicate(class_1856 ingredient) {
        JsonElement json = (JsonElement)class_1856.field_46096.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ingredient).getOrThrow();
        if (!(json instanceof JsonObject)) {
            throw new IllegalStateException("Unknown ingredient " + String.valueOf(json));
        }
        JsonObject object = (JsonObject)json;
        if (object.has("item")) {
            class_1799 item = (class_1799)class_1799.field_49267.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).getOrThrow();
            return RecipeProvider.itemPredicate((class_1935)item.method_7909());
        }
        if (object.has("tag")) {
            return RecipeProvider.itemPredicate((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)class_3518.method_15265((JsonObject)object, (String)"tag"))));
        }
        throw new IllegalArgumentException("Unknown ingredient " + String.valueOf(json));
    }

    private static class_1799 playerHead(String name, String uuid) {
        return DataComponentUtil.createStack((class_1935)class_1802.field_8575, class_9334.field_49617, new class_9296(new GameProfile(UUID.fromString(uuid), name)));
    }

    private static void addSpecial(class_8790 add, class_1860<?> recipe) {
        add.method_53819(RegistryHelper.getKeyOrThrow(class_7923.field_41189, recipe.method_8119()), recipe, null);
    }
}

