/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public abstract class AbstractComputerBlock<T extends AbstractComputerBlockEntity>
extends class_2383
implements IBundledRedstoneBlock,
class_2343 {
    protected final RegistryEntry<class_2591<T>> type;
    private final class_5558<T> serverTicker = (level, pos, state, computer) -> computer.serverTick();

    protected AbstractComputerBlock(class_4970.class_2251 settings, RegistryEntry<class_2591<T>> type) {
        super(settings);
        this.type = type;
    }

    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, world, pos, oldState, isMoving);
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)tile;
            computer.updateInputsImmediately();
        }
    }

    protected boolean method_9506(class_2680 state) {
        return true;
    }

    protected int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 incomingSide) {
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof AbstractComputerBlockEntity)) {
            return 0;
        }
        AbstractComputerBlockEntity computerEntity = (AbstractComputerBlockEntity)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(incomingSide.method_10153());
        return computer.getRedstoneOutput(localSide);
    }

    private class_1799 getItem(AbstractComputerBlockEntity tile) {
        class_1799 stack = new class_1799((class_1935)this);
        stack.method_57365(tile.method_57590());
        return stack;
    }

    protected int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 incomingSide) {
        return this.method_9603(state, world, pos, incomingSide);
    }

    @Override
    public int getBundledRedstoneOutput(class_1937 world, class_2338 pos, class_2350 side) {
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof AbstractComputerBlockEntity)) {
            return 0;
        }
        AbstractComputerBlockEntity computerEntity = (AbstractComputerBlockEntity)entity;
        ServerComputer computer = computerEntity.getServerComputer();
        if (computer == null) {
            return 0;
        }
        ComputerSide localSide = computerEntity.remapToLocalSide(side);
        return computer.getBundledRedstoneOutput(localSide);
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        AbstractComputerBlockEntity computer;
        class_1799 result;
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof AbstractComputerBlockEntity && !(result = this.getItem(computer = (AbstractComputerBlockEntity)tile)).method_7960()) {
            return result;
        }
        return super.method_9574(world, pos, state);
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 tile, class_1799 tool) {
        super.method_9556(world, player, pos, class_2246.field_10124.method_9564(), tile, tool);
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2248.method_9511((class_2680)state, (class_1937)world, (class_2338)pos, (class_2586)world.method_8321(pos), (class_1297)player, (class_1799)player.method_6047());
        return super.method_9576(world, pos, state, player);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862;
        if (!player.method_18276() && (class_25862 = level.method_8321(pos)) instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)class_25862;
            if (!level.field_9236 && computer.isUsable(player)) {
                ServerComputer serverComputer = computer.createServerComputer();
                serverComputer.turnOn();
                new ComputerContainerData(serverComputer, this.getItem(computer)).open(player, computer);
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return super.method_55766(state, level, pos, player, hit);
    }

    protected final void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 neighbourBlock, class_2338 neighbourPos, boolean isMoving) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)be;
            computer.neighborChanged(neighbourPos);
        }
    }

    public final void onNeighborChange(class_2680 state, class_4538 world, class_2338 pos, class_2338 neighbour) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)be;
            computer.neighborChanged(neighbour);
        }
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof AbstractComputerBlockEntity) {
            AbstractComputerBlockEntity computer = (AbstractComputerBlockEntity)be;
            computer.neighbourShapeChanged(direction);
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public <U extends class_2586> class_5558<U> method_31645(class_1937 level, class_2680 state, class_2591<U> type) {
        return level.field_9236 ? null : BlockEntityHelpers.createTickerHelper(type, (class_2591)this.type.get(), this.serverTicker);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ((class_2591)this.type.get()).method_11032(pos, state);
    }
}

