/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.DataComponentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9331;

public class UpgradeRecipeGenerator<T> {
    private final Function<class_1869, T> wrap;
    private final class_7225.class_7874 registries;
    private final Map<class_1792, List<UpgradeInfo>> upgradeItemLookup = new HashMap<class_1792, List<UpgradeInfo>>();
    private final List<UpgradeInfo> pocketUpgrades = new ArrayList<UpgradeInfo>();
    private final List<UpgradeInfo> turtleUpgrades = new ArrayList<UpgradeInfo>();
    private boolean initialised = false;

    public UpgradeRecipeGenerator(Function<class_1869, T> wrap, class_7225.class_7874 registries) {
        this.wrap = wrap;
        this.registries = registries;
    }

    private void setupCache() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        RecipeModHelpers.forEachRegistry(this.registries, ITurtleUpgrade.REGISTRY, holder -> {
            ITurtleUpgrade upgrade = (ITurtleUpgrade)holder.comp_349();
            class_1799 stack = upgrade.getCraftingItem();
            if (stack.method_7960()) {
                return;
            }
            UpgradeInfo info = new UpgradeInfo(stack, upgrade, (class_6880.class_6883<ITurtleUpgrade>)holder, null);
            this.upgradeItemLookup.computeIfAbsent(stack.method_7909(), k -> new ArrayList(1)).add(info);
            this.turtleUpgrades.add(info);
        });
        RecipeModHelpers.forEachRegistry(this.registries, IPocketUpgrade.REGISTRY, holder -> {
            IPocketUpgrade upgrade = (IPocketUpgrade)holder.comp_349();
            class_1799 stack = upgrade.getCraftingItem();
            if (stack.method_7960()) {
                return;
            }
            UpgradeInfo info = new UpgradeInfo(stack, upgrade, null, (class_6880.class_6883<IPocketUpgrade>)holder);
            this.upgradeItemLookup.computeIfAbsent(stack.method_7909(), k -> new ArrayList(1)).add(info);
            this.pocketUpgrades.add(info);
        });
    }

    public boolean isUpgrade(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        this.setupCache();
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.method_7909());
        if (upgrades == null) {
            return false;
        }
        for (UpgradeInfo upgrade : upgrades) {
            class_1799 craftingStack = upgrade.stack;
            if (craftingStack.method_7960() || craftingStack.method_7909() != stack.method_7909() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            return true;
        }
        return false;
    }

    public List<T> findRecipesWithInput(class_1799 stack) {
        this.setupCache();
        if (stack.method_7909() instanceof TurtleItem) {
            UpgradeData<ITurtleUpgrade> left = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null && right != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            class_1856 ingredient = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            for (UpgradeInfo upgrade : this.turtleUpgrades) {
                if (upgrade.turtle == null) {
                    throw new NullPointerException();
                }
                if (left == null) {
                    recipes.add(this.turtle(ingredient, upgrade.ingredient, UpgradeRecipeGenerator.turtleWith(stack, UpgradeData.ofDefault(upgrade.turtle), right)));
                }
                if (right != null) continue;
                recipes.add(this.turtle(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.turtleWith(stack, left, UpgradeData.ofDefault(upgrade.turtle))));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.method_7909() instanceof PocketComputerItem) {
            IPocketUpgrade back = PocketComputerItem.getUpgrade(stack);
            if (back != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            class_1856 ingredient = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            for (UpgradeInfo upgrade : this.pocketUpgrades) {
                if (upgrade.pocket == null) {
                    throw new NullPointerException();
                }
                recipes.add(this.pocket(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.pocketWith(stack, UpgradeData.ofDefault(upgrade.pocket))));
            }
            return Collections.unmodifiableList(recipes);
        }
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.method_7909());
        if (upgrades == null) {
            return List.of();
        }
        List recipes = null;
        boolean multiple = false;
        for (UpgradeInfo upgrade : upgrades) {
            class_1799 craftingStack = upgrade.stack;
            if (craftingStack.method_7960() || craftingStack.method_7909() != stack.method_7909() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            if (recipes == null) {
                recipes = upgrade.getRecipes();
                continue;
            }
            if (!multiple) {
                multiple = true;
                recipes = new ArrayList(recipes);
            }
            recipes.addAll(upgrade.getRecipes());
        }
        return recipes == null ? List.of() : Collections.unmodifiableList(recipes);
    }

    public List<T> findRecipesWithOutput(class_1799 stack) {
        if (stack.method_7909() instanceof TurtleItem) {
            ArrayList<T> recipes = new ArrayList<T>(0);
            UpgradeData<ITurtleUpgrade> left = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null) {
                recipes.add(this.turtle(class_1856.method_8101((class_1799[])new class_1799[]{UpgradeRecipeGenerator.turtleWith(stack, null, right)}), class_1856.method_8101((class_1799[])new class_1799[]{left.getUpgradeItem()}), stack));
            }
            if (right != null) {
                recipes.add(this.turtle(class_1856.method_8101((class_1799[])new class_1799[]{right.getUpgradeItem()}), class_1856.method_8101((class_1799[])new class_1799[]{UpgradeRecipeGenerator.turtleWith(stack, left, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.method_7909() instanceof PocketComputerItem) {
            ArrayList<T> recipes = new ArrayList<T>(0);
            UpgradeData<IPocketUpgrade> back = PocketComputerItem.getUpgradeWithData(stack);
            if (back != null) {
                recipes.add(this.pocket(class_1856.method_8101((class_1799[])new class_1799[]{back.getUpgradeItem()}), class_1856.method_8101((class_1799[])new class_1799[]{UpgradeRecipeGenerator.pocketWith(stack, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        return List.of();
    }

    private static class_1799 turtleWith(class_1799 stack, @Nullable UpgradeData<ITurtleUpgrade> left, @Nullable UpgradeData<ITurtleUpgrade> right) {
        class_1799 newStack = stack.method_46651(1);
        newStack.method_57379((class_9331)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get(), left);
        newStack.method_57379((class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), right);
        return newStack;
    }

    private static class_1799 pocketWith(class_1799 stack, @Nullable UpgradeData<IPocketUpgrade> back) {
        class_1799 newStack = stack.method_46651(1);
        newStack.method_57379((class_9331)ModRegistry.DataComponents.POCKET_UPGRADE.get(), back);
        return newStack;
    }

    private T pocket(class_1856 upgrade, class_1856 pocketComputer, class_1799 result) {
        return this.wrap.apply(new class_1869("", class_7710.field_40251, new class_8957(1, 2, class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{upgrade, pocketComputer}), Optional.empty()), result));
    }

    private T turtle(class_1856 left, class_1856 right, class_1799 result) {
        return this.wrap.apply(new class_1869("", class_7710.field_40251, new class_8957(2, 1, class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{left, right}), Optional.empty()), result));
    }

    private class UpgradeInfo {
        final class_1799 stack;
        final class_1856 ingredient;
        @Nullable
        final class_6880.class_6883<ITurtleUpgrade> turtle;
        @Nullable
        final class_6880.class_6883<IPocketUpgrade> pocket;
        final UpgradeBase upgrade;
        @Nullable
        private ArrayList<T> recipes;

        UpgradeInfo(class_1799 stack, @Nullable UpgradeBase upgrade, @Nullable class_6880.class_6883<ITurtleUpgrade> turtle, class_6880.class_6883<IPocketUpgrade> pocket) {
            this.stack = stack;
            this.ingredient = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            this.turtle = turtle;
            this.pocket = pocket;
            this.upgrade = upgrade;
        }

        List<T> getRecipes() {
            ArrayList<Object> recipes = this.recipes;
            if (recipes != null) {
                return recipes;
            }
            this.recipes = new ArrayList(4);
            recipes = this.recipes;
            if (this.turtle != null) {
                for (Supplier<IMedia> supplier : RecipeModHelpers.TURTLES) {
                    TurtleItem turtleItem = (TurtleItem)supplier.get();
                    recipes.add(UpgradeRecipeGenerator.this.turtle(this.ingredient, class_1856.method_8101((class_1799[])new class_1799[]{new class_1799((class_1935)turtleItem)}), DataComponentUtil.createStack((class_1935)turtleItem, (class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), UpgradeData.ofDefault(this.turtle))));
                }
            }
            if (this.pocket != null) {
                for (Supplier<IMedia> supplier : RecipeModHelpers.POCKET_COMPUTERS) {
                    PocketComputerItem pocketItem = (PocketComputerItem)supplier.get();
                    recipes.add(UpgradeRecipeGenerator.this.pocket(this.ingredient, class_1856.method_8091((class_1935[])new class_1935[]{pocketItem}), DataComponentUtil.createStack((class_1935)pocketItem, (class_9331)ModRegistry.DataComponents.POCKET_UPGRADE.get(), UpgradeData.ofDefault(this.pocket))));
                }
            }
            recipes.trimToSize();
            return recipes;
        }
    }
}

