/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.ModRegistry;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9322;
import net.minecraft.class_9331;

public record PrintoutData(String title, List<Line> lines) {
    public static final int LINE_LENGTH = 25;
    public static final int LINES_PER_PAGE = 21;
    public static final int MAX_PAGES = 16;
    public static final PrintoutData EMPTY;
    private static final Codec<String> LINE_TEXT;
    private static final Codec<Line> LINE_CODEC;
    private static final class_9139<ByteBuf, Line> LINE_STREAM_CODEC;
    public static final Codec<PrintoutData> CODEC;
    public static final class_9139<ByteBuf, PrintoutData> STREAM_CODEC;

    public PrintoutData {
        PrintoutData.validateLines(lines).getOrThrow(IllegalArgumentException::new);
    }

    private static DataResult<List<Line>> validateLines(List<Line> lines) {
        if (lines.isEmpty()) {
            return DataResult.error(() -> "Expected non-empty list of lines");
        }
        if (lines.size() % 21 != 0) {
            return DataResult.error(() -> "Not enough lines for a page");
        }
        if (lines.size() > 336) {
            return DataResult.error(() -> "Too many pages");
        }
        return DataResult.success(lines);
    }

    public static PrintoutData getOrEmpty(class_9322 holder) {
        return (PrintoutData)holder.method_57825((class_9331)ModRegistry.DataComponents.PRINTOUT.get(), (Object)EMPTY);
    }

    public int pages() {
        return Math.ceilDiv(this.lines.size(), 21);
    }

    static {
        Object[] lines = new Line[21];
        Arrays.fill(lines, Line.EMPTY);
        EMPTY = new PrintoutData("", List.of(lines));
        LINE_TEXT = Codec.STRING.validate(x -> x.length() == 25 ? DataResult.success((Object)x) : DataResult.error(() -> "Expected string of length 25"));
        LINE_CODEC = RecordCodecBuilder.create(s -> s.group((App)LINE_TEXT.fieldOf("text").forGetter(Line::text), (App)LINE_TEXT.fieldOf("foreground").forGetter(Line::foreground)).apply((Applicative)s, Line::new));
        LINE_STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, Line::text, (class_9139)class_9135.field_48554, Line::foreground, Line::new);
        CODEC = RecordCodecBuilder.create(s -> s.group((App)Codec.STRING.optionalFieldOf("title", (Object)"").forGetter(PrintoutData::title), (App)LINE_CODEC.listOf(1, 336).validate(PrintoutData::validateLines).fieldOf("lines").forGetter(PrintoutData::lines)).apply((Applicative)s, PrintoutData::new));
        STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, PrintoutData::title, (class_9139)LINE_STREAM_CODEC.method_56433(class_9135.method_58000((int)336)), PrintoutData::lines, PrintoutData::new);
    }

    public record Line(String text, String foreground) {
        public static final Line EMPTY = new Line(" ".repeat(25), "f".repeat(25));

        public Line {
            if (text.length() != 25) {
                throw new IllegalArgumentException("text is of wrong length");
            }
            if (foreground.length() != 25) {
                throw new IllegalArgumentException("foreground is of wrong length");
            }
        }
    }
}

